/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.key;

import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.key.BytesPublicKeySource;
import com.zerodeplibs.webpush.key.ECPublicKeyUtil;
import com.zerodeplibs.webpush.key.FileUtil;
import com.zerodeplibs.webpush.key.KeyObjectPublicKeySource;
import com.zerodeplibs.webpush.key.PEMParser;
import com.zerodeplibs.webpush.key.PEMParsers;
import com.zerodeplibs.webpush.key.PublicKeySource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.interfaces.ECPublicKey;

public class PublicKeySources {
    private PublicKeySources() {
    }

    public static PublicKeySource ofUncompressedBytes(byte[] uncompressedBytes) {
        return BytesPublicKeySource.ofUncompressed(uncompressedBytes, ECPublicKeyUtil::validateECPublicKey);
    }

    public static PublicKeySource ofX509Bytes(byte[] x509Bytes) {
        return BytesPublicKeySource.ofX509(x509Bytes, ECPublicKeyUtil::validateECPublicKey);
    }

    public static PublicKeySource ofPEMText(String pemText) {
        return PublicKeySources.ofPEMText(pemText, PEMParsers.ofStandard("PUBLIC KEY"));
    }

    public static PublicKeySource ofPEMText(String pemText, PEMParser parser) {
        WebPushPreConditions.checkNotNull(parser, "parser");
        return PublicKeySources.ofX509Bytes(parser.parse(pemText));
    }

    public static PublicKeySource ofPEMFile(Path path) throws IOException {
        return PublicKeySources.getPEMFileSourceBuilder(path).build();
    }

    public static PublicKeySource ofPEMFile(Path path, PEMParser parser) throws IOException {
        return PublicKeySources.getPEMFileSourceBuilder(path).parser(parser).build();
    }

    public static PublicKeySource ofDERFile(Path path) throws IOException {
        return PublicKeySources.ofX509Bytes(FileUtil.readAllBytes(path));
    }

    public static PublicKeySource ofECPublicKey(ECPublicKey publicKey) {
        return new KeyObjectPublicKeySource(publicKey, ECPublicKeyUtil::validateECPublicKey);
    }

    public static PEMFileSourceBuilder getPEMFileSourceBuilder(Path path) {
        return new PEMFileSourceBuilder(path);
    }

    public static class PEMFileSourceBuilder {
        private final Path path;
        private Charset charset = StandardCharsets.UTF_8;
        private PEMParser parser = PEMParsers.ofStandard("PUBLIC KEY");

        PEMFileSourceBuilder(Path path) {
            WebPushPreConditions.checkNotNull(path, "path");
            this.path = path;
        }

        public PEMFileSourceBuilder charset(Charset charset) {
            WebPushPreConditions.checkNotNull(charset, "charset");
            this.charset = charset;
            return this;
        }

        public PEMFileSourceBuilder parser(PEMParser parser) {
            WebPushPreConditions.checkNotNull(parser, "parser");
            this.parser = parser;
            return this;
        }

        public PublicKeySource build() throws IOException {
            byte[] parsed = this.parser.parse(FileUtil.readAsString(this.path, this.charset));
            return PublicKeySources.ofX509Bytes(parsed);
        }
    }
}

