/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.key;

import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.key.PEMParser;
import com.zerodeplibs.webpush.key.StandardPEMParser;

public class PEMParsers {
    private PEMParsers() {
    }

    public static PEMParser ofStandard(String label) {
        PEMParsers.checkLabel(label);
        return new StandardPEMParser(label);
    }

    private static void checkLabel(String label) {
        WebPushPreConditions.checkNotNull(label, "label");
        char[] labelChars = label.toCharArray();
        boolean isCharBeforeSpOrMinus = false;
        for (int i = 0; i < labelChars.length; ++i) {
            char current = labelChars[i];
            if (!PEMParsers.isValidLabelChar(current)) {
                if (!isCharBeforeSpOrMinus && PEMParsers.isSpaceOrMinus(current) && i != 0 && i != labelChars.length - 1) {
                    isCharBeforeSpOrMinus = true;
                    continue;
                }
                throw PEMParsers.constructInvalidLabelException(label);
            }
            isCharBeforeSpOrMinus = false;
        }
    }

    private static IllegalArgumentException constructInvalidLabelException(String label) {
        return new IllegalArgumentException(String.format("The input label is invalid: %s", label));
    }

    private static boolean isValidLabelChar(char c) {
        return '!' <= c && c <= ',' || '.' <= c && c <= '~';
    }

    private static boolean isSpaceOrMinus(char c) {
        return c == '-' || c == ' ';
    }
}

