/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.jwt;

import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.jwt.MalformedURLRuntimeException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class VAPIDJWTParam {
    private final String origin;
    private final Instant expirationTime;
    private final String subject;
    private final Map<String, Object> additionalClaims;

    private VAPIDJWTParam(String origin, Instant expirationTime, String subject, Map<String, Object> additionalClaims) {
        this.origin = origin;
        this.expirationTime = expirationTime;
        this.subject = subject;
        this.additionalClaims = additionalClaims;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public <T> Optional<T> getAdditionalClaim(String name, Class<T> returnType) {
        WebPushPreConditions.checkNotNull(name, "name");
        WebPushPreConditions.checkNotNull(returnType, "returnType");
        Object v = this.additionalClaims.get(name);
        if (returnType.isInstance(v)) {
            Object ret = v;
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public void forEachAdditionalClaim(BiConsumer<String, Object> action) {
        this.additionalClaims.forEach(action);
    }

    public Map<String, Object> getAdditionalClaims() {
        return this.additionalClaims;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Date getExpiresAt() {
        return Date.from(this.getExpirationTime());
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public long getExpiresAtInSeconds() {
        return this.getExpiresAt().getTime() / 1000L;
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VAPIDJWTParam)) {
            return false;
        }
        VAPIDJWTParam that = (VAPIDJWTParam)o;
        return this.getOrigin().equals(that.getOrigin()) && this.getExpirationTime().equals(that.getExpirationTime()) && Objects.equals(this.getSubject(), that.getSubject()) && this.additionalClaims.equals(that.additionalClaims);
    }

    public int hashCode() {
        return Objects.hash(this.getOrigin(), this.getExpirationTime(), this.getSubject(), this.additionalClaims);
    }

    public String toString() {
        return "VAPIDJWTParam{origin='" + this.origin + "', expirationTime=" + this.expirationTime + ", subject='" + this.subject + "', additionalClaims=" + this.additionalClaims + "}";
    }

    public static class Builder {
        private static final Map<String, String> RESERVED_NAMES_WITH_MESSAGE = Map.of("aud", "The \"aud\" claim should be specified via #resourceURL or #resourceURLString.", "exp", "The \"exp\" claim should be specified via #expirationTime or #expiresAfter.", "sub", "The \"sub\" claim should be specified via #subject.");
        private URL _resourceURL;
        private Instant _expirationTime;
        private String _subject;
        private final Map<String, Object> additionalClaims = new LinkedHashMap<String, Object>();
        private static final String MSG_RESOURCE_URL_NO_MORE_THAN_ONCE = "The methods for specifying a resource URL(resourceURLString/resourceURL) cannot be called more than once.";
        private static final String MSG_EXPIRES_AT_NO_MORE_THAN_ONCE = "The methods for specifying expiration time(expiresAfter/expirationTime) cannot be called more than once.";

        Builder() {
        }

        public Builder resourceURLString(String resourceURLString) {
            WebPushPreConditions.checkNotNull(resourceURLString, "resourceURLString");
            try {
                this.resourceURL(new URL(resourceURLString));
            }
            catch (MalformedURLException e) {
                throw MalformedURLRuntimeException.withDefaultMessage(e);
            }
            return this;
        }

        public Builder resourceURL(URL resourceURL) {
            WebPushPreConditions.checkNotNull(resourceURL, "resourceURL");
            WebPushPreConditions.checkState(this._resourceURL == null, MSG_RESOURCE_URL_NO_MORE_THAN_ONCE);
            this._resourceURL = resourceURL;
            return this;
        }

        public Builder expiresAfter(int expiresAfter, TimeUnit timeUnit) {
            WebPushPreConditions.checkNotNull((Object)timeUnit, "timeUnit");
            this.expirationTime(this.now().plus((long)expiresAfter, timeUnit.toChronoUnit()));
            return this;
        }

        public Builder expirationTime(Instant expirationTime) {
            WebPushPreConditions.checkNotNull(expirationTime, "expirationTime");
            WebPushPreConditions.checkState(this._expirationTime == null, MSG_EXPIRES_AT_NO_MORE_THAN_ONCE);
            this._expirationTime = expirationTime;
            return this;
        }

        public Builder subject(String subject) {
            WebPushPreConditions.checkNotNull(subject, "subject");
            this._subject = subject;
            return this;
        }

        public Builder additionalClaim(String name, Object value) {
            WebPushPreConditions.checkNotNull(name, "name");
            WebPushPreConditions.checkNotNull(value, "value");
            String errorMessage = RESERVED_NAMES_WITH_MESSAGE.get(name);
            WebPushPreConditions.checkArgument(errorMessage == null, errorMessage);
            this.additionalClaims.put(name, value);
            return this;
        }

        public VAPIDJWTParam build() {
            WebPushPreConditions.checkState(this._resourceURL != null, "The resource URL isn't specified.");
            WebPushPreConditions.checkState(this._expirationTime != null, "The expiration time isn't specified.");
            String origin = this._resourceURL.getProtocol() + "://" + this._resourceURL.getHost();
            int port = this._resourceURL.getPort();
            if (port != -1) {
                origin = origin + ":";
                origin = origin + String.valueOf(port);
            }
            return new VAPIDJWTParam(origin, this._expirationTime, this._subject, Collections.unmodifiableMap(this.additionalClaims));
        }

        public VAPIDJWTParam buildWithDefault() {
            if (this._expirationTime == null) {
                this._expirationTime = this.now().plus(3L, ChronoUnit.MINUTES);
            }
            return this.build();
        }

        Instant now() {
            return Instant.now();
        }
    }
}

