/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.httpclient;

import com.zerodeplibs.webpush.EncryptedPushMessage;
import com.zerodeplibs.webpush.header.TTL;
import com.zerodeplibs.webpush.header.Topic;
import com.zerodeplibs.webpush.header.Urgency;
import com.zerodeplibs.webpush.httpclient.PreparerBuilder;
import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.Optional;
import java.util.function.Consumer;

public class VertxWebClientRequestPreparer {
    private final PreparerBuilder.RequestPreparationInfo requestPreparationInfo;

    VertxWebClientRequestPreparer(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
        this.requestPreparationInfo = requestPreparationInfo;
    }

    public void sendBuffer(WebClient webClient, Consumer<HttpRequest<Buffer>> requestConsumer, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        WebPushPreConditions.checkNotNull(webClient, "webClient");
        WebPushPreConditions.checkNotNull(requestConsumer, "requestConsumer");
        WebPushPreConditions.checkNotNull(handler, "handler");
        HttpRequest request = webClient.postAbs(this.requestPreparationInfo.getEndpointUrl());
        request.putHeader("Authorization", this.requestPreparationInfo.getVapidHeader());
        request.putHeader(TTL.HEADER_NAME, this.requestPreparationInfo.getTtlString());
        request.putHeader(Urgency.HEADER_NAME, this.requestPreparationInfo.getUrgency());
        Optional<EncryptedPushMessage> encryptedPushMessage = this.requestPreparationInfo.getEncryptedPushMessage();
        if (encryptedPushMessage.isPresent()) {
            request.putHeader("Content-Type", encryptedPushMessage.get().mediaType());
            request.putHeader("Content-Encoding", encryptedPushMessage.get().contentEncoding());
        }
        this.requestPreparationInfo.getTopic().ifPresent(topic -> request.putHeader(Topic.HEADER_NAME, topic));
        requestConsumer.accept((HttpRequest<Buffer>)request);
        if (encryptedPushMessage.isPresent()) {
            request.sendBuffer(Buffer.buffer((byte[])encryptedPushMessage.get().toBytes()), handler);
        } else {
            request.sendBuffer(Buffer.buffer(), handler);
        }
    }

    public Future<HttpResponse<Buffer>> sendBuffer(WebClient webClient, Consumer<HttpRequest<Buffer>> requestConsumer) {
        Promise promise = Promise.promise();
        this.sendBuffer(webClient, requestConsumer, (Handler<AsyncResult<HttpResponse<Buffer>>>)promise);
        return promise.future();
    }

    public static PreparerBuilder<VertxWebClientRequestPreparer> getBuilder() {
        return new VertxWebClientRequestPreparerBuilder();
    }

    private static class VertxWebClientRequestPreparerBuilder
    extends PreparerBuilder<VertxWebClientRequestPreparer> {
        private VertxWebClientRequestPreparerBuilder() {
        }

        @Override
        protected VertxWebClientRequestPreparer buildInternal(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
            return new VertxWebClientRequestPreparer(requestPreparationInfo);
        }
    }
}

