/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.httpclient;

import com.zerodeplibs.webpush.EncryptedPushMessage;
import com.zerodeplibs.webpush.MessageEncryption;
import com.zerodeplibs.webpush.MessageEncryptions;
import com.zerodeplibs.webpush.PushMessage;
import com.zerodeplibs.webpush.PushSubscription;
import com.zerodeplibs.webpush.UserAgentMessageEncryptionKeyInfo;
import com.zerodeplibs.webpush.VAPIDKeyPair;
import com.zerodeplibs.webpush.header.TTL;
import com.zerodeplibs.webpush.header.Topic;
import com.zerodeplibs.webpush.header.Urgency;
import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.jwt.VAPIDJWTParam;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class PreparerBuilder<T> {
    private PushSubscription pushSubscription;
    private final VAPIDJWTParam.Builder vapidJWTParamBuilder = VAPIDJWTParam.getBuilder();
    private PushMessage pushMessage;
    private Long ttl;
    private String urgency;
    private String topic;

    protected PreparerBuilder() {
    }

    public PreparerBuilder<T> pushSubscription(PushSubscription pushSubscription) {
        WebPushPreConditions.checkNotNull(pushSubscription, "pushSubscription");
        WebPushPreConditions.checkNotNull(pushSubscription.getEndpoint(), "pushSubscription.endpoint");
        WebPushPreConditions.checkNotNull(pushSubscription.getKeys(), "pushSubscription.keys");
        WebPushPreConditions.checkNotNull(pushSubscription.getKeys().getP256dh(), "pushSubscription.keys.p256dh");
        WebPushPreConditions.checkNotNull(pushSubscription.getKeys().getAuth(), "pushSubscription.keys.auth");
        this.pushSubscription = pushSubscription;
        return this;
    }

    public PreparerBuilder<T> vapidJWTExpiresAfter(int expiresAfter, TimeUnit timeUnit) {
        this.vapidJWTParamBuilder.expiresAfter(expiresAfter, timeUnit);
        return this;
    }

    public PreparerBuilder<T> vapidJWTExpirationTime(Instant expirationTime) {
        this.vapidJWTParamBuilder.expirationTime(expirationTime);
        return this;
    }

    public PreparerBuilder<T> vapidJWTSubject(String subject) {
        this.vapidJWTParamBuilder.subject(subject);
        return this;
    }

    public PreparerBuilder<T> vapidJWTAdditionalClaim(String name, String value) {
        this.vapidJWTParamBuilder.additionalClaim(name, value);
        return this;
    }

    public PreparerBuilder<T> pushMessage(byte[] messageBytes) {
        this.pushMessage = PushMessage.of(messageBytes);
        return this;
    }

    public PreparerBuilder<T> pushMessage(String messageText) {
        this.pushMessage = PushMessage.ofUTF8(messageText);
        return this;
    }

    public PreparerBuilder<T> ttl(long ttl, TimeUnit timeUnit) {
        WebPushPreConditions.checkNotNull((Object)timeUnit, "timeUnit");
        this.ttl = TTL.seconds(timeUnit.toSeconds(ttl));
        return this;
    }

    public PreparerBuilder<T> urgency(Urgency.UrgencyOption urgencyOption) {
        WebPushPreConditions.checkNotNull((Object)urgencyOption, "urgencyOption");
        this.urgency = urgencyOption.getValue();
        return this;
    }

    public PreparerBuilder<T> urgencyHigh() {
        this.urgency(Urgency.UrgencyOption.HIGH);
        return this;
    }

    public PreparerBuilder<T> urgencyNormal() {
        this.urgency(Urgency.UrgencyOption.NORMAL);
        return this;
    }

    public PreparerBuilder<T> urgencyLow() {
        this.urgency(Urgency.UrgencyOption.LOW);
        return this;
    }

    public PreparerBuilder<T> urgencyVeryLow() {
        this.urgency(Urgency.UrgencyOption.VERY_LOW);
        return this;
    }

    public PreparerBuilder<T> topic(String topic) {
        this.topic = Topic.ensure(topic);
        return this;
    }

    public T build(VAPIDKeyPair vapidKeyPair) {
        WebPushPreConditions.checkNotNull(vapidKeyPair, "vapidKeyPair");
        WebPushPreConditions.checkState(this.pushSubscription != null, "The push subscription isn't specified.");
        this.setDefault();
        this.vapidJWTParamBuilder.resourceURLString(this.pushSubscription.getEndpoint());
        VAPIDJWTParam vapidjwtParam = this.vapidJWTParamBuilder.buildWithDefault();
        String credential = vapidKeyPair.generateAuthorizationHeaderValue(vapidjwtParam);
        EncryptedPushMessage encryptedPushMessage = null;
        if (this.pushMessage != null) {
            MessageEncryption messageEncryption = MessageEncryptions.of();
            encryptedPushMessage = messageEncryption.encrypt(UserAgentMessageEncryptionKeyInfo.from(this.pushSubscription.getKeys()), this.pushMessage);
        }
        RequestPreparationInfo requestPreparationInfo = new RequestPreparationInfo(this.pushSubscription.getEndpoint(), credential, encryptedPushMessage, this.ttl, this.urgency, this.topic);
        return this.buildInternal(requestPreparationInfo);
    }

    private void setDefault() {
        if (this.ttl == null) {
            this.ttl = TimeUnit.DAYS.toSeconds(1L);
        }
        if (this.urgency == null) {
            this.urgency = Urgency.normal();
        }
    }

    protected abstract T buildInternal(RequestPreparationInfo var1);

    public static class RequestPreparationInfo {
        private final String endpointUrl;
        private final String vapidHeader;
        private final Optional<EncryptedPushMessage> encryptedPushMessage;
        private final Long ttl;
        private final String urgency;
        private final Optional<String> topic;

        RequestPreparationInfo(String endpointUrl, String vapidHeader, EncryptedPushMessage encryptedPushMessage, Long ttl, String urgency, String topic) {
            this.endpointUrl = endpointUrl;
            this.vapidHeader = vapidHeader;
            this.encryptedPushMessage = Optional.ofNullable(encryptedPushMessage);
            this.ttl = ttl;
            this.urgency = urgency;
            this.topic = Optional.ofNullable(topic);
        }

        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        public String getVapidHeader() {
            return this.vapidHeader;
        }

        public Optional<EncryptedPushMessage> getEncryptedPushMessage() {
            return this.encryptedPushMessage;
        }

        public String getTtlString() {
            return this.ttl.toString();
        }

        public String getUrgency() {
            return this.urgency;
        }

        public Optional<String> getTopic() {
            return this.topic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestPreparationInfo that = (RequestPreparationInfo)o;
            return this.endpointUrl.equals(that.endpointUrl) && this.vapidHeader.equals(that.vapidHeader) && this.encryptedPushMessage.equals(that.encryptedPushMessage) && this.ttl.equals(that.ttl) && this.urgency.equals(that.urgency) && this.topic.equals(that.topic);
        }

        public int hashCode() {
            return Objects.hash(this.endpointUrl, this.vapidHeader, this.encryptedPushMessage, this.ttl, this.urgency, this.topic);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RequestPreparationInfo{");
            sb.append("endpointUrl='").append(this.endpointUrl).append('\'');
            sb.append(", vapidHeader='").append(this.vapidHeader).append('\'');
            this.encryptedPushMessage.ifPresent(enc -> sb.append(", encryptedPushMessage=").append(enc));
            sb.append(", ttl=").append(this.ttl);
            sb.append(", urgency='").append(this.urgency).append('\'');
            this.topic.ifPresent(t -> sb.append(", topic='").append((String)t).append('\''));
            sb.append('}');
            return sb.toString();
        }
    }
}

