/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.httpclient;

import com.zerodeplibs.webpush.header.TTL;
import com.zerodeplibs.webpush.header.Topic;
import com.zerodeplibs.webpush.header.Urgency;
import com.zerodeplibs.webpush.httpclient.PreparerBuilder;
import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import java.util.function.BiConsumer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;

public class JettyHttpClientRequestPreparer {
    private final PreparerBuilder.RequestPreparationInfo requestPreparationInfo;

    JettyHttpClientRequestPreparer(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
        this.requestPreparationInfo = requestPreparationInfo;
    }

    public static PreparerBuilder<JettyHttpClientRequestPreparer> getBuilder() {
        return new JettyHttpClientRequestPreparerBuilder();
    }

    public Request toRequest(HttpClient httpClient) {
        WebPushPreConditions.checkNotNull(httpClient, "httpClient");
        Request request = httpClient.POST(this.requestPreparationInfo.getEndpointUrl());
        this.setHttpFields((arg_0, arg_1) -> ((Request)request).header(arg_0, arg_1), request);
        return request;
    }

    private void setHttpFields(BiConsumer<String, String> setHeader, Request request) {
        setHeader.accept("Authorization", this.requestPreparationInfo.getVapidHeader());
        setHeader.accept(TTL.HEADER_NAME, this.requestPreparationInfo.getTtlString());
        setHeader.accept(Urgency.HEADER_NAME, this.requestPreparationInfo.getUrgency());
        this.requestPreparationInfo.getEncryptedPushMessage().ifPresent(encryptedPushMessage -> {
            setHeader.accept("Content-Encoding", encryptedPushMessage.contentEncoding());
            request.content((ContentProvider)new BytesContentProvider(encryptedPushMessage.mediaType(), (byte[][])new byte[][]{encryptedPushMessage.toBytes()}), encryptedPushMessage.mediaType());
        });
        this.requestPreparationInfo.getTopic().ifPresent(topic -> setHeader.accept(Topic.HEADER_NAME, (String)topic));
    }

    private static class JettyHttpClientRequestPreparerBuilder
    extends PreparerBuilder<JettyHttpClientRequestPreparer> {
        private JettyHttpClientRequestPreparerBuilder() {
        }

        @Override
        protected JettyHttpClientRequestPreparer buildInternal(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
            return new JettyHttpClientRequestPreparer(requestPreparationInfo);
        }
    }
}

