/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.httpclient;

import com.zerodeplibs.webpush.header.TTL;
import com.zerodeplibs.webpush.header.Topic;
import com.zerodeplibs.webpush.header.Urgency;
import com.zerodeplibs.webpush.httpclient.PreparerBuilder;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

public class ApacheHttpClientRequestPreparer {
    private final PreparerBuilder.RequestPreparationInfo requestPreparationInfo;

    ApacheHttpClientRequestPreparer(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
        this.requestPreparationInfo = requestPreparationInfo;
    }

    public static PreparerBuilder<ApacheHttpClientRequestPreparer> getBuilder() {
        return new ApacheHttpClientRequestPreparerBuilder();
    }

    public HttpPost toHttpPost() {
        HttpPost httpPost = new HttpPost(this.requestPreparationInfo.getEndpointUrl());
        httpPost.addHeader("Authorization", (Object)this.requestPreparationInfo.getVapidHeader());
        httpPost.addHeader(TTL.HEADER_NAME, (Object)this.requestPreparationInfo.getTtlString());
        httpPost.addHeader(Urgency.HEADER_NAME, (Object)this.requestPreparationInfo.getUrgency());
        this.requestPreparationInfo.getEncryptedPushMessage().ifPresent(encryptedPushMessage -> httpPost.setEntity((HttpEntity)new ByteArrayEntity(encryptedPushMessage.toBytes(), ContentType.create((String)encryptedPushMessage.mediaType()), encryptedPushMessage.contentEncoding())));
        if (!this.requestPreparationInfo.getEncryptedPushMessage().isPresent()) {
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(new byte[0], ContentType.APPLICATION_OCTET_STREAM));
        }
        this.requestPreparationInfo.getTopic().ifPresent(topic -> httpPost.addHeader(Topic.HEADER_NAME, topic));
        return httpPost;
    }

    public SimpleHttpRequest toSimpleHttpRequest() {
        SimpleRequestBuilder builder = SimpleRequestBuilder.create((String)"POST").setUri(this.requestPreparationInfo.getEndpointUrl()).addHeader("Authorization", this.requestPreparationInfo.getVapidHeader()).addHeader(TTL.HEADER_NAME, this.requestPreparationInfo.getTtlString()).addHeader(Urgency.HEADER_NAME, this.requestPreparationInfo.getUrgency());
        this.requestPreparationInfo.getEncryptedPushMessage().ifPresent(encryptedPushMessage -> builder.addHeader("Content-Encoding", encryptedPushMessage.contentEncoding()).setBody(encryptedPushMessage.toBytes(), ContentType.create((String)encryptedPushMessage.mediaType())));
        if (!this.requestPreparationInfo.getEncryptedPushMessage().isPresent()) {
            builder.setBody(new byte[0], ContentType.APPLICATION_OCTET_STREAM);
        }
        this.requestPreparationInfo.getTopic().ifPresent(topic -> builder.addHeader(Topic.HEADER_NAME, topic));
        return builder.build();
    }

    private static class ApacheHttpClientRequestPreparerBuilder
    extends PreparerBuilder<ApacheHttpClientRequestPreparer> {
        private ApacheHttpClientRequestPreparerBuilder() {
        }

        @Override
        protected ApacheHttpClientRequestPreparer buildInternal(PreparerBuilder.RequestPreparationInfo requestPreparationInfo) {
            return new ApacheHttpClientRequestPreparer(requestPreparationInfo);
        }
    }
}

