/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.header;

import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Topic {
    public static String HEADER_NAME = "Topic";
    private static final Pattern BASE64_URL_PATTERN = Pattern.compile("^[A-Za-z0-9\\-_]{1,32}$");
    private static final String MSG = "The Topic header field must be no more than 32 characters from the URL and a filename-safe Base 64 alphabet";

    private Topic() {
    }

    public static String ensure(String topic) {
        WebPushPreConditions.checkNotNull(topic, "topic");
        Matcher matcher = BASE64_URL_PATTERN.matcher(topic);
        WebPushPreConditions.checkArgument(matcher.matches(), MSG);
        return topic;
    }
}

