/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.expandableListView;

import android.content.Context;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.absListView.HelperViewHolder;
import com.zengcanxiang.baseAdapter.expandableListView.BaseAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class HelperAdapter<T>
extends BaseAdapter<T> {
    public HelperAdapter(List<List<T>> data, Context context, int[] groupLayoutIds, int ... childLayoutIds) {
        super(data, context, groupLayoutIds, childLayoutIds);
    }

    @Override
    public <BH extends BaseViewHolder> void convertGroup(BH viewHolder, int groupPosition, List<T> childs) {
        HelperViewHolder holder = (HelperViewHolder)viewHolder;
        this.HelpConvertGroup(holder, groupPosition, childs);
    }

    @Override
    public <BH extends BaseViewHolder> void convertChild(BH viewHolder, int groupPosition, int childPosition, T t) {
        HelperViewHolder holder = (HelperViewHolder)viewHolder;
        this.HelpConvertChild(holder, groupPosition, childPosition, t);
    }

    public abstract void HelpConvertGroup(HelperViewHolder var1, int var2, List<T> var3);

    public abstract void HelpConvertChild(HelperViewHolder var1, int var2, int var3, T var4);

    public boolean isEnabled() {
        if (this.mList == null) {
            return false;
        }
        return this.mList.size() > 0;
    }

    public boolean addAll(int startPosition, List<List<T>> datas) {
        this.initList();
        boolean result = this.mList.addAll(startPosition < 0 ? 0 : startPosition, datas);
        this.notifyDataSetChanged();
        return result;
    }

    public void addAGroupToHead(List<T> addData) {
        this.addAGroup(0, addData);
    }

    public void addAGroupToLast(List<T> addData) {
        this.initList();
        this.addAGroup(this.mList.size() - 1, addData);
    }

    public boolean addAGroup(int startPosition, List<T> addData) {
        ArrayList<List<T>> temp = new ArrayList<List<T>>();
        temp.add(addData);
        return this.addAll(startPosition, temp);
    }

    public void removeAGroup(int removePosition) {
        this.initList();
        this.mList.remove(removePosition);
        this.notifyDataSetChanged();
    }

    public boolean removeAGroup(List<T> removeData) {
        this.initList();
        boolean result = this.mList.remove(removeData);
        this.notifyDataSetChanged();
        return result;
    }

    public void alterAGroup(int startPosition, List<T> aGroup) {
        this.initList();
        this.mList.set(startPosition, aGroup);
        this.notifyDataSetChanged();
    }

    public void addAChild(int startPosition, int groupIndex, T child) {
        this.throwException();
        ((List)this.mList.get(groupIndex)).add(startPosition < 0 ? 0 : startPosition, child);
        this.notifyDataSetChanged();
    }

    public void addAChildToHead(int groupIndex, T child) {
        this.throwException();
        this.addAChild(0, groupIndex, child);
    }

    public void addAChildToLast(int groupIndex, T child) {
        this.throwException();
        this.addAChild(this.mList.size() - 1, groupIndex, child);
    }

    public void removeAChild(int groupIndex, int removePosition) {
        this.throwException();
        ((List)this.mList.get(groupIndex)).remove(removePosition);
        this.notifyDataSetChanged();
    }

    public boolean removeAChild(int groupIndex, T removeData) {
        this.throwException();
        boolean result = ((List)this.mList.get(groupIndex)).remove(removeData);
        this.notifyDataSetChanged();
        return result;
    }

    public void alterAChild(int startPosition, int groupIndex, T aChild) {
        this.throwException();
        ((List)this.mList.get(groupIndex)).set(startPosition, aChild);
        this.notifyDataSetChanged();
    }

    public boolean containsAGroup(List<T> data) {
        this.initList();
        return this.mList.contains(data);
    }

    public boolean containsAChild(int groupIndex, T data) {
        this.throwException();
        return ((List)this.mList.get(groupIndex)).contains(data);
    }

    public void replaceAll(List<List<T>> datas) {
        this.initList();
        this.mList.clear();
        this.addAll(0, datas);
    }

    public void clear() {
        this.initList();
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    private void initList() {
        if (this.mList == null) {
            this.mList = new ArrayList();
        }
    }

    private void throwException() {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
    }
}

