/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.text.util.Linkify;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.zengcanxiang.baseAdapter.interFace.ViewHelper;
import com.zengcanxiang.baseAdapter.recyclerView.BaseViewHolder;

public class HelperViewHolder
extends BaseViewHolder
implements ViewHelper.RecyclerView<HelperViewHolder> {
    public HelperViewHolder(Context context, int layoutId, View itemView) {
        super(context, layoutId, itemView);
    }

    @Override
    public HelperViewHolder setText(int viewId, String value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    @Override
    public HelperViewHolder setImageResource(int viewId, int imgResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imgResId);
        return this;
    }

    @Override
    public HelperViewHolder setBackgroundColor(int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    @Override
    public HelperViewHolder setBackgroundColorRes(int viewId, int colorRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(colorRes);
        return this;
    }

    @Override
    public HelperViewHolder setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    @Override
    public HelperViewHolder setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    @Override
    public HelperViewHolder setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    @Override
    public HelperViewHolder setImageDrawableRes(int viewId, int drawableRes) {
        Drawable drawable = this.mContext.getResources().getDrawable(drawableRes);
        return this.setImageDrawable(viewId, drawable);
    }

    @Override
    public HelperViewHolder setImageUrl(int viewId, String imgUrl) {
        return null;
    }

    @Override
    public HelperViewHolder setImageBitmap(int viewId, Bitmap imgBitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(imgBitmap);
        return this;
    }

    @Override
    public HelperViewHolder setVisible(int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    @Override
    public HelperViewHolder setTag(int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    @Override
    public HelperViewHolder setTag(int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    @Override
    public HelperViewHolder setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    @Override
    public HelperViewHolder setAdapter(int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    @Override
    public HelperViewHolder setAdapter(int viewId, RecyclerView.Adapter adapter) {
        RecyclerView view = (RecyclerView)this.getView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    @Override
    public HelperViewHolder setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    @Override
    public HelperViewHolder linkify(int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    @Override
    public HelperViewHolder setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.getView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    @Override
    public HelperViewHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    @Override
    public HelperViewHolder setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    @Override
    public HelperViewHolder setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    @Override
    public HelperViewHolder setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    @Override
    public HelperViewHolder setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    @Override
    public HelperViewHolder setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }
}

