/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.interFace.DataHelper;
import com.zengcanxiang.baseAdapter.recyclerView.BH;
import com.zengcanxiang.baseAdapter.recyclerView.BaseRecyclerViewAdapter;
import com.zengcanxiang.baseAdapter.recyclerView.HelperRecyclerViewHolder;
import java.util.List;

public abstract class HelperRecyclerViewAdapter<T>
extends BaseRecyclerViewAdapter<T>
implements DataHelper<T> {
    public HelperRecyclerViewAdapter(List<T> data, Context context, int ... layoutId) {
        super(data, context, layoutId);
    }

    @Override
    public BH onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType < 0 || viewType > this.mLayoutId.length) {
            throw new ArrayIndexOutOfBoundsException("checkLayout > LayoutId.length");
        }
        if (this.mLayoutId.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        int layoutId = this.mLayoutId[viewType];
        View view = this.inflateItemView(layoutId, parent);
        HelperRecyclerViewHolder holder = (HelperRecyclerViewHolder)view.getTag();
        if (holder == null || holder.getLayoutId() != layoutId) {
            holder = new HelperRecyclerViewHolder(this.mContext, layoutId, view);
        }
        return holder;
    }

    @Override
    protected void onBindData(BH viewHolder, int position, T item) {
        HelperRecyclerViewHolder helperViewHolder = (HelperRecyclerViewHolder)viewHolder;
        this.HelperBindData(helperViewHolder, position, item);
        this.setListener(helperViewHolder, position, item);
    }

    protected abstract void HelperBindData(HelperRecyclerViewHolder var1, int var2, T var3);

    protected void setListener(HelperRecyclerViewHolder viewHolder, int position, T item) {
    }

    @Override
    public boolean isEnabled(int position) {
        return position < this.mList.size();
    }

    @Override
    public void addItemToHead(T data) {
        this.add(0, data);
    }

    @Override
    public boolean addItemToLast(T data) {
        boolean result = this.mList.add(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addItemsToHead(List<T> datas) {
        return this.addAll(0, datas);
    }

    @Override
    public boolean addItemsToLast(List<T> datas) {
        return this.mList.addAll(datas);
    }

    @Override
    public boolean addAll(int startPosition, List<T> datas) {
        boolean result = this.mList.addAll(startPosition, datas);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(int startPosition, T data) {
        this.mList.add(startPosition, data);
        this.notifyDataSetChanged();
    }

    @Override
    public T getData(int index) {
        return this.getItemCount() == 0 ? null : (T)this.mList.get(index);
    }

    @Override
    public void alterObj(T oldData, T newData) {
        this.alterObj(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void alterObj(int index, T data) {
        this.mList.set(index, data);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean remove(T data) {
        boolean result = this.mList.remove(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void removeToIndex(int index) {
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> data) {
        this.mList.clear();
        this.addAll(0, data);
    }

    @Override
    public void clear() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        return this.mList.contains(data);
    }
}

