/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.luben.zstd.ZstdInputStream;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class TransactionPayloadEventDataDeserializer
implements EventDataDeserializer<TransactionPayloadEventData> {
    public static final int OTW_PAYLOAD_HEADER_END_MARK = 0;
    public static final int OTW_PAYLOAD_SIZE_FIELD = 1;
    public static final int OTW_PAYLOAD_COMPRESSION_TYPE_FIELD = 2;
    public static final int OTW_PAYLOAD_UNCOMPRESSED_SIZE_FIELD = 3;

    @Override
    public TransactionPayloadEventData deserialize(com.github.shyiko.mysql.binlog.io.ByteArrayInputStream inputStream) throws IOException {
        TransactionPayloadEventData eventData = new TransactionPayloadEventData();
        block5: while (inputStream.available() > 0) {
            int fieldType = 0;
            int fieldLen = 0;
            if (inputStream.available() >= 1) {
                fieldType = inputStream.readPackedInteger();
            }
            if (fieldType == 0) break;
            if (inputStream.available() >= 1) {
                fieldLen = inputStream.readPackedInteger();
            }
            switch (fieldType) {
                case 1: {
                    eventData.setPayloadSize(inputStream.readPackedInteger());
                    continue block5;
                }
                case 2: {
                    eventData.setCompressionType(inputStream.readPackedInteger());
                    continue block5;
                }
                case 3: {
                    eventData.setUncompressedSize(inputStream.readPackedLong());
                    continue block5;
                }
            }
            inputStream.read(fieldLen);
        }
        if (eventData.getUncompressedSize() == 0L) {
            eventData.setUncompressedSize(eventData.getPayloadSize());
        }
        eventData.setPayload(inputStream.read(eventData.getPayloadSize()));
        ArrayList<Event> decompressedEvents = TransactionPayloadEventDataDeserializer.getDecompressedEvents(eventData);
        eventData.setUncompressedEvents(decompressedEvents);
        return eventData;
    }

    private static ArrayList<Event> getDecompressedEvents(TransactionPayloadEventData eventData) throws IOException {
        ArrayList<Event> decompressedEvents = new ArrayList<Event>();
        EventDeserializer transactionPayloadEventDeserializer = new EventDeserializer();
        try (ZstdInputStream zstdInputStream = new ZstdInputStream((InputStream)new ByteArrayInputStream(eventData.getPayload()));){
            com.github.shyiko.mysql.binlog.io.ByteArrayInputStream destinationInputStream = new com.github.shyiko.mysql.binlog.io.ByteArrayInputStream((InputStream)zstdInputStream);
            Event internalEvent = transactionPayloadEventDeserializer.nextEvent(destinationInputStream);
            while (internalEvent != null) {
                decompressedEvents.add(internalEvent);
                internalEvent = transactionPayloadEventDeserializer.nextEvent(destinationInputStream);
            }
        }
        return decompressedEvents;
    }
}

