/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakTask
implements Runnable {
    public static final LeakTask NO_LEAK;
    private static final Logger LOGGER;
    private ScheduledExecutorService executorService;
    private long leakDetectionThreshold;
    private ScheduledFuture<?> scheduledFuture;
    private Exception exception;

    public LeakTask(long leakDetectionThreshold, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    private LeakTask() {
    }

    private LeakTask(LeakTask parent) {
        this.exception = new Exception();
        this.scheduledFuture = parent.executorService.schedule(this, parent.leakDetectionThreshold, TimeUnit.MILLISECONDS);
    }

    public LeakTask start() {
        return new LeakTask(this);
    }

    @Override
    public void run() {
        StackTraceElement[] stackTrace = this.exception.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[stackTrace.length - 3];
        System.arraycopy(stackTrace, 3, trace, 0, trace.length);
        this.exception.setStackTrace(trace);
        LOGGER.warn("Connection leak detection triggered, stack trace follows", (Throwable)this.exception);
    }

    public void cancel() {
        this.scheduledFuture.cancel(false);
    }

    static {
        LOGGER = LoggerFactory.getLogger(LeakTask.class);
        NO_LEAK = new LeakTask(){

            @Override
            public void cancel() {
            }

            @Override
            public LeakTask start() {
                return this;
            }
        };
    }
}

