/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util.logging;

import android.os.Environment;
import android.util.Log;
import com.yy.androidlib.util.logging.LogToES;
import com.yy.androidlib.util.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IllegalFormatException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class YYAppender
implements Logger.Appender {
    private static final String TAG = "YYAppender";
    private volatile LogOptions sOptions = new LogOptions();
    private final ExecutorService THREAD = Executors.newSingleThreadExecutor();
    private int callerStackTraceIndex = 7;

    @Override
    public void write(Logger.Level level, Object tag, String message) {
        switch (level) {
            case VERBOSE: {
                this.verbose(tag, message, new Object[0]);
                break;
            }
            case DEBUG: {
                this.debug(tag, message, new Object[0]);
                break;
            }
            case INFO: {
                this.info(tag, message, new Object[0]);
                break;
            }
            case WARN: {
                this.warn(tag, message, new Object[0]);
                break;
            }
            case ERROR: {
                this.error(tag, message, new Object[0]);
                break;
            }
            default: {
                Log.w((String)TAG, (String)String.format("Unknown level to write log, level: %s, message: %s", new Object[]{level, message}));
            }
        }
    }

    public YYAppender(String directory, LogOptions options) {
        this.setOptions(options);
        LogToES.setLogPath(directory);
    }

    public YYAppender(String directory) {
        LogToES.setLogPath(directory);
    }

    public LogOutputPaths getLogOutputPaths() {
        LogOutputPaths ret = new LogOutputPaths();
        if (!this.getLogOutputPaths(ret)) {
            Log.e((String)TAG, (String)"failed to get log output paths.");
        }
        return ret;
    }

    public boolean getLogOutputPaths(LogOutputPaths out) {
        return LogToES.getLogOutputPaths(out, this.sOptions.logFileName);
    }

    public void setUniformTag(String tag) {
        if (tag != null && tag.length() != 0) {
            this.sOptions.uniformTag = tag;
        }
    }

    public String getLogPath() {
        return LogToES.getLogPath();
    }

    public LogOptions getOptions() {
        return this.sOptions;
    }

    private boolean setOptions(LogOptions options) {
        LogOptions tmpOp;
        this.sOptions = tmpOp = options == null ? new LogOptions() : options;
        LogToES.setBackupLogLimitInMB(tmpOp.backUpLogLimitInMB);
        LogToES.setBuffSize(tmpOp.buffSizeInBytes);
        return tmpOp.buffSizeInBytes > 0 && !this.isNullOrEmpty(tmpOp.logFileName);
    }

    public void verbose(Object obj, String format, Object ... args) {
        boolean shouldOutputVerboseToDDMS = this.shouldOutputVerboseToDDMS();
        boolean shouldOutputVerboseToFile = this.shouldOutputVerboseToFile();
        if (shouldOutputVerboseToDDMS || shouldOutputVerboseToFile) {
            try {
                int line = this.getCallerLineNumber();
                String filename = this.getCallerFilename();
                this.outputVerbose(obj, line, filename, format, shouldOutputVerboseToDDMS, shouldOutputVerboseToFile, args);
            }
            catch (IllegalFormatException e) {
                Log.e((String)TAG, (String)"write log error !", (Throwable)e);
            }
        }
    }

    public void debug(Object obj, String format, Object ... args) {
        if (this.shouldWriteDebug()) {
            int line = this.getCallerLineNumber();
            String filename = this.getCallerFilename();
            this.outputDebug(obj, format, line, filename, args);
        }
    }

    public void info(Object obj, String format, Object ... args) {
        if (this.shouldWriteInfo()) {
            try {
                int line = this.getCallerLineNumber();
                String filename = this.getCallerFilename();
                this.outputInfo(obj, format, line, filename, args);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"write log error !", (Throwable)e);
            }
        }
    }

    public void warn(Object obj, String format, Object ... args) {
        if (this.shouldWriteWarn()) {
            try {
                int line = this.getCallerLineNumber();
                String filename = this.getCallerFilename();
                this.outputWarning(obj, format, line, filename, args);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"write log error !", (Throwable)e);
            }
        }
    }

    public void error(Object obj, String format, Object ... args) {
        if (this.shouldWriteError()) {
            try {
                int line = this.getCallerLineNumber();
                String filename = this.getCallerFilename();
                this.outputError(obj, format, line, filename, args);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"write log error !", (Throwable)e);
            }
        }
    }

    public void error(Object obj, Throwable t) {
        if (this.shouldWriteError()) {
            int line = this.getCallerLineNumber();
            String filename = this.getCallerFilename();
            String methodname = this.getCallerMethodName();
            this.outputError(obj, t, line, filename, methodname);
        }
    }

    public void close() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (YYAppender.this.externalStorageExist()) {
                    LogToES.close();
                }
            }
        };
        this.executeCommand(command);
    }

    private void executeCommand(Runnable command) {
        this.THREAD.execute(command);
    }

    private String objClassName(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getSimpleName();
    }

    private void writeToLog(final String logText) {
        final long timeMillis = System.currentTimeMillis();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (YYAppender.this.externalStorageExist()) {
                    try {
                        LogToES.writeLogToFile(LogToES.getLogPath(), ((YYAppender)YYAppender.this).sOptions.logFileName, logText, false, timeMillis);
                    }
                    catch (Exception e) {
                        Log.e((String)"YLogs", (String)("writeToLog fail, " + e));
                    }
                }
            }
        };
        this.executeCommand(command);
    }

    private void logToFile(String logText, Throwable t) {
        StringWriter sw = new StringWriter();
        sw.write(logText);
        sw.write("\n");
        t.printStackTrace(new PrintWriter(sw));
        this.writeToLog(sw.toString());
    }

    private String msgForException(Object obj, String methodname, String filename, int line) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof String) {
            sb.append((String)obj);
        } else {
            sb.append(obj.getClass().getSimpleName());
        }
        sb.append(" Exception occurs at ");
        sb.append("(T:");
        sb.append(Thread.currentThread().getName());
        sb.append(")");
        sb.append(" at (");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(")");
        return sb.toString();
    }

    private String msgForTextLog(Object obj, String filename, int line, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append(")");
        sb.append("(T:");
        sb.append(Thread.currentThread().getName());
        sb.append(")");
        sb.append(" at (");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(")");
        return sb.toString();
    }

    public void setCallerStackTraceIndex(int index) {
        this.callerStackTraceIndex = index;
    }

    private int getCallerLineNumber() {
        int index = this.callerStackTraceIndex;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (index >= elements.length) {
            index = elements.length - 1;
        }
        return elements[index].getLineNumber();
    }

    private String getCallerFilename() {
        int index = this.callerStackTraceIndex;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (index >= elements.length) {
            index = elements.length - 1;
        }
        return elements[index].getFileName();
    }

    private String getCallerMethodName() {
        int index = this.callerStackTraceIndex;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (index >= elements.length) {
            index = elements.length - 1;
        }
        return elements[index].getMethodName();
    }

    private String getThreadStacksKeyword() {
        return this.sOptions.stackTraceFilterKeyword;
    }

    public void printThreadStacks() {
        this.printThreadStacks(this.tagOfStack(), this.getThreadStacksKeyword(), false, false);
    }

    public void printThreadStacks(String tag) {
        this.printThreadStacks(tag, this.getThreadStacksKeyword(), this.isNullOrEmpty(this.getThreadStacksKeyword()), false);
    }

    public void printThreadStacks(Throwable e, String tag) {
        this.printStackTraces(e.getStackTrace(), tag);
    }

    public void printThreadStacks(String tag, String keyword) {
        this.printThreadStacks(tag, keyword, false, false);
    }

    public void printThreadStacks(String tag, String keyword, boolean fullLog, boolean release) {
        this.printStackTraces(Thread.currentThread().getStackTrace(), tag, keyword, fullLog, release);
    }

    public void printStackTraces(StackTraceElement[] traces, String tag) {
        this.printStackTraces(traces, tag, this.getThreadStacksKeyword(), this.isNullOrEmpty(this.sOptions.stackTraceFilterKeyword), false);
    }

    private void printStackTraces(StackTraceElement[] traces, String tag, String keyword, boolean fullLog, boolean release) {
        this.printLog(tag, "------------------------------------", release);
        for (StackTraceElement e : traces) {
            String info = e.toString();
            if (!fullLog && (this.isNullOrEmpty(keyword) || !info.contains(keyword))) continue;
            this.printLog(tag, info, release);
        }
        this.printLog(tag, "------------------------------------", release);
    }

    private void printLog(String tag, String log, boolean release) {
        if (release) {
            this.info(tag, log, new Object[0]);
        } else {
            this.debug(tag, log, new Object[0]);
        }
    }

    private String tag(Object tag) {
        LogOptions options = this.sOptions;
        return options.uniformTag == null ? (tag instanceof String ? (String)tag : tag.getClass().getSimpleName()) : options.uniformTag;
    }

    private String tagOfStack() {
        return this.sOptions.uniformTag == null ? "CallStack" : this.sOptions.uniformTag;
    }

    private boolean shouldOutputVerboseToDDMS() {
        return this.sOptions.logLevel <= 1;
    }

    private boolean shouldOutputVerboseToFile() {
        return this.sOptions.logLevel <= 1 && this.sOptions.honorVerbose;
    }

    private boolean shouldWriteDebug() {
        return this.sOptions.logLevel <= 2;
    }

    private boolean shouldWriteInfo() {
        return this.sOptions.logLevel <= 3;
    }

    private boolean shouldWriteWarn() {
        return this.sOptions.logLevel <= 4;
    }

    private boolean shouldWriteError() {
        return this.sOptions.logLevel <= 5;
    }

    private boolean externalStorageExist() {
        return Environment.getExternalStorageState().equalsIgnoreCase("mounted");
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void outputVerbose(Object obj, int line, String filename, String format, boolean outToDDMS, boolean outToFile, Object ... args) {
        try {
            String msg = args == null || args.length == 0 ? format : String.format(format, args);
            String logText = this.msgForTextLog(obj, filename, line, msg);
            if (outToDDMS) {
                Log.v((String)this.tag(obj), (String)logText);
            }
            if (outToFile) {
                this.writeToLog(logText);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write log error !", (Throwable)e);
        }
    }

    private void outputDebug(Object obj, String format, int line, String filename, Object ... args) {
        try {
            String msg = args == null || args.length == 0 ? format : String.format(format, args);
            String logText = this.msgForTextLog(obj, filename, line, msg);
            Log.d((String)this.tag(obj), (String)logText);
            this.writeToLog(logText);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write log error !", (Throwable)e);
        }
    }

    private void outputInfo(Object obj, String format, int line, String filename, Object ... args) {
        try {
            String msg = args == null || args.length == 0 ? format : String.format(format, args);
            String logText = this.msgForTextLog(obj, filename, line, msg);
            Log.i((String)this.tag(obj), (String)logText);
            this.writeToLog(logText);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write log error !", (Throwable)e);
        }
    }

    private void outputWarning(Object obj, String format, int line, String filename, Object ... args) {
        try {
            String msg = args == null || args.length == 0 ? format : String.format(format, args);
            String logText = this.msgForTextLog(obj, filename, line, msg);
            Log.w((String)this.tag(obj), (String)logText);
            this.writeToLog(logText);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write log error !", (Throwable)e);
        }
    }

    private void outputError(Object obj, String format, int line, String filename, Object ... args) {
        try {
            String msg = args == null || args.length == 0 ? format : String.format(format, args);
            String logText = this.msgForTextLog(obj, filename, line, msg);
            if (args != null && args.length > 0 && args[args.length - 1] instanceof Throwable) {
                Throwable t = (Throwable)args[args.length - 1];
                Log.e((String)this.tag(obj), (String)logText, (Throwable)t);
                this.logToFile(logText, t);
            } else {
                Log.e((String)this.tag(obj), (String)logText);
                this.writeToLog(logText);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write log error !", (Throwable)e);
        }
    }

    private void outputError(Object obj, Throwable t, int line, String filename, String methodname) {
        try {
            String logText = this.msgForException(obj, methodname, filename, line);
            this.logToFile(logText, t);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"write log error !", (Throwable)e);
        }
    }

    public static class LogOutputPaths {
        public String dir;
        public String currentLogFile;
        public String latestBackupFile;
    }

    public static class LogOptions {
        public static final int LEVEL_VERBOSE = 1;
        public static final int LEVEL_DEBUG = 2;
        public static final int LEVEL_INFO = 3;
        public static final int LEVEL_WARN = 4;
        public static final int LEVEL_ERROR = 5;
        public String uniformTag;
        public String stackTraceFilterKeyword;
        public int logLevel = 3;
        public boolean honorVerbose = false;
        public int backUpLogLimitInMB = 4;
        public int buffSizeInBytes = 32768;
        public String logFileName = "logs.txt";
    }
}

