/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util.http;

import android.util.Pair;
import com.yy.androidlib.util.http.BasicFileUtils;
import com.yy.androidlib.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.Deflater;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.ByteArrayBuffer;

public class HttpMultipartEntity
implements HttpEntity {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FORM_DATA = "form-data";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String CR_LF = "\r\n";
    private static final String TWO_DASHES = "--";
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int INIT_BUF_SIZE = 4096;
    private static final int READ_BUF_SIZE = 1024;
    private final String boundary;
    private final Charset charset;
    private final Header contentType;
    private long length;
    private volatile boolean dirty;
    private List<Pair<String, String>> mStrings = new ArrayList<Pair<String, String>>();
    private Map<String, String> mFiles = new HashMap<String, String>();
    private Map<String, String> mZipData = new HashMap<String, String>();
    private Map<String, String> mZipFiles = new HashMap<String, String>();
    private Map<String, String> mFileBlocks = new HashMap<String, String>();
    private Map<String, String> mFileData = new HashMap<String, String>();
    private int mStartPos = 0;
    private int mPartSize = 0;
    private int mBlockIndex = 0;

    public HttpMultipartEntity(Charset charset) {
        this.boundary = this.generateBoundary();
        this.charset = charset;
        this.contentType = new BasicHeader("Content-Type", this.getContentTypeString());
    }

    public Header getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        if (this.dirty) {
            try {
                LengthCounter lengthCounter = new LengthCounter();
                this.writeStringParts(lengthCounter);
                this.writeZipData(lengthCounter);
                this.writeZipFile(lengthCounter);
                this.writeFileParts(lengthCounter);
                this.writeFileData(lengthCounter);
                this.writeFileBlockParts(lengthCounter);
                this.writeFinishPart(lengthCounter);
                this.length = lengthCounter.getLength();
                this.dirty = false;
            }
            catch (IOException e) {
                Logger.error(this, e);
            }
        }
        return this.length;
    }

    public void writeTo(OutputStream out) throws IOException {
        DataWriter writer = new DataWriter(out);
        this.writeStringParts(writer);
        this.writeZipData(writer);
        this.writeZipFile(writer);
        this.writeFileParts(writer);
        this.writeFileData(writer);
        this.writeFileBlockParts(writer);
        this.writeFinishPart(writer);
    }

    public void addStringPart(String name, String value) {
        Pair pair = Pair.create((Object)name, (Object)value);
        this.mStrings.add((Pair<String, String>)pair);
        this.dirty = true;
    }

    public void addFileParts(String name, String filepath) {
        this.mFiles.put(filepath, name);
        this.dirty = true;
    }

    public void addZipData(String name, String data) {
        this.mZipData.put(name, data);
        this.dirty = true;
    }

    public void addZipFile(String name, String filePath) {
        this.mZipFiles.put(name, filePath);
        this.dirty = true;
    }

    public void addFileData(String name, String fileData) {
        this.mFileData.put(name, fileData);
        this.dirty = true;
    }

    public void addFileBlock(String name, String filepath, int startPos, int size, int index) {
        this.mStartPos = startPos;
        this.mPartSize = size;
        this.mBlockIndex = index;
        this.mFileBlocks.put(filepath, name);
        this.dirty = true;
    }

    private String getContentTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MULTIPART_FORM_DATA);
        sb.append("; ");
        sb.append("boundary=");
        sb.append(this.boundary);
        return sb.toString();
    }

    private void writeFileHeader(IDataPolicy dataPolicy, String mimeType, String name, String uploadFileName) throws IOException {
        this.writeBoundary(dataPolicy);
        StringBuilder sb = new StringBuilder();
        sb.append(CONTENT_DISPOSITION);
        sb.append(": ");
        sb.append(FORM_DATA);
        sb.append("; ");
        sb.append("name=\"");
        sb.append(name);
        sb.append("\"; ");
        sb.append("filename=\"");
        sb.append(uploadFileName);
        sb.append("\"");
        sb.append(CR_LF);
        sb.append("Content-Type: ");
        sb.append(mimeType);
        sb.append(CR_LF);
        sb.append(CR_LF);
        this.writeBytes(sb.toString(), dataPolicy);
    }

    private void writeZipFile(IDataPolicy dataPolicy) throws IOException {
        for (Map.Entry<String, String> entry : this.mZipFiles.entrySet()) {
            String mimeType = BasicFileUtils.getFileMime(".zip");
            String name = entry.getKey();
            this.writeFileHeader(dataPolicy, mimeType, name, entry.getValue());
            this.addZlibDataFromFile(dataPolicy, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZlibDataFromFile(IDataPolicy dataPolicy, String fileName) throws IOException {
        Deflater compressor = new Deflater();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(fileName);
            int bytes = 0;
            byte[] buffer = new byte[4096];
            while ((bytes = fis.read(buffer)) != -1) {
                compressor.setInput(buffer, 0, bytes);
            }
            compressor.finish();
            bytes = 0;
            while (!compressor.finished()) {
                bytes = compressor.deflate(buffer);
                dataPolicy.write(buffer, 0, bytes);
            }
            compressor.end();
        }
    }

    private void writeZipData(IDataPolicy dataPolicy) throws IOException {
    }

    private void addZlibCompressData(IDataPolicy dataPolicy, String data) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setInput(data.getBytes());
        compressor.finish();
        int bytes = 0;
        byte[] buffer = new byte[4096];
        while (!compressor.finished()) {
            bytes = compressor.deflate(buffer);
            dataPolicy.write(buffer, 0, bytes);
        }
        compressor.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileParts(IDataPolicy dataPolicy) throws IOException {
        for (String filePath : this.mFiles.keySet()) {
            String mimeType = BasicFileUtils.getFileMime(filePath);
            String name = this.mFiles.get(filePath);
            String uploadFileName = BasicFileUtils.getFileName(filePath);
            this.writeFileHeader(dataPolicy, mimeType, name, uploadFileName);
            File f = new File(filePath);
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                byte[] buffer = new byte[4096];
                int readCount = 0;
                while ((readCount = in.read(buffer)) != -1) {
                    dataPolicy.write(buffer, 0, readCount);
                }
                this.writeBytes(CR_LF, dataPolicy);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    private void writeFileData(IDataPolicy dataPolicy) throws IOException {
        for (Map.Entry<String, String> entry : this.mFileData.entrySet()) {
            String mimeType = BasicFileUtils.getFileMime(".zip");
            String name = entry.getKey();
            this.writeFileHeader(dataPolicy, mimeType, "files", name);
            dataPolicy.write(entry.getValue().getBytes(), 0, entry.getValue().length());
            this.writeBytes(CR_LF, dataPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileBlockParts(IDataPolicy dataPolicy) throws IOException {
        if (this.mPartSize == 0) {
            return;
        }
        for (String filePath : this.mFileBlocks.keySet()) {
            String mimeType = BasicFileUtils.getFileMime(filePath);
            String uploadFilename = BasicFileUtils.getFileName(filePath);
            this.writeBoundary(dataPolicy);
            StringBuilder sb0 = new StringBuilder();
            sb0.append(CONTENT_DISPOSITION);
            sb0.append(": ");
            sb0.append(FORM_DATA);
            sb0.append("; ");
            sb0.append("name=\"");
            sb0.append("block");
            sb0.append("\"; ");
            sb0.append(CR_LF);
            sb0.append(CR_LF);
            sb0.append(this.mBlockIndex);
            this.writeBytes(sb0.toString(), dataPolicy);
            this.writeBytes(CR_LF, dataPolicy);
            this.writeFileHeader(dataPolicy, mimeType, this.mFileBlocks.get(filePath), uploadFilename);
            File f = new File(filePath);
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                byte[] buffer = new byte[1024];
                in.skip(this.mStartPos);
                int readCount = 0;
                for (int tmp = 0; tmp < this.mPartSize && (readCount = in.read(buffer)) != -1; tmp += readCount) {
                    if (readCount > this.mPartSize) {
                        dataPolicy.write(buffer, 0, this.mPartSize);
                        continue;
                    }
                    dataPolicy.write(buffer, 0, readCount);
                }
                this.writeBytes(CR_LF, dataPolicy);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    private void writeStringParts(IDataPolicy dataPolicy) throws IOException {
        for (Pair<String, String> pair : this.mStrings) {
            this.writeBoundary(dataPolicy);
            StringBuilder sb = new StringBuilder();
            sb.append(CONTENT_DISPOSITION);
            sb.append(": ");
            sb.append(FORM_DATA);
            sb.append("; ");
            sb.append("name=\"");
            sb.append((String)pair.first);
            sb.append("\"");
            sb.append(CR_LF);
            sb.append(CR_LF);
            sb.append((String)pair.second);
            sb.append(CR_LF);
            this.writeBytes(sb.toString(), dataPolicy);
        }
    }

    private void writeFinishPart(IDataPolicy dataPolicy) throws IOException {
        this.writeBytes(TWO_DASHES, dataPolicy);
        this.writeBytes(this.boundary, dataPolicy);
        this.writeBytes(TWO_DASHES, dataPolicy);
        this.writeBytes(CR_LF, dataPolicy);
    }

    private void writeBoundary(IDataPolicy dataPolicy) throws IOException {
        this.writeBytes(this.encode(TWO_DASHES), dataPolicy);
        this.writeBytes(this.encode(this.boundary), dataPolicy);
        this.writeBytes(this.encode(CR_LF), dataPolicy);
    }

    private void writeBytes(String str, IDataPolicy dataPolicy) throws IOException {
        this.writeBytes(this.encode(str), dataPolicy);
    }

    private void writeBytes(ByteArrayBuffer b, IDataPolicy dataPolicy) throws IOException {
        dataPolicy.write(b.buffer(), 0, b.length());
    }

    private ByteArrayBuffer encode(String string) {
        ByteBuffer encoded = this.charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer bab = new ByteArrayBuffer(encoded.remaining());
        bab.append(encoded.array(), encoded.position(), encoded.remaining());
        return bab;
    }

    private String generateBoundary() {
        StringBuilder buffer = new StringBuilder();
        Random rand = new Random();
        int count = rand.nextInt(11) + 30;
        for (int i = 0; i < count; ++i) {
            buffer.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        return buffer.toString();
    }

    public void consumeContent() throws IOException {
        throw new IOException("consumeContent is not supported!");
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new IOException("getContent is not supported!");
    }

    public Header getContentEncoding() {
        return null;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    private static class DataWriter
    implements IDataPolicy {
        private OutputStream out;

        public DataWriter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            this.out.write(buffer, offset, count);
        }
    }

    private static class LengthCounter
    implements IDataPolicy {
        private int length = 0;

        private LengthCounter() {
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public void write(byte[] buffer, int offset, int count) {
            this.length += count;
        }
    }

    private static interface IDataPolicy {
        public void write(byte[] var1, int var2, int var3) throws IOException;
    }
}

