/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview.internal;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.CardStackListener;
import com.yuyakaido.android.cardstackview.RewindAnimationSetting;
import com.yuyakaido.android.cardstackview.SwipeAnimationSetting;
import com.yuyakaido.android.cardstackview.internal.AnimationSetting;
import com.yuyakaido.android.cardstackview.internal.CardStackState;

public class CardStackSmoothScroller
extends RecyclerView.SmoothScroller {
    private ScrollType type;
    private CardStackLayoutManager manager;

    public CardStackSmoothScroller(ScrollType type, CardStackLayoutManager manager) {
        this.type = type;
        this.manager = manager;
    }

    protected void onSeekTargetStep(int dx, int dy, @NonNull RecyclerView.State state, @NonNull RecyclerView.SmoothScroller.Action action) {
        if (this.type == ScrollType.AutomaticRewind) {
            this.manager.removeAllViews();
            RewindAnimationSetting setting = this.manager.getCardStackSetting().rewindAnimationSetting;
            action.update(-this.getDx(setting), -this.getDy(setting), setting.getDuration(), setting.getInterpolator());
        }
    }

    protected void onTargetFound(@NonNull View targetView, @NonNull RecyclerView.State state, @NonNull RecyclerView.SmoothScroller.Action action) {
        int x = (int)targetView.getTranslationX();
        int y = (int)targetView.getTranslationY();
        switch (this.type) {
            case AutomaticSwipe: {
                SwipeAnimationSetting setting = this.manager.getCardStackSetting().swipeAnimationSetting;
                action.update(-this.getDx(setting), -this.getDy(setting), setting.getDuration(), setting.getInterpolator());
                break;
            }
            case AutomaticRewind: {
                RewindAnimationSetting setting = this.manager.getCardStackSetting().rewindAnimationSetting;
                action.update(x, y, setting.getDuration(), setting.getInterpolator());
                break;
            }
            case ManualSwipe: {
                int dx = -x * 10;
                int dy = -y * 10;
                SwipeAnimationSetting setting = this.manager.getCardStackSetting().swipeAnimationSetting;
                action.update(dx, dy, setting.getDuration(), setting.getInterpolator());
                break;
            }
            case ManualCancel: {
                RewindAnimationSetting setting = this.manager.getCardStackSetting().rewindAnimationSetting;
                action.update(x, y, setting.getDuration(), setting.getInterpolator());
            }
        }
    }

    protected void onStart() {
        CardStackListener listener = this.manager.getCardStackListener();
        CardStackState state = this.manager.getCardStackState();
        switch (this.type) {
            case AutomaticSwipe: {
                state.next(CardStackState.Status.AutomaticSwipeAnimating);
                listener.onCardDisappeared(this.manager.getTopView(), this.manager.getTopPosition());
                break;
            }
            case AutomaticRewind: {
                state.next(CardStackState.Status.RewindAnimating);
                break;
            }
            case ManualSwipe: {
                state.next(CardStackState.Status.ManualSwipeAnimating);
                listener.onCardDisappeared(this.manager.getTopView(), this.manager.getTopPosition());
                break;
            }
            case ManualCancel: {
                state.next(CardStackState.Status.RewindAnimating);
            }
        }
    }

    protected void onStop() {
        CardStackListener listener = this.manager.getCardStackListener();
        switch (this.type) {
            case AutomaticSwipe: {
                break;
            }
            case AutomaticRewind: {
                listener.onCardRewound();
                listener.onCardAppeared(this.manager.getTopView(), this.manager.getTopPosition());
                break;
            }
            case ManualSwipe: {
                break;
            }
            case ManualCancel: {
                listener.onCardCanceled();
            }
        }
    }

    private int getDx(AnimationSetting setting) {
        CardStackState state = this.manager.getCardStackState();
        int dx = 0;
        switch (setting.getDirection()) {
            case Left: {
                dx = -state.width * 2;
                break;
            }
            case Right: {
                dx = state.width * 2;
                break;
            }
            case Top: 
            case Bottom: {
                dx = 0;
            }
        }
        return dx;
    }

    private int getDy(AnimationSetting setting) {
        CardStackState state = this.manager.getCardStackState();
        int dy = 0;
        switch (setting.getDirection()) {
            case Left: 
            case Right: {
                dy = state.height / 4;
                break;
            }
            case Top: {
                dy = -state.height * 2;
                break;
            }
            case Bottom: {
                dy = state.height * 2;
            }
        }
        return dy;
    }

    public static enum ScrollType {
        AutomaticSwipe,
        AutomaticRewind,
        ManualSwipe,
        ManualCancel;

    }
}

