/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import android.view.View;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.Duration;
import com.yuyakaido.android.cardstackview.SwipeAnimationSetting;
import com.yuyakaido.android.cardstackview.internal.CardStackSetting;
import com.yuyakaido.android.cardstackview.internal.CardStackSmoothScroller;
import com.yuyakaido.android.cardstackview.internal.CardStackState;

public class CardStackSnapHelper
extends SnapHelper {
    private int velocityX = 0;
    private int velocityY = 0;

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        CardStackLayoutManager manager;
        if (layoutManager instanceof CardStackLayoutManager && (manager = (CardStackLayoutManager)layoutManager).findViewByPosition(manager.getTopPosition()) != null) {
            int x = (int)targetView.getTranslationX();
            int y = (int)targetView.getTranslationY();
            if (x != 0 || y != 0) {
                CardStackSetting setting = manager.getCardStackSetting();
                float horizontal = (float)Math.abs(x) / (float)targetView.getWidth();
                float vertical = (float)Math.abs(y) / (float)targetView.getHeight();
                Duration duration = Duration.fromVelocity(this.velocityY < this.velocityX ? this.velocityX : this.velocityY);
                if (duration == Duration.Fast || setting.swipeThreshold < horizontal || setting.swipeThreshold < vertical) {
                    CardStackState state = manager.getCardStackState();
                    if (setting.directions.contains((Object)state.getDirection())) {
                        state.targetPosition = state.topPosition + 1;
                        SwipeAnimationSetting swipeAnimationSetting = new SwipeAnimationSetting.Builder().setDirection(setting.swipeAnimationSetting.getDirection()).setDuration(duration.duration).setInterpolator(setting.swipeAnimationSetting.getInterpolator()).build();
                        manager.setSwipeAnimationSetting(swipeAnimationSetting);
                        this.velocityX = 0;
                        this.velocityY = 0;
                        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.ManualSwipe, manager);
                        scroller.setTargetPosition(manager.getTopPosition());
                        manager.startSmoothScroll(scroller);
                    } else {
                        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.ManualCancel, manager);
                        scroller.setTargetPosition(manager.getTopPosition());
                        manager.startSmoothScroll(scroller);
                    }
                } else {
                    CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.ManualCancel, manager);
                    scroller.setTargetPosition(manager.getTopPosition());
                    manager.startSmoothScroll(scroller);
                }
            }
        }
        return new int[2];
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        CardStackLayoutManager manager;
        View view;
        if (layoutManager instanceof CardStackLayoutManager && (view = (manager = (CardStackLayoutManager)layoutManager).findViewByPosition(manager.getTopPosition())) != null) {
            int x = (int)view.getTranslationX();
            int y = (int)view.getTranslationY();
            if (x == 0 && y == 0) {
                return null;
            }
            return view;
        }
        return null;
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        this.velocityX = Math.abs(velocityX);
        this.velocityY = Math.abs(velocityY);
        if (layoutManager instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)layoutManager;
            return manager.getTopPosition();
        }
        return -1;
    }
}

