/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview.internal;

import com.yuyakaido.android.cardstackview.Direction;

public class CardStackState {
    public Status status = Status.Idle;
    public int width = 0;
    public int height = 0;
    public int dx = 0;
    public int dy = 0;
    public int topPosition = 0;
    public int targetPosition = -1;
    public float proportion = 0.0f;

    public void next(Status state) {
        this.status = state;
    }

    public Direction getDirection() {
        if (Math.abs(this.dy) < Math.abs(this.dx)) {
            if ((float)this.dx < 0.0f) {
                return Direction.Left;
            }
            return Direction.Right;
        }
        if ((float)this.dy < 0.0f) {
            return Direction.Top;
        }
        return Direction.Bottom;
    }

    public float getRatio() {
        int absDy;
        int absDx = Math.abs(this.dx);
        float ratio = absDx < (absDy = Math.abs(this.dy)) ? (float)absDy / ((float)this.height / 2.0f) : (float)absDx / ((float)this.width / 2.0f);
        return Math.min(ratio, 1.0f);
    }

    public static enum Status {
        Idle,
        Dragging,
        RewindAnimating,
        PrepareSwipeAnimation,
        SwipeAnimating;

    }
}

