/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview.internal;

import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Point;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import com.yuyakaido.android.cardstackview.R;
import com.yuyakaido.android.cardstackview.SwipeDirection;
import com.yuyakaido.android.cardstackview.internal.CardStackOption;
import com.yuyakaido.android.cardstackview.internal.Quadrant;
import com.yuyakaido.android.cardstackview.internal.Util;

public class CardContainerView
extends FrameLayout {
    private CardStackOption option;
    private float viewOriginX = 0.0f;
    private float viewOriginY = 0.0f;
    private float motionOriginX = 0.0f;
    private float motionOriginY = 0.0f;
    private boolean isDragging = false;
    private boolean isDraggable = true;
    private ViewGroup contentContainer = null;
    private ViewGroup overlayContainer = null;
    private View leftOverlayView = null;
    private View rightOverlayView = null;
    private View bottomOverlayView = null;
    private View topOverlayView = null;
    private ContainerEventListener containerEventListener = null;
    private GestureDetector.SimpleOnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapUp(MotionEvent e) {
            if (CardContainerView.this.containerEventListener != null) {
                CardContainerView.this.containerEventListener.onContainerClicked();
            }
            return true;
        }
    };
    private GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.gestureListener);

    public CardContainerView(Context context) {
        this(context, null);
    }

    public CardContainerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardContainerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        CardContainerView.inflate((Context)this.getContext(), (int)R.layout.card_frame, (ViewGroup)this);
        this.contentContainer = (ViewGroup)this.findViewById(R.id.card_frame_content_container);
        this.overlayContainer = (ViewGroup)this.findViewById(R.id.card_frame_overlay_container);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        if (!this.option.isSwipeEnabled || !this.isDraggable) {
            return true;
        }
        switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
            case 0: {
                this.handleActionDown(event);
                this.getParent().getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                this.handleActionUp(event);
                this.getParent().getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 3: {
                this.getParent().getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 2: {
                this.handleActionMove(event);
            }
        }
        return true;
    }

    private void handleActionDown(MotionEvent event) {
        this.motionOriginX = event.getRawX();
        this.motionOriginY = event.getRawY();
    }

    private void handleActionUp(MotionEvent event) {
        if (this.isDragging) {
            this.isDragging = false;
            float motionCurrentX = event.getRawX();
            float motionCurrentY = event.getRawY();
            Point point = Util.getTargetPoint(this.motionOriginX, this.motionOriginY, motionCurrentX, motionCurrentY);
            Quadrant quadrant = Util.getQuadrant(this.motionOriginX, this.motionOriginY, motionCurrentX, motionCurrentY);
            double radian = Util.getRadian(this.motionOriginX, this.motionOriginY, motionCurrentX, motionCurrentY);
            double degree = 0.0;
            SwipeDirection direction = null;
            switch (quadrant) {
                case TopLeft: {
                    degree = Math.toDegrees(radian);
                    degree = 180.0 - degree;
                    radian = Math.toRadians(degree);
                    if (Math.cos(radian) < -0.5) {
                        direction = SwipeDirection.Left;
                        break;
                    }
                    direction = SwipeDirection.Top;
                    break;
                }
                case TopRight: {
                    degree = Math.toDegrees(radian);
                    radian = Math.toRadians(degree);
                    if (Math.cos(radian) < 0.5) {
                        direction = SwipeDirection.Top;
                        break;
                    }
                    direction = SwipeDirection.Right;
                    break;
                }
                case BottomLeft: {
                    degree = Math.toDegrees(radian);
                    degree = 180.0 + degree;
                    radian = Math.toRadians(degree);
                    if (Math.cos(radian) < -0.5) {
                        direction = SwipeDirection.Left;
                        break;
                    }
                    direction = SwipeDirection.Bottom;
                    break;
                }
                case BottomRight: {
                    degree = Math.toDegrees(radian);
                    degree = 360.0 - degree;
                    radian = Math.toRadians(degree);
                    direction = Math.cos(radian) < 0.5 ? SwipeDirection.Bottom : SwipeDirection.Right;
                }
            }
            float percent = 0.0f;
            percent = direction == SwipeDirection.Left || direction == SwipeDirection.Right ? this.getPercentX() : this.getPercentY();
            if (Math.abs(percent) > this.option.swipeThreshold) {
                if (this.option.swipeDirection.contains((Object)direction)) {
                    if (this.containerEventListener != null) {
                        this.containerEventListener.onContainerSwiped(point, direction);
                    }
                } else {
                    this.moveToOrigin();
                    if (this.containerEventListener != null) {
                        this.containerEventListener.onContainerMovedToOrigin();
                    }
                }
            } else {
                this.moveToOrigin();
                if (this.containerEventListener != null) {
                    this.containerEventListener.onContainerMovedToOrigin();
                }
            }
        }
        this.motionOriginX = event.getRawX();
        this.motionOriginY = event.getRawY();
    }

    private void handleActionMove(MotionEvent event) {
        this.isDragging = true;
        this.updateTranslation(event);
        this.updateRotation();
        this.updateAlpha();
        if (this.containerEventListener != null) {
            this.containerEventListener.onContainerDragging(this.getPercentX(), this.getPercentY());
        }
    }

    private void updateTranslation(MotionEvent event) {
        ViewCompat.setTranslationX((View)this, (float)(this.viewOriginX + event.getRawX() - this.motionOriginX));
        ViewCompat.setTranslationY((View)this, (float)(this.viewOriginY + event.getRawY() - this.motionOriginY));
    }

    private void updateRotation() {
        ViewCompat.setRotation((View)this, (float)(this.getPercentX() * 20.0f));
    }

    private void updateAlpha() {
        float percentX = this.getPercentX();
        float percentY = this.getPercentY();
        if (this.option.swipeDirection == SwipeDirection.HORIZONTAL) {
            this.showHorizontalOverlay(percentX);
        } else if (this.option.swipeDirection == SwipeDirection.VERTICAL) {
            this.showVerticalOverlay(percentY);
        } else if (this.option.swipeDirection == SwipeDirection.FREEDOM_NO_BOTTOM) {
            if (Math.abs(percentX) < Math.abs(percentY) && percentY < 0.0f) {
                this.showTopOverlay();
                this.setOverlayAlpha(Math.abs(percentY));
            } else {
                this.showHorizontalOverlay(percentX);
            }
        } else if (this.option.swipeDirection == SwipeDirection.FREEDOM) {
            if (Math.abs(percentX) > Math.abs(percentY)) {
                this.showHorizontalOverlay(percentX);
            } else {
                this.showVerticalOverlay(percentY);
            }
        } else if (Math.abs(percentX) > Math.abs(percentY)) {
            if (percentX < 0.0f) {
                this.showLeftOverlay();
            } else {
                this.showRightOverlay();
            }
            this.setOverlayAlpha(Math.abs(percentX));
        } else {
            if (percentY < 0.0f) {
                this.showTopOverlay();
            } else {
                this.showBottomOverlay();
            }
            this.setOverlayAlpha(Math.abs(percentY));
        }
    }

    private void showHorizontalOverlay(float percentX) {
        if (percentX < 0.0f) {
            this.showLeftOverlay();
        } else {
            this.showRightOverlay();
        }
        this.setOverlayAlpha(Math.abs(percentX));
    }

    private void showVerticalOverlay(float percentY) {
        if (percentY < 0.0f) {
            this.showTopOverlay();
        } else {
            this.showBottomOverlay();
        }
        this.setOverlayAlpha(Math.abs(percentY));
    }

    private void moveToOrigin() {
        this.animate().translationX(this.viewOriginX).translationY(this.viewOriginY).setDuration(300L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).setListener(null).start();
    }

    public void setContainerEventListener(ContainerEventListener listener) {
        this.containerEventListener = listener;
        this.viewOriginX = ViewCompat.getTranslationX((View)this);
        this.viewOriginY = ViewCompat.getTranslationY((View)this);
    }

    public void setCardStackOption(CardStackOption option) {
        this.option = option;
    }

    public void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    public void reset() {
        ViewCompat.setAlpha((View)this.contentContainer, (float)1.0f);
        ViewCompat.setAlpha((View)this.overlayContainer, (float)0.0f);
    }

    public ViewGroup getContentContainer() {
        return this.contentContainer;
    }

    public ViewGroup getOverlayContainer() {
        return this.overlayContainer;
    }

    public void setOverlay(int left, int right, int bottom, int top) {
        if (this.leftOverlayView != null) {
            this.overlayContainer.removeView(this.leftOverlayView);
        }
        if (left != 0) {
            this.leftOverlayView = LayoutInflater.from((Context)this.getContext()).inflate(left, this.overlayContainer, false);
            this.overlayContainer.addView(this.leftOverlayView);
            ViewCompat.setAlpha((View)this.leftOverlayView, (float)0.0f);
        }
        if (this.rightOverlayView != null) {
            this.overlayContainer.removeView(this.rightOverlayView);
        }
        if (right != 0) {
            this.rightOverlayView = LayoutInflater.from((Context)this.getContext()).inflate(right, this.overlayContainer, false);
            this.overlayContainer.addView(this.rightOverlayView);
            ViewCompat.setAlpha((View)this.rightOverlayView, (float)0.0f);
        }
        if (this.bottomOverlayView != null) {
            this.overlayContainer.removeView(this.bottomOverlayView);
        }
        if (bottom != 0) {
            this.bottomOverlayView = LayoutInflater.from((Context)this.getContext()).inflate(bottom, this.overlayContainer, false);
            this.overlayContainer.addView(this.bottomOverlayView);
            ViewCompat.setAlpha((View)this.bottomOverlayView, (float)0.0f);
        }
        if (this.topOverlayView != null) {
            this.overlayContainer.removeView(this.topOverlayView);
        }
        if (top != 0) {
            this.topOverlayView = LayoutInflater.from((Context)this.getContext()).inflate(top, this.overlayContainer, false);
            this.overlayContainer.addView(this.topOverlayView);
            ViewCompat.setAlpha((View)this.topOverlayView, (float)0.0f);
        }
    }

    public void setOverlayAlpha(AnimatorSet overlayAnimatorSet) {
        if (overlayAnimatorSet != null) {
            overlayAnimatorSet.start();
        }
    }

    public void setOverlayAlpha(float alpha) {
        ViewCompat.setAlpha((View)this.overlayContainer, (float)alpha);
    }

    public void showLeftOverlay() {
        if (this.leftOverlayView != null) {
            ViewCompat.setAlpha((View)this.leftOverlayView, (float)1.0f);
        }
        if (this.rightOverlayView != null) {
            ViewCompat.setAlpha((View)this.rightOverlayView, (float)0.0f);
        }
        if (this.bottomOverlayView != null) {
            ViewCompat.setAlpha((View)this.bottomOverlayView, (float)0.0f);
        }
        if (this.topOverlayView != null) {
            ViewCompat.setAlpha((View)this.topOverlayView, (float)0.0f);
        }
    }

    public void showRightOverlay() {
        if (this.leftOverlayView != null) {
            ViewCompat.setAlpha((View)this.leftOverlayView, (float)0.0f);
        }
        if (this.bottomOverlayView != null) {
            ViewCompat.setAlpha((View)this.bottomOverlayView, (float)0.0f);
        }
        if (this.topOverlayView != null) {
            ViewCompat.setAlpha((View)this.topOverlayView, (float)0.0f);
        }
        if (this.rightOverlayView != null) {
            ViewCompat.setAlpha((View)this.rightOverlayView, (float)1.0f);
        }
    }

    public void showBottomOverlay() {
        if (this.leftOverlayView != null) {
            ViewCompat.setAlpha((View)this.leftOverlayView, (float)0.0f);
        }
        if (this.bottomOverlayView != null) {
            ViewCompat.setAlpha((View)this.bottomOverlayView, (float)1.0f);
        }
        if (this.topOverlayView != null) {
            ViewCompat.setAlpha((View)this.topOverlayView, (float)0.0f);
        }
        if (this.rightOverlayView != null) {
            ViewCompat.setAlpha((View)this.rightOverlayView, (float)0.0f);
        }
    }

    public void showTopOverlay() {
        if (this.leftOverlayView != null) {
            ViewCompat.setAlpha((View)this.leftOverlayView, (float)0.0f);
        }
        if (this.bottomOverlayView != null) {
            ViewCompat.setAlpha((View)this.bottomOverlayView, (float)0.0f);
        }
        if (this.topOverlayView != null) {
            ViewCompat.setAlpha((View)this.topOverlayView, (float)1.0f);
        }
        if (this.rightOverlayView != null) {
            ViewCompat.setAlpha((View)this.rightOverlayView, (float)0.0f);
        }
    }

    public float getViewOriginX() {
        return this.viewOriginX;
    }

    public float getViewOriginY() {
        return this.viewOriginY;
    }

    public float getPercentX() {
        float percent = 2.0f * (ViewCompat.getTranslationX((View)this) - this.viewOriginX) / (float)this.getWidth();
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        if (percent < -1.0f) {
            percent = -1.0f;
        }
        return percent;
    }

    public float getPercentY() {
        float percent = 2.0f * (ViewCompat.getTranslationY((View)this) - this.viewOriginY) / (float)this.getHeight();
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        if (percent < -1.0f) {
            percent = -1.0f;
        }
        return percent;
    }

    public static interface ContainerEventListener {
        public void onContainerDragging(float var1, float var2);

        public void onContainerSwiped(Point var1, SwipeDirection var2);

        public void onContainerMovedToOrigin();

        public void onContainerClicked();
    }
}

