/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview.internal;

import android.content.Context;
import android.graphics.Point;
import com.yuyakaido.android.cardstackview.Quadrant;

public class Util {
    private Util() {
    }

    public static float toPx(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return dp * scale + 0.5f;
    }

    public static double getRadian(float x1, float y1, float x2, float y2) {
        float width = x2 - x1;
        float height = y1 - y2;
        return Math.atan(Math.abs(height) / Math.abs(width));
    }

    public static Point getTargetPoint(float x1, float y1, float x2, float y2) {
        double degree;
        float radius = 2000.0f;
        double radian = Util.getRadian(x1, y1, x2, y2);
        Quadrant quadrant = Util.getQuadrant(x1, y1, x2, y2);
        if (quadrant == Quadrant.TopLeft) {
            degree = Math.toDegrees(radian);
            degree = 180.0 - degree;
            radian = Math.toRadians(degree);
        } else if (quadrant == Quadrant.BottomLeft) {
            degree = Math.toDegrees(radian);
            degree = 180.0 + degree;
            radian = Math.toRadians(degree);
        } else if (quadrant == Quadrant.BottomRight) {
            degree = Math.toDegrees(radian);
            degree = 360.0 - degree;
            radian = Math.toRadians(degree);
        } else {
            degree = Math.toDegrees(radian);
            radian = Math.toRadians(degree);
        }
        double x = (double)radius * Math.cos(radian);
        double y = (double)radius * Math.sin(radian);
        return new Point((int)x, (int)y);
    }

    public static Quadrant getQuadrant(float x1, float y1, float x2, float y2) {
        if (x2 > x1) {
            if (y2 > y1) {
                return Quadrant.BottomRight;
            }
            return Quadrant.TopRight;
        }
        if (y2 > y1) {
            return Quadrant.BottomLeft;
        }
        return Quadrant.TopLeft;
    }
}

