/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.yuyakaido.android.cardstackview.CardAnimator;
import com.yuyakaido.android.cardstackview.CardUtil;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.DragGestureDetector;
import java.util.ArrayList;
import java.util.List;

public class CardStackView
extends RelativeLayout {
    private int topIndex = 0;
    private int visibleCount = 4;
    private float distanceBorder = 300.0f;
    private ArrayAdapter<?> adapter;
    private View.OnTouchListener onTouchListener;
    private CardAnimator cardAnimator;
    private List<ViewGroup> containers = new ArrayList<ViewGroup>();
    private CardStackEventListener cardStackEventListener;
    private boolean elevationEnabled = true;
    private boolean swipeEnabled = true;
    private DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            CardStackView.this.initialize(false);
        }
    };

    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private void initialize(boolean resetIndex) {
        this.initializeIndex(resetIndex);
        this.initializeContainerViews();
        this.initializeAnimation();
        this.initializeViews();
    }

    private void initializeIndex(boolean resetIndex) {
        if (resetIndex) {
            this.topIndex = 0;
        }
    }

    private void initializeContainerViews() {
        this.removeAllViews();
        this.containers.clear();
        for (int i = 0; i < this.visibleCount; ++i) {
            FrameLayout v = new FrameLayout(this.getContext());
            this.containers.add((ViewGroup)v);
            this.addView((View)v);
        }
    }

    private void initializeAnimation() {
        this.cardAnimator = new CardAnimator(this.getContext(), this.containers, this.elevationEnabled);
        this.cardAnimator.initCards(this.elevationEnabled);
        final DragGestureDetector dragGestureDetector = new DragGestureDetector(this.getContext(), new DragGestureDetector.DragListener(){

            @Override
            public void onBeginDrag(MotionEvent e1, MotionEvent e2) {
                CardStackView.this.cardAnimator.drag(e1, e2, CardStackView.this.elevationEnabled);
                if (CardStackView.this.cardStackEventListener != null) {
                    float oldX = e1.getRawX();
                    float oldY = e1.getRawY();
                    float newX = e2.getRawX();
                    float newY = e2.getRawY();
                    Direction direction = CardUtil.getDirection(oldX, oldY, newX, newY);
                    CardStackView.this.cardStackEventListener.onBeginSwipe(CardStackView.this.topIndex, direction);
                }
            }

            @Override
            public void onDragging(MotionEvent e1, MotionEvent e2) {
                CardStackView.this.cardAnimator.drag(e1, e2, CardStackView.this.elevationEnabled);
                if (CardStackView.this.cardStackEventListener != null) {
                    float oldX = e1.getRawX();
                    float newX = e2.getRawX();
                    float posX = newX - oldX;
                    posX = CardStackView.this.distanceBorder < posX ? 1.0f : (CardStackView.this.distanceBorder < -posX ? -1.0f : (posX /= CardStackView.this.distanceBorder));
                    CardStackView.this.cardStackEventListener.onSwiping(posX);
                }
            }

            @Override
            public void onEndDrag(MotionEvent e1, MotionEvent e2) {
                float oldX = e1.getRawX();
                float oldY = e1.getRawY();
                float newX = e2.getRawX();
                float newY = e2.getRawY();
                float distance = CardUtil.getDistance(oldX, oldY, newX, newY);
                Direction direction = CardUtil.getDirection(oldX, oldY, newX, newY);
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onEndSwipe(direction);
                }
                if (distance < CardStackView.this.distanceBorder) {
                    CardStackView.this.cardAnimator.moveToOrigin();
                } else {
                    CardStackView.this.discard(direction);
                }
            }

            @Override
            public void onTapUp() {
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onTapUp(CardStackView.this.topIndex);
                }
            }
        });
        this.onTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                if (CardStackView.this.swipeEnabled) {
                    dragGestureDetector.onTouchEvent(event);
                }
                return true;
            }
        };
        this.containers.get(this.containers.size() - 1).setOnTouchListener(this.onTouchListener);
    }

    private void initializeViews() {
        for (int i = this.visibleCount - 1; i >= 0; --i) {
            ViewGroup parent = this.containers.get(i);
            int adapterIndex = this.topIndex + this.visibleCount - 1 - i;
            if (adapterIndex > this.adapter.getCount() - 1) {
                parent.setVisibility(8);
                continue;
            }
            View child = this.adapter.getView(adapterIndex, parent.getChildAt(0), (ViewGroup)this);
            parent.addView(child);
            parent.setVisibility(0);
        }
    }

    private void loadNextView() {
        ViewGroup parent = this.containers.get(0);
        int lastIndex = this.visibleCount - 1 + this.topIndex;
        if (lastIndex > this.adapter.getCount() - 1) {
            parent.setVisibility(8);
            return;
        }
        View child = this.adapter.getView(lastIndex, parent.getChildAt(0), parent);
        parent.removeAllViews();
        parent.addView(child);
    }

    public void setAdapter(ArrayAdapter<?> adapter) {
        if (this.adapter != null) {
            this.adapter.unregisterDataSetObserver(this.dataSetObserver);
        }
        this.adapter = adapter;
        this.adapter.registerDataSetObserver(this.dataSetObserver);
        this.initialize(true);
    }

    public void setCardStackEventListener(CardStackEventListener listener) {
        this.cardStackEventListener = listener;
    }

    public void discard(final Direction direction) {
        this.cardAnimator.discard(direction, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator arg0) {
                CardStackView.this.cardAnimator.initCards(CardStackView.this.elevationEnabled);
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onDiscarded(CardStackView.this.topIndex, direction);
                }
                CardStackView.this.topIndex++;
                CardStackView.this.loadNextView();
                ((ViewGroup)CardStackView.this.containers.get(0)).setOnTouchListener(null);
                ((ViewGroup)CardStackView.this.containers.get(CardStackView.this.containers.size() - 1)).setOnTouchListener(CardStackView.this.onTouchListener);
            }
        });
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public ViewGroup getTopView() {
        return this.cardAnimator.getTopView();
    }

    public void setElevationEnabled(boolean elevationEnabled) {
        this.elevationEnabled = elevationEnabled;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setSwipeEnabled(boolean swipeEnabled) {
        this.swipeEnabled = swipeEnabled;
    }

    public static interface CardStackEventListener {
        public void onBeginSwipe(int var1, Direction var2);

        public void onEndSwipe(Direction var1);

        public void onSwiping(float var1);

        public void onDiscarded(int var1, Direction var2);

        public void onTapUp(int var1);
    }
}

