/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yuyakaido.android.cardstackview.CardUtil;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.LayoutParamsEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CardAnimator {
    private Context context;
    private List<ViewGroup> containers;
    private float rotation;
    private Map<View, RelativeLayout.LayoutParams> cardParams = new HashMap<View, RelativeLayout.LayoutParams>();
    private RelativeLayout.LayoutParams[] remoteParams = new RelativeLayout.LayoutParams[4];
    private RelativeLayout.LayoutParams baseParams;

    public CardAnimator(Context context, List<ViewGroup> containers, boolean elevationEnabled) {
        this.context = context;
        this.containers = containers;
        this.init(elevationEnabled);
    }

    private void init(boolean elevationEnabled) {
        for (View view : this.containers) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)view.getLayoutParams();
            params.addRule(10);
            params.width = -1;
            params.height = -1;
        }
        this.baseParams = CardUtil.cloneParams((RelativeLayout.LayoutParams)this.containers.get(0).getLayoutParams());
        this.initCards(elevationEnabled);
        for (View view : this.containers) {
            this.cardParams.put(view, CardUtil.cloneParams((RelativeLayout.LayoutParams)view.getLayoutParams()));
        }
        this.initRemoteParams();
    }

    public void initCards(boolean elevationEnabled) {
        int size = this.containers.size();
        for (ViewGroup v : this.containers) {
            int index = this.containers.indexOf(v);
            if (index != 0) {
                --index;
            }
            RelativeLayout.LayoutParams params = CardUtil.cloneParams(this.baseParams);
            v.setLayoutParams((ViewGroup.LayoutParams)params);
            this.clearAlpha(v);
            this.clearScale(v);
            this.clearTranslation(v);
            if (elevationEnabled) {
                CardUtil.scale((View)v, -(size - index - 1) * 5);
                CardUtil.move((View)v, index * 20, 0);
            }
            v.setRotation(0.0f);
        }
    }

    public void clearTranslation(ViewGroup viewGroup) {
        if (viewGroup != null) {
            viewGroup.setTranslationX(0.0f);
            viewGroup.setTranslationY(0.0f);
        }
    }

    public void clearScale(ViewGroup viewGroup) {
        if (viewGroup != null) {
            viewGroup.setScaleX(1.0f);
            viewGroup.setScaleY(1.0f);
        }
    }

    public void clearAlpha(ViewGroup viewGroup) {
        if (viewGroup != null) {
            viewGroup.setAlpha(1.0f);
        }
    }

    public void initRemoteParams() {
        int width = CardUtil.getDisplayWidth(this.context);
        int height = CardUtil.getDisplayHeight(this.context);
        ViewGroup topView = this.getTopView();
        this.remoteParams[0] = CardUtil.getMoveParams((View)topView, height, -width);
        this.remoteParams[1] = CardUtil.getMoveParams((View)topView, height, width);
        this.remoteParams[2] = CardUtil.getMoveParams((View)topView, -height, -width);
        this.remoteParams[3] = CardUtil.getMoveParams((View)topView, -height, width);
    }

    public ViewGroup getTopView() {
        return this.containers.get(this.containers.size() - 1);
    }

    public void moveToBottom(ViewGroup container) {
        ViewGroup parent = (ViewGroup)container.getParent();
        if (parent != null) {
            parent.removeView((View)container);
            parent.addView((View)container, 0);
        }
    }

    public void reorderForDiscard() {
        ViewGroup topView = this.getTopView();
        this.moveToBottom(topView);
        for (int i = this.containers.size() - 1; i > 0; --i) {
            this.containers.set(i, this.containers.get(i - 1));
        }
        this.containers.set(0, topView);
    }

    public void discard(Direction direction, final Animator.AnimatorListener listener) {
        AnimatorSet animatorSet = new AnimatorSet();
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        ViewGroup topView = this.getTopView();
        RelativeLayout.LayoutParams topBeginParams = CardUtil.cloneParams((RelativeLayout.LayoutParams)topView.getLayoutParams());
        RelativeLayout.LayoutParams topEndParams = this.remoteParams[direction.getIndex()];
        ValueAnimator topAnimator = ValueAnimator.ofObject((TypeEvaluator)new LayoutParamsEvaluator(), (Object[])new Object[]{topBeginParams, topEndParams});
        topAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((View)topView){
            final /* synthetic */ View val$topView;
            {
                this.val$topView = view;
            }

            public void onAnimationUpdate(ValueAnimator value) {
                this.val$topView.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)value.getAnimatedValue()));
            }
        });
        topAnimator.setDuration(250L);
        animators.add(topAnimator);
        int size = this.containers.size();
        for (int i = 0; i < size - 1; ++i) {
            final View currentView = (View)this.containers.get(i);
            View nextView = (View)this.containers.get(i + 1);
            RelativeLayout.LayoutParams beginParams = CardUtil.cloneParams((RelativeLayout.LayoutParams)currentView.getLayoutParams());
            RelativeLayout.LayoutParams endParams = this.cardParams.get(nextView);
            ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)new LayoutParamsEvaluator(), (Object[])new Object[]{beginParams, endParams});
            animator.setDuration(250L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator value) {
                    currentView.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)value.getAnimatedValue()));
                }
            });
            animators.add(animator);
        }
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                CardAnimator.this.reorderForDiscard();
                if (listener != null) {
                    listener.onAnimationEnd(animation);
                }
                CardAnimator.this.cardParams = new HashMap();
                for (View v : CardAnimator.this.containers) {
                    CardAnimator.this.cardParams.put(v, CardUtil.cloneParams((RelativeLayout.LayoutParams)v.getLayoutParams()));
                }
            }
        });
        animatorSet.playTogether(animators);
        animatorSet.start();
    }

    public void moveToOrigin() {
        ViewGroup topView = this.getTopView();
        ValueAnimator topAnimator = ValueAnimator.ofFloat((float[])new float[]{this.rotation, 0.0f});
        topAnimator.setDuration(250L);
        topAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((View)topView){
            final /* synthetic */ View val$topView;
            {
                this.val$topView = view;
            }

            public void onAnimationUpdate(ValueAnimator v) {
                this.val$topView.setRotation(((Float)v.getAnimatedValue()).floatValue());
            }
        });
        topAnimator.start();
        for (final View view : this.containers) {
            RelativeLayout.LayoutParams beginParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
            RelativeLayout.LayoutParams endLayout = CardUtil.cloneParams(beginParams);
            ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)new LayoutParamsEvaluator(), (Object[])new Object[]{endLayout, this.cardParams.get(view)});
            animator.setDuration(250L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator value) {
                    view.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)value.getAnimatedValue()));
                }
            });
            animator.start();
        }
    }

    public void drag(MotionEvent e1, MotionEvent e2, boolean elevationEnabled) {
        ViewGroup topView = this.getTopView();
        float rotationCoefficient = 20.0f;
        RelativeLayout.LayoutParams beforeParams = this.cardParams.get(topView);
        RelativeLayout.LayoutParams afterParams = (RelativeLayout.LayoutParams)topView.getLayoutParams();
        int distanceX = (int)(e2.getRawX() - e1.getRawX());
        int distanceY = (int)(e2.getRawY() - e1.getRawY());
        afterParams.leftMargin = beforeParams.leftMargin + distanceX;
        afterParams.rightMargin = beforeParams.rightMargin - distanceX;
        afterParams.topMargin = beforeParams.topMargin + distanceY;
        afterParams.bottomMargin = beforeParams.bottomMargin - distanceY;
        this.rotation = (float)distanceX / rotationCoefficient;
        topView.setRotation(this.rotation);
        topView.setLayoutParams((ViewGroup.LayoutParams)afterParams);
        if (elevationEnabled) {
            for (ViewGroup v : this.containers) {
                int index = this.containers.indexOf(v);
                if (v == this.getTopView() || index == 0) continue;
                RelativeLayout.LayoutParams l = CardUtil.scale((View)v, this.cardParams.get(v), (int)((double)Math.abs(distanceX) * 0.005));
                CardUtil.move((View)v, l, (int)((double)Math.abs(distanceX) * 0.025), 0);
            }
        }
    }
}

