/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.content.Context;
import android.graphics.Point;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.yuyakaido.android.cardstackview.Direction;

public class CardUtil {
    public static void scale(View view, int pixel) {
        CardUtil.scale(view, (RelativeLayout.LayoutParams)view.getLayoutParams(), pixel);
    }

    public static RelativeLayout.LayoutParams scale(View view, RelativeLayout.LayoutParams params, int pixel) {
        params = CardUtil.cloneParams(params);
        params.leftMargin -= pixel;
        params.rightMargin -= pixel;
        params.topMargin -= pixel;
        params.bottomMargin -= pixel;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        return params;
    }

    public static void move(View view, int topBottom, int leftRight) {
        CardUtil.move(view, (RelativeLayout.LayoutParams)view.getLayoutParams(), topBottom, leftRight);
    }

    public static void move(View v, RelativeLayout.LayoutParams params, int topBottom, int leftRight) {
        params = CardUtil.cloneParams(params);
        params.leftMargin += leftRight;
        params.rightMargin -= leftRight;
        params.topMargin -= topBottom;
        params.bottomMargin += topBottom;
        v.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static RelativeLayout.LayoutParams getMoveParams(View v, int topBottom, int leftRight) {
        RelativeLayout.LayoutParams original = (RelativeLayout.LayoutParams)v.getLayoutParams();
        RelativeLayout.LayoutParams params = CardUtil.cloneParams(original);
        params.leftMargin += leftRight;
        params.rightMargin -= leftRight;
        params.topMargin -= topBottom;
        params.bottomMargin += topBottom;
        return params;
    }

    public static RelativeLayout.LayoutParams cloneParams(RelativeLayout.LayoutParams params) {
        RelativeLayout.LayoutParams result = new RelativeLayout.LayoutParams(params.width, params.height);
        result.leftMargin = params.leftMargin;
        result.topMargin = params.topMargin;
        result.rightMargin = params.rightMargin;
        result.bottomMargin = params.bottomMargin;
        int[] rules = params.getRules();
        int length = rules.length;
        for (int i = 0; i < length; ++i) {
            result.addRule(i, rules[i]);
        }
        return result;
    }

    public static float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static Direction getDirection(float x1, float y1, float x2, float y2) {
        if (x2 > x1) {
            if (y2 > y1) {
                return Direction.BottomRight;
            }
            return Direction.TopRight;
        }
        if (y2 > y1) {
            return Direction.BottomLeft;
        }
        return Direction.TopLeft;
    }

    public static int getDisplayWidth(Context context) {
        return CardUtil.getDisplaySize((Context)context).x;
    }

    public static int getDisplayHeight(Context context) {
        return CardUtil.getDisplaySize((Context)context).y;
    }

    public static Point getDisplaySize(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        return point;
    }
}

