/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.ContentTooLongException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class HttpEntityWrapper
implements HttpEntity {
    private HttpEntity entity;

    public HttpEntityWrapper(HttpEntity entity) {
        this.entity = entity;
    }

    public boolean isRepeatable() {
        return this.getContentLength() != -1L;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public Header getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public void consumeContent() {
    }

    public InputStream getContent() throws IOException {
        if (this.getContentLength() < 0L) {
            throw new ContentTooLongException("Content length is unknown");
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.entity.writeTo(outstream);
    }
}

