/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.service;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianException;
import com.yunpian.sdk.constant.Config;
import com.yunpian.sdk.model.FlowStatus;
import com.yunpian.sdk.model.ResultDO;
import com.yunpian.sdk.model.SmsBatchSend;
import com.yunpian.sdk.model.SmsRecord;
import com.yunpian.sdk.model.SmsReply;
import com.yunpian.sdk.model.SmsSingleSend;
import com.yunpian.sdk.model.SmsStatus;
import com.yunpian.sdk.service.AbstractOperator;
import com.yunpian.sdk.util.DesUtil;
import com.yunpian.sdk.util.HttpUtil;
import com.yunpian.sdk.util.JsonUtil;
import com.yunpian.sdk.util.SignUtil;
import com.yunpian.sdk.util.StringUtil;
import com.yunpian.sdk.util.TeaUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SmsOperator
extends AbstractOperator {
    private static final long serialVersionUID = 1L;
    private String apikey;
    private String apiSecret;
    private Type singleType = new TypeToken<SmsSingleSend>(){}.getType();
    private Type batchType = new TypeToken<SmsBatchSend>(){}.getType();
    private Type multiType = new TypeToken<SmsBatchSend>(){}.getType();
    private Type tplBatchType = new TypeToken<SmsBatchSend>(){}.getType();
    private Type tplSingleType = new TypeToken<SmsSingleSend>(){}.getType();
    Logger logger = LoggerFactory.getLogger(SmsOperator.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SmsOperator(String apikey, String apiSecret) {
        this.apikey = apikey;
        this.apiSecret = apiSecret;
    }

    public ResultDO<SmsBatchSend> multiSend(List<String> mobileList, List<String> textList) {
        String mobile = StringUtil.join(mobileList, ",");
        StringBuilder text = new StringBuilder();
        for (String s : textList) {
            try {
                text.append(URLEncoder.encode(s, Config.ENCODING) + ",");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                ResultDO<SmsBatchSend> resultDO = new ResultDO<SmsBatchSend>();
                resultDO.setE(e);
                return resultDO;
            }
        }
        String texts = text.toString();
        return this.multiSend(mobile, texts.substring(0, texts.length() - 1));
    }

    public ResultDO<SmsBatchSend> batchSend(List<String> mobileList, String text) {
        String mobile = StringUtil.join(mobileList, ",");
        return this.batchSend(mobile, text);
    }

    public ResultDO<SmsSingleSend> singleSend(String mobile, String text) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("mobile", mobile);
        parms.put("text", text);
        return this.send(Config.URI_SEND_SINGLE_SMS, parms, this.singleType);
    }

    public ResultDO<SmsBatchSend> batchSend(String mobile, String text) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("mobile", mobile);
        parms.put("text", text);
        return this.send(Config.URI_SEND_BATCH_SMS, parms, this.batchType);
    }

    public ResultDO<SmsBatchSend> multiSend(String mobile, String text) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("mobile", mobile);
        parms.put("text", text);
        return this.send(Config.URI_SEND_MULTI_SMS, parms, this.multiType);
    }

    public <T> ResultDO<T> send(String url, Map<String, String> parms, Type t) {
        return this.send(url, parms, t, "tea");
    }

    public <T> ResultDO<T> send(String url, Map<String, String> parms, Type t, String encrypt) {
        this.logger.warn("message:" + parms + "to:" + url);
        ResultDO result = new ResultDO();
        String mobile = parms.get("mobile");
        String text = parms.get("text");
        String tplValue = parms.get("tpl_value");
        String tplId = parms.get("tpl_id");
        if (StringUtil.isNullOrEmpty(mobile)) {
            result.setE(new YunpianException("\u624b\u673a\u53f7\u5185\u5bb9\u4e3a\u7a7a"));
        }
        if (StringUtil.isNullOrEmpty(tplValue) && StringUtil.isNullOrEmpty(text)) {
            result.setE(new YunpianException("\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a"));
            return result;
        }
        if (!StringUtil.isNullOrEmpty(tplValue) && StringUtil.isNullOrEmpty(tplId)) {
            result.setE(new YunpianException("\u6a21\u677f\u77ed\u4fe1ID\u4e3a\u7a7a"));
            return result;
        }
        parms.put("apikey", this.apikey);
        if (!StringUtil.isNullOrEmpty(this.apiSecret)) {
            try {
                if ("tea".equalsIgnoreCase(encrypt)) {
                    parms.put("mobile", TeaUtil.encryptForYunpianV2(mobile, this.apiSecret));
                    if (text != null) {
                        parms.put("text", TeaUtil.encryptForYunpianV2(text, this.apiSecret));
                    }
                    if (tplValue != null) {
                        parms.put("tpl_value", TeaUtil.encryptForYunpianV2(tplValue, this.apiSecret));
                    }
                } else if ("des".equalsIgnoreCase(encrypt)) {
                    parms.put("mobile", DesUtil.encryptForYunpian(mobile, this.apiSecret));
                    if (text != null) {
                        parms.put("text", DesUtil.decryptForYunpian(text, this.apiSecret));
                    }
                    if (tplValue != null) {
                        parms.put("tpl_value", DesUtil.decryptForYunpian(tplValue, this.apiSecret));
                    }
                }
                parms.put("encrypt", "tea");
                parms.put("sign", SignUtil.getSign(parms, this.apiSecret));
            }
            catch (Exception e) {
                this.logger.error("UnsupportedEncodingExceptionmessage:" + parms);
                result.setE(e);
                return result;
            }
        }
        try {
            String ret = HttpUtil.post(url, parms);
            result.setData(JsonUtil.fromJson(ret, t));
            result.setSuccess(true);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage() + " message:" + parms);
            result.setE(e);
        }
        return result;
    }

    public ResultDO<SmsBatchSend> tplBatchSend(String mobile, String tplId, String tplValue) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("mobile", mobile);
        parms.put("tpl_id", tplId);
        parms.put("tpl_value", tplValue);
        return this.send(Config.URI_SEND_TPL_BATCH_SMS, parms, this.tplBatchType);
    }

    public ResultDO<SmsSingleSend> tplSingleSend(String mobile, String tplId, String tplValue) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("mobile", mobile);
        parms.put("tpl_id", tplId);
        parms.put("tpl_value", tplValue);
        return this.send(Config.URI_SEND_TPL_SINGLE_SMS, parms, this.tplSingleType);
    }

    public ResultDO<List<SmsStatus>> pullStatus() {
        ResultDO<List<SmsStatus>> result = new ResultDO<List<SmsStatus>>();
        Type t = new TypeToken<List<FlowStatus>>(){}.getType();
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("apikey", this.apikey);
        try {
            String ret = HttpUtil.post(Config.URI_PULL_SMS_STATUS, parms);
            result.setData((List<SmsStatus>)JsonUtil.fromJson(ret, t));
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setE(e);
        }
        return result;
    }

    public ResultDO<List<SmsReply>> pullReply() {
        ResultDO<List<SmsReply>> result = new ResultDO<List<SmsReply>>();
        Type t = new TypeToken<List<FlowStatus>>(){}.getType();
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("apikey", this.apikey);
        try {
            String ret = HttpUtil.post(Config.URI_PULL_SMS_REPLY, parms);
            result.setData((List<SmsReply>)JsonUtil.fromJson(ret, t));
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setE(e);
        }
        return result;
    }

    public ResultDO<List<SmsReply>> getReply(Date startTime, Date endTime, String mobile, String pageNum, String pageSize) {
        ResultDO<List<SmsReply>> result = new ResultDO<List<SmsReply>>();
        Type t = new TypeToken<List<FlowStatus>>(){}.getType();
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("apikey", this.apikey);
        parms.put("start_time", this.sdf.format(startTime));
        parms.put("end_time", this.sdf.format(endTime));
        parms.put("mobile", mobile);
        parms.put("page_num", pageNum);
        parms.put("page_size", pageSize);
        try {
            String ret = HttpUtil.post(Config.URI_GET_SMS_REPLY, parms);
            result.setData((List<SmsReply>)JsonUtil.fromJson(ret, t));
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setE(e);
        }
        return result;
    }

    public ResultDO<List<SmsRecord>> getRecord(Date startTime, Date endTime, String mobile, String pageNum, String pageSize) {
        ResultDO<List<SmsRecord>> result = new ResultDO<List<SmsRecord>>();
        Type t = new TypeToken<List<FlowStatus>>(){}.getType();
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("apikey", this.apikey);
        parms.put("start_time", this.sdf.format(startTime));
        parms.put("end_time", this.sdf.format(endTime));
        parms.put("mobile", mobile);
        parms.put("page_num", pageNum);
        parms.put("page_size", pageSize);
        try {
            String ret = HttpUtil.post(Config.URI_PULL_SMS_REPLY, parms);
            result.setData((List<SmsRecord>)JsonUtil.fromJson(ret, t));
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setE(e);
        }
        return result;
    }
}

