/*
 * Decompiled with CFR 0.152.
 */
package com.yun.map;

import com.yun.map.Location;

public class GPSConverterUtils {
    public static final String BAIDU_LBS_TYPE = "bd09ll";
    public static double pi = Math.PI;
    public static double a = 6378245.0;
    public static double ee = 0.006693421622965943;

    public static Location gps84_To_Gcj02(double lat, double lon) {
        if (GPSConverterUtils.outOfChina(lat, lon)) {
            return null;
        }
        double dLat = GPSConverterUtils.transformLat(lon - 105.0, lat - 35.0);
        double dLon = GPSConverterUtils.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new Location(Double.isNaN(mgLat) ? 0.0 : mgLat, Double.isNaN(mgLon) ? 0.0 : mgLon);
    }

    public static Location gcj_To_Gps84(double lat, double lon) {
        Location gps = GPSConverterUtils.transform(lat, lon);
        double lontitude = lon * 2.0 - gps.getLongitude();
        double latitude = lat * 2.0 - gps.getLatitude();
        return new Location(Double.isNaN(latitude) ? 0.0 : latitude, Double.isNaN(lontitude) ? 0.0 : lontitude);
    }

    public static Location gcj02_To_Bd09(double gg_lat, double gg_lon) {
        double x = gg_lon;
        double y = gg_lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * pi);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * pi);
        double bd_lon = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new Location(Double.isNaN(bd_lat) ? 0.0 : bd_lat, Double.isNaN(bd_lon) ? 0.0 : bd_lon);
    }

    public static Location bd09_To_Gcj02(double bd_lat, double bd_lon) {
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * pi);
        double gg_lon = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new Location(Double.isNaN(gg_lat) ? 0.0 : gg_lat, Double.isNaN(gg_lon) ? 0.0 : gg_lon);
    }

    public static Location bd09_To_Gps84(double bd_lat, double bd_lon) {
        Location gcj02 = GPSConverterUtils.bd09_To_Gcj02(bd_lat, bd_lon);
        Location map84 = GPSConverterUtils.gcj_To_Gps84(gcj02.getLatitude(), gcj02.getLongitude());
        return map84;
    }

    public static Location gps84_To_bd09(double bd_lat, double bd_lon) {
        Location gcj02 = GPSConverterUtils.gps84_To_Gcj02(bd_lat, bd_lon);
        Location bd09 = GPSConverterUtils.gcj02_To_Bd09(gcj02.getLatitude(), gcj02.getLongitude());
        return bd09;
    }

    public static boolean outOfChina(double lat, double lon) {
        if (lon < 72.004 || lon > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    public static Location transform(double lat, double lon) {
        if (GPSConverterUtils.outOfChina(lat, lon)) {
            return new Location(lat, lon);
        }
        double dLat = GPSConverterUtils.transformLat(lon - 105.0, lat - 35.0);
        double dLon = GPSConverterUtils.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new Location(mgLat, mgLon);
    }

    public static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * pi) + 40.0 * Math.sin(y / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * pi) + 320.0 * Math.sin(y * pi / 30.0)) * 2.0 / 3.0;
    }

    public static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * pi) + 40.0 * Math.sin(x / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * pi) + 300.0 * Math.sin(x / 30.0 * pi)) * 2.0 / 3.0;
    }
}

