/*
 * Decompiled with CFR 0.152.
 */
package com.yun.map;

import com.yun.map.GPSConverterUtils;

public class Location {
    private double latitude;
    private double longitude;
    private String city;
    private float direction;
    private long time;
    private float speed;
    private String addrStr;
    private float radius;
    private double gaoDeLatitude;
    private double gaoDeLongitude;

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public String getAddrStr() {
        return this.addrStr;
    }

    public void setAddrStr(String addrStr) {
        this.addrStr = addrStr;
    }

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public double getLongitude() {
        if (this.longitude == 0.0 && this.gaoDeLongitude != 0.0) {
            Location gaodeLocation = GPSConverterUtils.gcj02_To_Bd09(this.gaoDeLatitude, this.gaoDeLongitude);
            this.latitude = gaodeLocation.getLatitude();
            this.longitude = gaodeLocation.getLongitude();
        }
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Location(double latitude, double longitude, String city, float direction, long time) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.city = city;
        this.direction = direction;
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getLatitude() {
        if (this.latitude == 0.0 && this.gaoDeLatitude != 0.0) {
            Location gaodeLocation = GPSConverterUtils.gcj02_To_Bd09(this.gaoDeLatitude, this.gaoDeLongitude);
            this.latitude = gaodeLocation.getLatitude();
            this.longitude = gaodeLocation.getLongitude();
        }
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public float getDirection() {
        return this.direction;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public double getGaoDeLatitude() {
        if (this.gaoDeLatitude == 0.0 && this.longitude != 0.0) {
            Location gaodeLocation = GPSConverterUtils.bd09_To_Gcj02(this.latitude, this.longitude);
            this.gaoDeLatitude = gaodeLocation.getLatitude();
            this.gaoDeLongitude = gaodeLocation.getLongitude();
        }
        return this.gaoDeLatitude;
    }

    public void setGaoDeLatitude(double gaoDeLatitude) {
        this.gaoDeLatitude = gaoDeLatitude;
    }

    public double getGaoDeLongitude() {
        if (this.gaoDeLongitude == 0.0 && this.longitude != 0.0) {
            Location gaodeLocation = GPSConverterUtils.bd09_To_Gcj02(this.latitude, this.longitude);
            this.gaoDeLatitude = gaodeLocation.getLatitude();
            this.gaoDeLongitude = gaodeLocation.getLongitude();
        }
        return this.gaoDeLongitude;
    }

    public void setGaoDeLongitude(double gaoDeLongitude) {
        this.gaoDeLongitude = gaoDeLongitude;
    }
}

