package com.yun.map;

/**
 * 坐标数据
 */
public class Location {
    private double latitude;
    private double longitude;
    private String city;
    private float direction;
    private long time;
    private float speed;
    private String addrStr;
    private float radius;
    private double gaoDeLatitude;
    private double gaoDeLongitude;

    public float getRadius() {
        return radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public String getAddrStr() {
        return addrStr;
    }

    public void setAddrStr(String addrStr) {
        this.addrStr = addrStr;
    }

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }


    public float getSpeed() {
        return speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public double getLongitude() {
        if (longitude == 0) {
            double[] l = gaoDeToBaidu(gaoDeLongitude, gaoDeLatitude);
            latitude = l[0];
            longitude = l[1];
        }
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Location(double latitude, double longitude, String city, float direction, long time) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.city = city;
        this.direction = direction;
        this.time = time;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getLatitude() {
        if (latitude == 0) {
            double[] l = gaoDeToBaidu(gaoDeLongitude, gaoDeLatitude);
            latitude = l[0];
            longitude = l[1];
        }
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public float getDirection() {
        return direction;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public double getGaoDeLatitude() {
        if (gaoDeLatitude == 0) {
            double[] l = gaoDeToBaidu(longitude, latitude);
            gaoDeLatitude = l[0];
            gaoDeLongitude = l[1];
        }
        return gaoDeLatitude;
    }

    public void setGaoDeLatitude(double gaoDeLatitude) {
        this.gaoDeLatitude = gaoDeLatitude;
    }

    public double getGaoDeLongitude() {
        if (gaoDeLongitude == 0) {
            double[] l = gaoDeToBaidu(longitude, latitude);
            gaoDeLatitude = l[0];
            gaoDeLongitude = l[1];
        }
        return gaoDeLongitude;
    }

    public void setGaoDeLongitude(double gaoDeLongitude) {
        this.gaoDeLongitude = gaoDeLongitude;
    }


    private double[] gaoDeToBaidu(double gd_lon, double gd_lat) {
        double[] bd_lat_lon = new double[2];
        double PI = 3.14159265358979324 * 3000.0 / 180.0;
        double x = gd_lon, y = gd_lat;
        double z = Math.sqrt(x * x + y * y) + 0.00002 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) + 0.000003 * Math.cos(x * PI);
        bd_lat_lon[0] = z * Math.cos(theta) + 0.0065;
        bd_lat_lon[1] = z * Math.sin(theta) + 0.006;
        return bd_lat_lon;
    }

    private double[] bdToGaoDe(double bd_lat, double bd_lon) {
        double[] gd_lat_lon = new double[2];
        double PI = 3.14159265358979324 * 3000.0 / 180.0;
        double x = bd_lon - 0.0065, y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * PI);
        gd_lat_lon[0] = z * Math.cos(theta);
        gd_lat_lon[1] = z * Math.sin(theta);
        return gd_lat_lon;
    }
}
