package com.yun.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;

import java.util.List;

/**
 * 地图抽象接口
 */
public interface IMap {
    /**
     * 创建地图view
     *
     * @param context
     * @param location
     * @param zoom
     * @return
     */
    public View createMapView(Context context, Location location, int zoom);

    /**
     * 生命周期
     */
    public void onResume();

    /**
     * 生命周期
     */
    public void onPause();

    /**
     * 生命周期
     */
    public void onDestory();


    /**
     * 增加覆盖物
     *
     * @param location
     * @param icon
     */
    public void addOverlay(Location location, Bitmap icon);


    /**
     * 设置地图上选中的位置
     *
     * @param location
     * @param time
     */
    public void setLocation(Location location, String time);


    /**
     * 设置地图状态监听
     *
     * @param iMapStatusChangeListener
     */
    public void setOnMapStatusChangeListener(IMapStatusChangeListener iMapStatusChangeListener);


    /**
     * 获取路线搜索
     *
     * @return
     */
    public IRoutePlanSearch getRoutePlanSearch(IRoutePlanSearch.IRouteLineStyle iRouteLineStyle);


    /**
     * 获取定位服务
     *
     * @return
     */
    public ILocationService getLocationService();


    /**
     * 绘制路线
     *
     * @param locations
     */
    public void drawRoute(List<Location> locations, IRoutePlanSearch.IRouteLineStyle iRouteLineStyle);


    /**
     * 添加覆盖物
     *
     * @param views
     */
    public void showInfoWindow(List<View> views);


    /**
     * 地图动画
     *
     * @param startLocation
     * @param endLocation
     * @param time
     */
    public void animateMapStatus(Location startLocation, Location endLocation, int time);


}
