package com.yun.map;

/**
 * 路线搜索接口
 */
public interface IRoutePlanSearch {

    /**
     * 添加监听
     *
     * @param iRoutePlanSearchListener
     */
    public void addListener(IRoutePlanSearchListener iRoutePlanSearchListener);


    /**
     * 路线搜索
     *
     * @param fromLocation
     * @param toLocation
     */
    public void drivingSearch(Location fromLocation
            , Location toLocation);


    /**
     * 路线搜索监听
     */
    public interface IRoutePlanSearchListener {
        /**
         * 路线搜索接口返回结果
         */
        public void onGetDrivingRouteResult();

    }
}
