/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Picture;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.androidquery.util.AQUtility;
import com.androidquery.util.Common;
import java.io.InputStream;

public class WebImage
extends WebViewClient {
    private Object progress;
    private WebView wv;
    private String url;
    private boolean zoom;
    private boolean control;
    private int color;
    private static String template;
    private static final String PREF_FILE = "WebViewSettings";
    private static final String DOUBLE_TAP_TOAST_COUNT = "double_tap_toast_count";

    private static String getSource(Context context) {
        if (template == null) {
            try {
                InputStream is = context.getClassLoader().getResourceAsStream("com/androidquery/util/web_image.html");
                template = new String(AQUtility.toBytes(is));
            }
            catch (Exception e) {
                AQUtility.debug(e);
            }
        }
        return template;
    }

    private static void fixWebviewTip(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREF_FILE, 0);
        if (prefs.getInt(DOUBLE_TAP_TOAST_COUNT, 1) > 0) {
            prefs.edit().putInt(DOUBLE_TAP_TOAST_COUNT, 0).commit();
        }
    }

    public WebImage(WebView wv, String url, Object progress, boolean zoom, boolean control, int color) {
        this.wv = wv;
        this.url = url;
        this.progress = progress;
        this.zoom = zoom;
        this.control = control;
        this.color = color;
    }

    public void load() {
        if (this.url.equals(this.wv.getTag(1090453505))) {
            return;
        }
        this.wv.setTag(1090453505, (Object)this.url);
        if (Build.VERSION.SDK_INT <= 10) {
            this.wv.setDrawingCacheEnabled(true);
        }
        WebImage.fixWebviewTip(this.wv.getContext());
        WebSettings ws = this.wv.getSettings();
        ws.setSupportZoom(this.zoom);
        ws.setBuiltInZoomControls(this.zoom);
        if (!this.control) {
            WebImage.disableZoomControl(this.wv);
        }
        ws.setJavaScriptEnabled(true);
        this.wv.setBackgroundColor(this.color);
        if (this.progress != null) {
            Common.showProgress(this.progress, this.url, true);
        }
        if (this.wv.getWidth() > 0) {
            this.setup();
        } else {
            this.delaySetup();
        }
    }

    private void delaySetup() {
        this.wv.setPictureListener(new WebView.PictureListener(){

            public void onNewPicture(WebView view, Picture picture) {
                WebImage.this.wv.setPictureListener(null);
                WebImage.this.setup();
            }
        });
        this.wv.loadData("<html></html>", "text/html", "utf-8");
        this.wv.setBackgroundColor(this.color);
    }

    private void setup() {
        String source = WebImage.getSource(this.wv.getContext());
        String html = source.replace("@src", this.url).replace("@color", Integer.toHexString(this.color));
        this.wv.setWebViewClient((WebViewClient)this);
        this.wv.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
        this.wv.setBackgroundColor(this.color);
    }

    private void done(WebView view) {
        if (this.progress != null) {
            view.setVisibility(0);
            Common.showProgress(this.progress, this.url, false);
        }
        view.setWebViewClient(null);
    }

    public void onPageFinished(WebView view, String url) {
        this.done(view);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.done(view);
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
    }

    private static void disableZoomControl(WebView wv) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        WebSettings ws = wv.getSettings();
        AQUtility.invokeHandler((Object)ws, "setDisplayZoomControls", false, false, new Class[]{Boolean.TYPE}, false);
    }
}

