/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.Gallery;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;
import com.androidquery.auth.AccountHandle;
import com.androidquery.callback.AbstractAjaxCallback;
import com.androidquery.callback.AjaxCallback;
import com.androidquery.callback.BitmapAjaxCallback;
import com.androidquery.callback.ImageOptions;
import com.androidquery.callback.Transformer;
import com.androidquery.util.AQUtility;
import com.androidquery.util.Common;
import com.androidquery.util.Constants;
import com.androidquery.util.WebImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

public abstract class AbstractAQuery<T extends AbstractAQuery<T>>
implements Constants {
    private View root;
    private Activity act;
    private Context context;
    protected View view;
    protected Object progress;
    protected AccountHandle ah;
    private Transformer trans;
    private int policy = 0;
    private HttpHost proxy;
    private Constructor<T> constructor;
    private static final Class<?>[] ON_CLICK_SIG = new Class[]{View.class};
    private static Class<?>[] ON_ITEM_SIG = new Class[]{AdapterView.class, View.class, Integer.TYPE, Long.TYPE};
    private static Class<?>[] ON_SCROLLED_STATE_SIG = new Class[]{AbsListView.class, Integer.TYPE};
    private static final Class<?>[] TEXT_CHANGE_SIG = new Class[]{CharSequence.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static Class<?>[] PENDING_TRANSITION_SIG = new Class[]{Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] OVER_SCROLL_SIG = new Class[]{Integer.TYPE};
    private static Class<?>[] LAYER_TYPE_SIG = new Class[]{Integer.TYPE, Paint.class};
    private static WeakHashMap<Dialog, Void> dialogs = new WeakHashMap();

    protected T create(View view) {
        AbstractAQuery result = null;
        try {
            Constructor<T> c = this.getConstructor();
            result = (AbstractAQuery)c.newInstance(view);
            result.act = this.act;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    private Constructor<T> getConstructor() {
        if (this.constructor == null) {
            try {
                this.constructor = this.getClass().getConstructor(View.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.constructor;
    }

    public AbstractAQuery(Activity act) {
        this.act = act;
    }

    public AbstractAQuery(View root) {
        this.root = root;
        this.view = root;
    }

    public AbstractAQuery(Activity act, View root) {
        this.root = root;
        this.view = root;
        this.act = act;
    }

    public AbstractAQuery(Context context) {
        this.context = context;
    }

    private View findView(int id) {
        View result = null;
        if (this.root != null) {
            result = this.root.findViewById(id);
        } else if (this.act != null) {
            result = this.act.findViewById(id);
        }
        return result;
    }

    private View findView(String tag) {
        View top;
        View result = null;
        if (this.root != null) {
            result = this.root.findViewWithTag((Object)tag);
        } else if (this.act != null && (top = ((ViewGroup)this.act.findViewById(0x1020002)).getChildAt(0)) != null) {
            result = top.findViewWithTag((Object)tag);
        }
        return result;
    }

    private View findView(int ... path) {
        View result = this.findView(path[0]);
        int i = 1;
        while (i < path.length && result != null) {
            result = result.findViewById(path[i]);
            ++i;
        }
        return result;
    }

    public T find(int id) {
        View view = this.findView(id);
        return this.create(view);
    }

    public T parent(int id) {
        View node = this.view;
        View result = null;
        while (node != null) {
            if (node.getId() == id) {
                result = node;
                break;
            }
            ViewParent p = node.getParent();
            if (!(p instanceof View)) break;
            node = (View)p;
        }
        return this.create(result);
    }

    public T recycle(View root) {
        this.root = root;
        this.view = root;
        this.reset();
        this.context = null;
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    public View getView() {
        return this.view;
    }

    public T id(int id) {
        return this.id(this.findView(id));
    }

    public T id(View view) {
        this.view = view;
        this.reset();
        return this.self();
    }

    public T id(String tag) {
        return this.id(this.findView(tag));
    }

    public T id(int ... path) {
        return this.id(this.findView(path));
    }

    public T progress(int id) {
        this.progress = this.findView(id);
        return this.self();
    }

    public T progress(Object view) {
        this.progress = view;
        return this.self();
    }

    public T progress(Dialog dialog) {
        this.progress = dialog;
        return this.self();
    }

    public T auth(AccountHandle handle) {
        this.ah = handle;
        return this.self();
    }

    public T transformer(Transformer transformer) {
        this.trans = transformer;
        return this.self();
    }

    public T policy(int cachePolicy) {
        this.policy = cachePolicy;
        return this.self();
    }

    public T proxy(String host, int port) {
        this.proxy = new HttpHost(host, port);
        return this.self();
    }

    public T rating(float rating) {
        if (this.view instanceof RatingBar) {
            RatingBar rb = (RatingBar)this.view;
            rb.setRating(rating);
        }
        return this.self();
    }

    public T text(int resid) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            tv.setText(resid);
        }
        return this.self();
    }

    public T text(int resid, Object ... formatArgs) {
        Context context = this.getContext();
        if (context != null) {
            String text = context.getString(resid, formatArgs);
            this.text(text);
        }
        return this.self();
    }

    public T text(CharSequence text) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            tv.setText(text);
        }
        return this.self();
    }

    public T text(CharSequence text, boolean goneIfEmpty) {
        if (goneIfEmpty && (text == null || text.length() == 0)) {
            return this.gone();
        }
        return this.text(text);
    }

    public T text(Spanned text) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            tv.setText((CharSequence)text);
        }
        return this.self();
    }

    public T textColor(int color) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            tv.setTextColor(color);
        }
        return this.self();
    }

    public T textColorId(int id) {
        return this.textColor(this.getContext().getResources().getColor(id));
    }

    public T typeface(Typeface tf) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            tv.setTypeface(tf);
        }
        return this.self();
    }

    public T textSize(float size) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            tv.setTextSize(size);
        }
        return this.self();
    }

    public T adapter(Adapter adapter) {
        if (this.view instanceof AdapterView) {
            AdapterView av = (AdapterView)this.view;
            av.setAdapter(adapter);
        }
        return this.self();
    }

    public T adapter(ExpandableListAdapter adapter) {
        if (this.view instanceof ExpandableListView) {
            ExpandableListView av = (ExpandableListView)this.view;
            av.setAdapter(adapter);
        }
        return this.self();
    }

    public T image(int resid) {
        if (this.view instanceof ImageView) {
            ImageView iv = (ImageView)this.view;
            iv.setTag(1090453505, null);
            if (resid == 0) {
                iv.setImageBitmap(null);
            } else {
                iv.setImageResource(resid);
            }
        }
        return this.self();
    }

    public T image(Drawable drawable) {
        if (this.view instanceof ImageView) {
            ImageView iv = (ImageView)this.view;
            iv.setTag(1090453505, null);
            iv.setImageDrawable(drawable);
        }
        return this.self();
    }

    public T image(Bitmap bm) {
        if (this.view instanceof ImageView) {
            ImageView iv = (ImageView)this.view;
            iv.setTag(1090453505, null);
            iv.setImageBitmap(bm);
        }
        return this.self();
    }

    public T image(String url) {
        return this.image(url, true, true, 0, 0);
    }

    public T image(String url, boolean memCache, boolean fileCache) {
        return this.image(url, memCache, fileCache, 0, 0);
    }

    public T image(String url, boolean memCache, boolean fileCache, int targetWidth, int fallbackId) {
        return this.image(url, memCache, fileCache, targetWidth, fallbackId, null, 0);
    }

    public T image(String url, boolean memCache, boolean fileCache, int targetWidth, int fallbackId, Bitmap preset, int animId) {
        return this.image(url, memCache, fileCache, targetWidth, fallbackId, preset, animId, 0.0f);
    }

    public T image(String url, boolean memCache, boolean fileCache, int targetWidth, int fallbackId, Bitmap preset, int animId, float ratio) {
        return this.image(url, memCache, fileCache, targetWidth, fallbackId, preset, animId, ratio, 0, null);
    }

    protected T image(String url, boolean memCache, boolean fileCache, int targetWidth, int fallbackId, Bitmap preset, int animId, float ratio, int round, String networkUrl) {
        if (this.view instanceof ImageView) {
            BitmapAjaxCallback.async(this.act, this.getContext(), (ImageView)this.view, url, memCache, fileCache, targetWidth, fallbackId, preset, animId, ratio, Float.MAX_VALUE, this.progress, this.ah, this.policy, round, this.proxy, networkUrl);
            this.reset();
        }
        return this.self();
    }

    public T image(String url, ImageOptions options) {
        return this.image(url, options, null);
    }

    protected T image(String url, ImageOptions options, String networkUrl) {
        if (this.view instanceof ImageView) {
            BitmapAjaxCallback.async(this.act, this.getContext(), (ImageView)this.view, url, this.progress, this.ah, options, this.proxy, networkUrl);
            this.reset();
        }
        return this.self();
    }

    public T image(BitmapAjaxCallback callback) {
        if (this.view instanceof ImageView) {
            callback.imageView((ImageView)this.view);
            this.invoke(callback);
        }
        return this.self();
    }

    public T image(String url, boolean memCache, boolean fileCache, int targetWidth, int resId, BitmapAjaxCallback callback) {
        ((BitmapAjaxCallback)((BitmapAjaxCallback)callback.targetWidth(targetWidth).fallback(resId).url(url)).memCache(memCache)).fileCache(fileCache);
        return this.image(callback);
    }

    public T image(File file, int targetWidth) {
        return this.image(file, true, targetWidth, null);
    }

    public T image(File file, boolean memCache, int targetWidth, BitmapAjaxCallback callback) {
        if (callback == null) {
            callback = new BitmapAjaxCallback();
        }
        callback.file(file);
        String url = null;
        if (file != null) {
            url = file.getAbsolutePath();
        }
        return this.image(url, memCache, true, targetWidth, 0, callback);
    }

    public T image(Bitmap bm, float ratio) {
        BitmapAjaxCallback cb = new BitmapAjaxCallback();
        cb.ratio(ratio).bitmap(bm);
        return this.image(cb);
    }

    public T tag(Object tag) {
        if (this.view != null) {
            this.view.setTag(tag);
        }
        return this.self();
    }

    public T tag(int key, Object tag) {
        if (this.view != null) {
            this.view.setTag(key, tag);
        }
        return this.self();
    }

    public T transparent(boolean transparent) {
        if (this.view != null) {
            AQUtility.transparent(this.view, transparent);
        }
        return this.self();
    }

    public T enabled(boolean enabled) {
        if (this.view != null) {
            this.view.setEnabled(enabled);
        }
        return this.self();
    }

    public T checked(boolean checked) {
        if (this.view instanceof CompoundButton) {
            CompoundButton cb = (CompoundButton)this.view;
            cb.setChecked(checked);
        }
        return this.self();
    }

    public boolean isChecked() {
        boolean checked = false;
        if (this.view instanceof CompoundButton) {
            CompoundButton cb = (CompoundButton)this.view;
            checked = cb.isChecked();
        }
        return checked;
    }

    public T clickable(boolean clickable) {
        if (this.view != null) {
            this.view.setClickable(clickable);
        }
        return this.self();
    }

    public T gone() {
        return this.visibility(8);
    }

    public T invisible() {
        return this.visibility(4);
    }

    public T visible() {
        return this.visibility(0);
    }

    public T visibility(int visibility) {
        if (this.view != null && this.view.getVisibility() != visibility) {
            this.view.setVisibility(visibility);
        }
        return this.self();
    }

    public T background(int id) {
        if (this.view != null) {
            if (id != 0) {
                this.view.setBackgroundResource(id);
            } else {
                this.view.setBackgroundDrawable(null);
            }
        }
        return this.self();
    }

    public T backgroundColor(int color) {
        if (this.view != null) {
            this.view.setBackgroundColor(color);
        }
        return this.self();
    }

    public T backgroundColorId(int colorId) {
        if (this.view != null) {
            this.view.setBackgroundColor(this.getContext().getResources().getColor(colorId));
        }
        return this.self();
    }

    public T dataChanged() {
        AdapterView av;
        Adapter a;
        if (this.view instanceof AdapterView && (a = (av = (AdapterView)this.view).getAdapter()) instanceof BaseAdapter) {
            BaseAdapter ba = (BaseAdapter)a;
            ba.notifyDataSetChanged();
        }
        return this.self();
    }

    public boolean isExist() {
        return this.view != null;
    }

    public Object getTag() {
        Object result = null;
        if (this.view != null) {
            result = this.view.getTag();
        }
        return result;
    }

    public Object getTag(int id) {
        Object result = null;
        if (this.view != null) {
            result = this.view.getTag(id);
        }
        return result;
    }

    public ImageView getImageView() {
        return (ImageView)this.view;
    }

    public Gallery getGallery() {
        return (Gallery)this.view;
    }

    public TextView getTextView() {
        return (TextView)this.view;
    }

    public EditText getEditText() {
        return (EditText)this.view;
    }

    public ProgressBar getProgressBar() {
        return (ProgressBar)this.view;
    }

    public SeekBar getSeekBar() {
        return (SeekBar)this.view;
    }

    public Button getButton() {
        return (Button)this.view;
    }

    public CheckBox getCheckBox() {
        return (CheckBox)this.view;
    }

    public ListView getListView() {
        return (ListView)this.view;
    }

    public ExpandableListView getExpandableListView() {
        return (ExpandableListView)this.view;
    }

    public GridView getGridView() {
        return (GridView)this.view;
    }

    public RatingBar getRatingBar() {
        return (RatingBar)this.view;
    }

    public WebView getWebView() {
        return (WebView)this.view;
    }

    public Spinner getSpinner() {
        return (Spinner)this.view;
    }

    public Editable getEditable() {
        Editable result = null;
        if (this.view instanceof EditText) {
            result = ((EditText)this.view).getEditableText();
        }
        return result;
    }

    public CharSequence getText() {
        CharSequence result = null;
        if (this.view instanceof TextView) {
            result = ((TextView)this.view).getText();
        }
        return result;
    }

    public Object getSelectedItem() {
        Object result = null;
        if (this.view instanceof AdapterView) {
            result = ((AdapterView)this.view).getSelectedItem();
        }
        return result;
    }

    public int getSelectedItemPosition() {
        int result = -1;
        if (this.view instanceof AdapterView) {
            result = ((AdapterView)this.view).getSelectedItemPosition();
        }
        return result;
    }

    public T clicked(Object handler, String method) {
        Common common = new Common().forward(handler, method, true, ON_CLICK_SIG);
        return this.clicked(common);
    }

    public T clicked(View.OnClickListener listener) {
        if (this.view != null) {
            this.view.setOnClickListener(listener);
        }
        return this.self();
    }

    public T longClicked(Object handler, String method) {
        Common common = new Common().forward(handler, method, true, ON_CLICK_SIG);
        return this.longClicked(common);
    }

    public T longClicked(View.OnLongClickListener listener) {
        if (this.view != null) {
            this.view.setOnLongClickListener(listener);
        }
        return this.self();
    }

    public T itemClicked(Object handler, String method) {
        Common common = new Common().forward(handler, method, true, ON_ITEM_SIG);
        return this.itemClicked(common);
    }

    public T itemClicked(AdapterView.OnItemClickListener listener) {
        if (this.view instanceof AdapterView) {
            AdapterView alv = (AdapterView)this.view;
            alv.setOnItemClickListener(listener);
        }
        return this.self();
    }

    public T itemSelected(Object handler, String method) {
        Common common = new Common().forward(handler, method, true, ON_ITEM_SIG);
        return this.itemSelected(common);
    }

    public T itemSelected(AdapterView.OnItemSelectedListener listener) {
        if (this.view instanceof AdapterView) {
            AdapterView alv = (AdapterView)this.view;
            alv.setOnItemSelectedListener(listener);
        }
        return this.self();
    }

    public T setSelection(int position) {
        if (this.view instanceof AdapterView) {
            AdapterView alv = (AdapterView)this.view;
            alv.setSelection(position);
        }
        return this.self();
    }

    public T scrolledBottom(Object handler, String method) {
        if (this.view instanceof AbsListView) {
            this.setScrollListener().forward(handler, method, true, ON_SCROLLED_STATE_SIG);
        }
        return this.self();
    }

    private Common setScrollListener() {
        AbsListView lv = (AbsListView)this.view;
        Common common = (Common)lv.getTag(1090453506);
        if (common == null) {
            common = new Common();
            lv.setOnScrollListener((AbsListView.OnScrollListener)common);
            lv.setTag(1090453506, (Object)common);
            AQUtility.debug("set scroll listenr");
        }
        return common;
    }

    public T scrolled(AbsListView.OnScrollListener listener) {
        if (this.view instanceof AbsListView) {
            this.setScrollListener().forward(listener);
        }
        return this.self();
    }

    public T textChanged(Object handler, String method) {
        if (this.view instanceof TextView) {
            TextView tv = (TextView)this.view;
            Common common = new Common().forward(handler, method, true, TEXT_CHANGE_SIG);
            tv.addTextChangedListener((TextWatcher)common);
        }
        return this.self();
    }

    public T overridePendingTransition5(int enterAnim, int exitAnim) {
        if (this.act != null) {
            AQUtility.invokeHandler((Object)this.act, "overridePendingTransition", false, false, PENDING_TRANSITION_SIG, enterAnim, exitAnim);
        }
        return this.self();
    }

    public T setOverScrollMode9(int mode) {
        if (this.view instanceof AbsListView) {
            AQUtility.invokeHandler((Object)this.view, "setOverScrollMode", false, false, OVER_SCROLL_SIG, mode);
        }
        return this.self();
    }

    public T setLayerType11(int type, Paint paint) {
        if (this.view != null) {
            AQUtility.invokeHandler((Object)this.view, "setLayerType", false, false, LAYER_TYPE_SIG, type, paint);
        }
        return this.self();
    }

    public Object invoke(String method, Class<?>[] sig, Object ... params) {
        View handler = this.view;
        if (handler == null) {
            handler = this.act;
        }
        return AQUtility.invokeHandler((Object)handler, method, false, false, sig, params);
    }

    public T hardwareAccelerated11() {
        if (this.act != null) {
            this.act.getWindow().setFlags(0x1000000, 0x1000000);
        }
        return this.self();
    }

    public T clear() {
        if (this.view != null) {
            if (this.view instanceof ImageView) {
                ImageView iv = (ImageView)this.view;
                iv.setImageBitmap(null);
                iv.setTag(1090453505, null);
            } else if (this.view instanceof WebView) {
                WebView wv = (WebView)this.view;
                wv.stopLoading();
                wv.clearView();
                wv.setTag(1090453505, null);
            } else if (this.view instanceof TextView) {
                TextView tv = (TextView)this.view;
                tv.setText((CharSequence)"");
            }
        }
        return this.self();
    }

    public T margin(float leftDip, float topDip, float rightDip, float bottomDip) {
        ViewGroup.LayoutParams lp;
        if (this.view != null && (lp = this.view.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams) {
            Context context = this.getContext();
            int left = AQUtility.dip2pixel(context, leftDip);
            int top = AQUtility.dip2pixel(context, topDip);
            int right = AQUtility.dip2pixel(context, rightDip);
            int bottom = AQUtility.dip2pixel(context, bottomDip);
            ((ViewGroup.MarginLayoutParams)lp).setMargins(left, top, right, bottom);
            this.view.setLayoutParams(lp);
        }
        return this.self();
    }

    public T width(int dip) {
        this.size(true, dip, true);
        return this.self();
    }

    public T height(int dip) {
        this.size(false, dip, true);
        return this.self();
    }

    public T width(int width, boolean dip) {
        this.size(true, width, dip);
        return this.self();
    }

    public T height(int height, boolean dip) {
        this.size(false, height, dip);
        return this.self();
    }

    private void size(boolean width, int n, boolean dip) {
        if (this.view != null) {
            ViewGroup.LayoutParams lp = this.view.getLayoutParams();
            Context context = this.getContext();
            if (n > 0 && dip) {
                n = AQUtility.dip2pixel(context, n);
            }
            if (width) {
                lp.width = n;
            } else {
                lp.height = n;
            }
            this.view.setLayoutParams(lp);
        }
    }

    public Context getContext() {
        if (this.act != null) {
            return this.act;
        }
        if (this.root != null) {
            return this.root.getContext();
        }
        return this.context;
    }

    public <K> T ajax(AjaxCallback<K> callback) {
        return this.invoke(callback);
    }

    protected <K> T invoke(AbstractAjaxCallback<?, K> cb) {
        if (this.ah != null) {
            cb.auth(this.ah);
        }
        if (this.progress != null) {
            cb.progress(this.progress);
        }
        if (this.trans != null) {
            cb.transformer(this.trans);
        }
        cb.policy(this.policy);
        if (this.proxy != null) {
            cb.proxy(this.proxy.getHostName(), this.proxy.getPort());
        }
        if (this.act != null) {
            cb.async(this.act);
        } else {
            cb.async(this.getContext());
        }
        this.reset();
        return this.self();
    }

    protected void reset() {
        this.ah = null;
        this.progress = null;
        this.trans = null;
        this.policy = 0;
        this.proxy = null;
    }

    public <K> T ajax(String url, Class<K> type, AjaxCallback<K> callback) {
        ((AjaxCallback)callback.type(type)).url(url);
        return this.ajax(callback);
    }

    public <K> T ajax(String url, Class<K> type, long expire, AjaxCallback<K> callback) {
        ((AjaxCallback)((AjaxCallback)((AjaxCallback)callback.type(type)).url(url)).fileCache(true)).expire(expire);
        return this.ajax(callback);
    }

    public <K> T ajax(String url, Class<K> type, Object handler, String callback) {
        AjaxCallback<K> cb = new AjaxCallback<K>();
        ((AjaxCallback)cb.type(type)).weakHandler(handler, callback);
        return this.ajax(url, type, cb);
    }

    public <K> T ajax(String url, Class<K> type, long expire, Object handler, String callback) {
        AjaxCallback<K> cb = new AjaxCallback<K>();
        ((AjaxCallback)((AjaxCallback)((AjaxCallback)cb.type(type)).weakHandler(handler, callback)).fileCache(true)).expire(expire);
        return this.ajax(url, type, cb);
    }

    public <K> T ajax(String url, Map<String, ?> params, Class<K> type, AjaxCallback<K> callback) {
        ((AjaxCallback)((AjaxCallback)callback.type(type)).url(url)).params(params);
        return this.ajax(callback);
    }

    public <K> T ajax(String url, Map<String, ?> params, Class<K> type, Object handler, String callback) {
        AjaxCallback<K> cb = new AjaxCallback<K>();
        ((AjaxCallback)cb.type(type)).weakHandler(handler, callback);
        return this.ajax(url, params, type, cb);
    }

    public <K> T delete(String url, Class<K> type, AjaxCallback<K> callback) {
        ((AjaxCallback)((AjaxCallback)callback.url(url)).type(type)).method(2);
        return this.ajax(callback);
    }

    public <K> T put(String url, String contentHeader, HttpEntity entity, Class<K> type, AjaxCallback<K> callback) {
        ((AjaxCallback)((AjaxCallback)((AjaxCallback)((AjaxCallback)callback.url(url)).type(type)).method(3)).header("Content-Type", contentHeader)).param("%entity", entity);
        return this.ajax(callback);
    }

    public <K> T post(String url, String contentHeader, HttpEntity entity, Class<K> type, AjaxCallback<K> callback) {
        ((AjaxCallback)((AjaxCallback)((AjaxCallback)((AjaxCallback)callback.url(url)).type(type)).method(1)).header("Content-Type", contentHeader)).param("%entity", entity);
        return this.ajax(callback);
    }

    public <K> T post(String url, JSONObject jo, Class<K> type, AjaxCallback<K> callback) {
        try {
            StringEntity entity = new StringEntity(jo.toString(), "UTF-8");
            return this.post(url, "application/json", (HttpEntity)entity, type, callback);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <K> T put(String url, JSONObject jo, Class<K> type, AjaxCallback<K> callback) {
        try {
            StringEntity entity = new StringEntity(jo.toString(), "UTF-8");
            return this.put(url, "application/json", (HttpEntity)entity, type, callback);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <K> T delete(String url, Class<K> type, Object handler, String callback) {
        AjaxCallback cb = new AjaxCallback();
        cb.weakHandler(handler, callback);
        return this.delete(url, type, cb);
    }

    public <K> T sync(AjaxCallback<K> callback) {
        this.ajax(callback);
        callback.block();
        return this.self();
    }

    public T cache(String url, long expire) {
        return this.ajax(url, byte[].class, expire, null, null);
    }

    public T ajaxCancel() {
        AjaxCallback.cancel();
        return this.self();
    }

    public File getCachedFile(String url) {
        File result = AQUtility.getExistedCacheByUrl(AQUtility.getCacheDir(this.getContext(), 1), url);
        if (result == null) {
            result = AQUtility.getExistedCacheByUrl(AQUtility.getCacheDir(this.getContext(), 0), url);
        }
        return result;
    }

    public T invalidate(String url) {
        File file = this.getCachedFile(url);
        if (file != null) {
            file.delete();
        }
        return this.self();
    }

    public Bitmap getCachedImage(String url) {
        return this.getCachedImage(url, 0);
    }

    public Bitmap getCachedImage(String url, int targetWidth) {
        File file;
        Bitmap result = BitmapAjaxCallback.getMemoryCached(url, targetWidth);
        if (result == null && (file = this.getCachedFile(url)) != null) {
            result = BitmapAjaxCallback.getResizedImage(file.getAbsolutePath(), null, targetWidth, true, 0);
        }
        return result;
    }

    public Bitmap getCachedImage(int resId) {
        return BitmapAjaxCallback.getMemoryCached(this.getContext(), resId);
    }

    @Deprecated
    public boolean shouldDelay(View convertView, ViewGroup parent, String url, float velocity) {
        return Common.shouldDelay(convertView, parent, url, velocity, true);
    }

    @Deprecated
    public boolean shouldDelay(View convertView, ViewGroup parent, String url, float velocity, boolean fileCheck) {
        return Common.shouldDelay(convertView, parent, url, velocity, fileCheck);
    }

    public boolean shouldDelay(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent, String url) {
        return Common.shouldDelay(groupPosition, -1, convertView, parent, url);
    }

    public boolean shouldDelay(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent, String url) {
        return Common.shouldDelay(groupPosition, childPosition, convertView, parent, url);
    }

    public boolean shouldDelay(int position, View convertView, ViewGroup parent, String url) {
        if (parent instanceof ExpandableListView) {
            throw new IllegalArgumentException("Please use the other shouldDelay methods for expandable list.");
        }
        return Common.shouldDelay(position, convertView, parent, url);
    }

    public File makeSharedFile(String url, String filename) {
        File file;
        block5: {
            file = null;
            try {
                File temp;
                File cached = this.getCachedFile(url);
                if (cached == null || (temp = AQUtility.getTempDir()) == null) break block5;
                file = new File(temp, filename);
                file.createNewFile();
                FileInputStream fis = new FileInputStream(cached);
                FileOutputStream fos = new FileOutputStream(file);
                FileChannel ic = fis.getChannel();
                FileChannel oc = fos.getChannel();
                try {
                    ic.transferTo(0L, ic.size(), oc);
                }
                finally {
                    AQUtility.close(fis);
                    AQUtility.close(fos);
                    AQUtility.close(ic);
                    AQUtility.close(oc);
                }
            }
            catch (Exception e) {
                AQUtility.debug(e);
            }
        }
        return file;
    }

    public T animate(int animId) {
        return this.animate(animId, null);
    }

    public T animate(int animId, Animation.AnimationListener listener) {
        Animation anim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)animId);
        anim.setAnimationListener(listener);
        return this.animate(anim);
    }

    public T animate(Animation anim) {
        if (this.view != null && anim != null) {
            this.view.startAnimation(anim);
        }
        return this.self();
    }

    public T click() {
        if (this.view != null) {
            this.view.performClick();
        }
        return this.self();
    }

    public T longClick() {
        if (this.view != null) {
            this.view.performLongClick();
        }
        return this.self();
    }

    public T show(Dialog dialog) {
        try {
            if (dialog != null) {
                dialog.show();
                dialogs.put(dialog, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.self();
    }

    public T dismiss(Dialog dialog) {
        try {
            if (dialog != null) {
                dialogs.remove(dialog);
                dialog.dismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.self();
    }

    public T dismiss() {
        Iterator<Dialog> keys = dialogs.keySet().iterator();
        while (keys.hasNext()) {
            Dialog d = keys.next();
            try {
                d.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
            keys.remove();
        }
        return this.self();
    }

    public T webImage(String url) {
        return this.webImage(url, true, false, -16777216);
    }

    public T webImage(String url, boolean zoom, boolean control, int color) {
        if (this.view instanceof WebView) {
            this.setLayerType11(1, null);
            WebImage wi = new WebImage((WebView)this.view, url, this.progress, zoom, control, color);
            wi.load();
            this.progress = null;
        }
        return this.self();
    }

    public View inflate(View convertView, int layoutId, ViewGroup root) {
        Integer layout;
        if (convertView != null && (layout = (Integer)convertView.getTag(1090453507)) != null && layout == layoutId) {
            return convertView;
        }
        LayoutInflater inflater = null;
        inflater = this.act != null ? this.act.getLayoutInflater() : (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(layoutId, root, false);
        view.setTag(1090453507, (Object)layoutId);
        return view;
    }

    public T expand(int position, boolean expand) {
        if (this.view instanceof ExpandableListView) {
            ExpandableListView elv = (ExpandableListView)this.view;
            if (expand) {
                elv.expandGroup(position);
            } else {
                elv.collapseGroup(position);
            }
        }
        return this.self();
    }

    public T expand(boolean expand) {
        ExpandableListView elv;
        ExpandableListAdapter ela;
        if (this.view instanceof ExpandableListView && (ela = (elv = (ExpandableListView)this.view).getExpandableListAdapter()) != null) {
            int count = ela.getGroupCount();
            int i = 0;
            while (i < count) {
                if (expand) {
                    elv.expandGroup(i);
                } else {
                    elv.collapseGroup(i);
                }
                ++i;
            }
        }
        return this.self();
    }

    public T download(String url, File target, AjaxCallback<File> cb) {
        ((AjaxCallback)((AjaxCallback)cb.url(url)).type(File.class)).targetFile(target);
        return this.ajax(cb);
    }

    public T download(String url, File target, Object handler, String callback) {
        AjaxCallback<File> cb = new AjaxCallback<File>();
        cb.weakHandler(handler, callback);
        return this.download(url, target, cb);
    }
}

