/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.widget.cropimage;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import android.widget.Scroller;
import com.ypx.imagepicker.utils.PBitmapUtils;
import com.ypx.imagepicker.widget.cropimage.Info;
import com.ypx.imagepicker.widget.cropimage.RotateGestureDetector;

@SuppressLint(value={"AppCompatCustomView"})
public class CropImageView
extends ImageView {
    private static final int MIN_ROTATE = 35;
    private static final int ANIM_DURING = 340;
    private static final float MAX_SCALE = 2.5f;
    private static int loadMaxSize = 0;
    private int mMinRotate;
    private int mAnimDuring;
    private float mMaxScale;
    private int MAX_FLING_OVER_SCROLL = 0;
    private int MAX_OVER_RESISTANCE = 0;
    private Matrix mBaseMatrix = new Matrix();
    private Matrix mAnimMatrix = new Matrix();
    private Matrix mSynthesisMatrix = new Matrix();
    private Matrix mTmpMatrix = new Matrix();
    private RotateGestureDetector mRotateDetector;
    private GestureDetector mDetector;
    private ScaleGestureDetector mScaleDetector;
    private View.OnClickListener mClickListener;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.CENTER_INSIDE;
    private boolean hasMultiTouch;
    private boolean hasDrawable;
    private boolean isKnowSize;
    private boolean hasOverTranslate;
    private boolean isEnable = false;
    private boolean isRotateEnable = false;
    private boolean isZoomUp;
    private boolean canRotate;
    private boolean imgLargeWidth;
    private boolean imgLargeHeight;
    private float mRotateFlag;
    private float mDegrees;
    private float mScale = 1.0f;
    private int mTranslateX;
    private int mTranslateY;
    private RectF mCropRect = new RectF();
    private RectF mBaseRect = new RectF();
    private RectF mImgRect = new RectF();
    private RectF mTmpRect = new RectF();
    private RectF mCommonRect = new RectF();
    private PointF mScreenCenter = new PointF();
    private PointF mScaleCenter = new PointF();
    private PointF mRotateCenter = new PointF();
    private Paint linePaint;
    private Transform mTranslate = new Transform();
    private RectF mClip;
    private Runnable mCompleteCallBack;
    private View.OnLongClickListener mLongClick;
    private boolean isShowCropRect = true;
    private Bitmap originalBitmap;
    private Info restoreInfo;
    onImageLoadListener onImageLoadListener;
    float baseScale;
    private int aspectX = -1;
    private int aspectY = -1;
    private int cropMargin = 0;
    private boolean isShowLine = false;
    private Paint cropRectPaint;
    private Paint maskPaint;
    private Paint cropStrokePaint;
    private Rect viewDrawingRect = new Rect();
    private Path path = new Path();
    private boolean isShowImageRectLine = false;
    private boolean canShowTouchLine = true;
    private boolean isCircle = false;
    private boolean isBounceEnable = true;
    private RotateGestureDetector.OnRotateListener mRotateListener = new RotateGestureDetector.OnRotateListener(){

        @Override
        public void onRotate(float degrees, float focusX, float focusY) {
            CropImageView.this.mRotateFlag = CropImageView.this.mRotateFlag + degrees;
            if (CropImageView.this.canRotate) {
                CropImageView.this.mDegrees = CropImageView.this.mDegrees + degrees;
                CropImageView.this.mAnimMatrix.postRotate(degrees, focusX, focusY);
            } else if (Math.abs(CropImageView.this.mRotateFlag) >= (float)CropImageView.this.mMinRotate) {
                CropImageView.this.canRotate = true;
                CropImageView.this.mRotateFlag = 0.0f;
            }
        }
    };
    private ScaleGestureDetector.OnScaleGestureListener mScaleListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scaleFactor = detector.getScaleFactor();
            if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                return false;
            }
            if (CropImageView.this.mScale > CropImageView.this.mMaxScale) {
                return true;
            }
            CropImageView.this.mScale = CropImageView.this.mScale * scaleFactor;
            CropImageView.this.mScaleCenter.set(detector.getFocusX(), detector.getFocusY());
            CropImageView.this.mAnimMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
            CropImageView.this.executeTranslate();
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    };
    private Runnable mClickRunnable = new Runnable(){

        @Override
        public void run() {
            if (CropImageView.this.mClickListener != null) {
                CropImageView.this.mClickListener.onClick((View)CropImageView.this);
            }
        }
    };
    private GestureDetector.OnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public void onLongPress(MotionEvent e) {
            if (CropImageView.this.mLongClick != null) {
                CropImageView.this.mLongClick.onLongClick((View)CropImageView.this);
            }
        }

        public boolean onDown(MotionEvent e) {
            CropImageView.this.hasOverTranslate = false;
            CropImageView.this.hasMultiTouch = false;
            CropImageView.this.canRotate = false;
            CropImageView.this.removeCallbacks(CropImageView.this.mClickRunnable);
            return false;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (CropImageView.this.hasMultiTouch) {
                return false;
            }
            if (!CropImageView.this.imgLargeWidth && !CropImageView.this.imgLargeHeight) {
                return false;
            }
            if (((CropImageView)CropImageView.this).mTranslate.isRunning) {
                return false;
            }
            float vx = velocityX;
            float vy = velocityY;
            if ((float)Math.round(((CropImageView)CropImageView.this).mImgRect.left) >= ((CropImageView)CropImageView.this).mCropRect.left || (float)Math.round(((CropImageView)CropImageView.this).mImgRect.right) <= ((CropImageView)CropImageView.this).mCropRect.right) {
                vx = 0.0f;
            }
            if ((float)Math.round(((CropImageView)CropImageView.this).mImgRect.top) >= ((CropImageView)CropImageView.this).mCropRect.top || (float)Math.round(((CropImageView)CropImageView.this).mImgRect.bottom) <= ((CropImageView)CropImageView.this).mCropRect.bottom) {
                vy = 0.0f;
            }
            if (CropImageView.this.canRotate || CropImageView.this.mDegrees % 90.0f != 0.0f) {
                float toDegrees = (int)(CropImageView.this.mDegrees / 90.0f) * 90;
                float remainder = CropImageView.this.mDegrees % 90.0f;
                if (remainder > 45.0f) {
                    toDegrees += 90.0f;
                } else if (remainder < -45.0f) {
                    toDegrees -= 90.0f;
                }
                CropImageView.this.mTranslate.withRotate((int)CropImageView.this.mDegrees, (int)toDegrees);
                CropImageView.this.mDegrees = toDegrees;
            }
            CropImageView.this.mTranslate.withFling(vx, vy);
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (((CropImageView)CropImageView.this).mTranslate.isRunning) {
                CropImageView.this.mTranslate.stop();
            }
            if (CropImageView.this.canScrollHorizontallySelf(distanceX)) {
                if (distanceX < 0.0f && ((CropImageView)CropImageView.this).mImgRect.left - distanceX > ((CropImageView)CropImageView.this).mCropRect.left) {
                    distanceX = ((CropImageView)CropImageView.this).mImgRect.left;
                }
                if (distanceX > 0.0f && ((CropImageView)CropImageView.this).mImgRect.right - distanceX < ((CropImageView)CropImageView.this).mCropRect.right) {
                    distanceX = ((CropImageView)CropImageView.this).mImgRect.right - ((CropImageView)CropImageView.this).mCropRect.right;
                }
                CropImageView.this.mAnimMatrix.postTranslate(-distanceX, 0.0f);
                CropImageView.this.mTranslateX = (int)((float)CropImageView.this.mTranslateX - distanceX);
            } else if (CropImageView.this.imgLargeWidth || CropImageView.this.hasMultiTouch || CropImageView.this.hasOverTranslate || !CropImageView.this.isBounceEnable) {
                CropImageView.this.checkRect();
                if (!CropImageView.this.hasMultiTouch || !CropImageView.this.isBounceEnable) {
                    if (distanceX < 0.0f && ((CropImageView)CropImageView.this).mImgRect.left - distanceX > ((CropImageView)CropImageView.this).mCommonRect.left) {
                        distanceX = CropImageView.this.resistanceScrollByX(((CropImageView)CropImageView.this).mImgRect.left - ((CropImageView)CropImageView.this).mCommonRect.left, distanceX);
                    }
                    if (distanceX > 0.0f && ((CropImageView)CropImageView.this).mImgRect.right - distanceX < ((CropImageView)CropImageView.this).mCommonRect.right) {
                        distanceX = CropImageView.this.resistanceScrollByX(((CropImageView)CropImageView.this).mImgRect.right - ((CropImageView)CropImageView.this).mCommonRect.right, distanceX);
                    }
                }
                CropImageView.this.mTranslateX = (int)((float)CropImageView.this.mTranslateX - distanceX);
                CropImageView.this.mAnimMatrix.postTranslate(-distanceX, 0.0f);
                CropImageView.this.hasOverTranslate = true;
            }
            if (CropImageView.this.canScrollVerticallySelf(distanceY)) {
                if (distanceY < 0.0f && ((CropImageView)CropImageView.this).mImgRect.top - distanceY > ((CropImageView)CropImageView.this).mCropRect.top) {
                    distanceY = ((CropImageView)CropImageView.this).mImgRect.top;
                }
                if (distanceY > 0.0f && ((CropImageView)CropImageView.this).mImgRect.bottom - distanceY < ((CropImageView)CropImageView.this).mCropRect.bottom) {
                    distanceY = ((CropImageView)CropImageView.this).mImgRect.bottom - ((CropImageView)CropImageView.this).mCropRect.bottom;
                }
                CropImageView.this.mAnimMatrix.postTranslate(0.0f, -distanceY);
                CropImageView.this.mTranslateY = (int)((float)CropImageView.this.mTranslateY - distanceY);
            } else if (CropImageView.this.imgLargeHeight || CropImageView.this.hasOverTranslate || CropImageView.this.hasMultiTouch || !CropImageView.this.isBounceEnable) {
                CropImageView.this.checkRect();
                if (!CropImageView.this.hasMultiTouch || !CropImageView.this.isBounceEnable) {
                    if (distanceY < 0.0f && ((CropImageView)CropImageView.this).mImgRect.top - distanceY > ((CropImageView)CropImageView.this).mCommonRect.top) {
                        distanceY = CropImageView.this.resistanceScrollByY(((CropImageView)CropImageView.this).mImgRect.top - ((CropImageView)CropImageView.this).mCommonRect.top, distanceY);
                    }
                    if (distanceY > 0.0f && ((CropImageView)CropImageView.this).mImgRect.bottom - distanceY < ((CropImageView)CropImageView.this).mCommonRect.bottom) {
                        distanceY = CropImageView.this.resistanceScrollByY(((CropImageView)CropImageView.this).mImgRect.bottom - ((CropImageView)CropImageView.this).mCommonRect.bottom, distanceY);
                    }
                }
                CropImageView.this.mAnimMatrix.postTranslate(0.0f, -distanceY);
                CropImageView.this.mTranslateY = (int)((float)CropImageView.this.mTranslateY - distanceY);
                CropImageView.this.hasOverTranslate = true;
            }
            CropImageView.this.executeTranslate();
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            CropImageView.this.postDelayed(CropImageView.this.mClickRunnable, 250L);
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            float to;
            float from;
            CropImageView.this.mTranslate.stop();
            float imageCenterX = ((CropImageView)CropImageView.this).mImgRect.left + CropImageView.this.mImgRect.width() / 2.0f;
            float imageCenterY = ((CropImageView)CropImageView.this).mImgRect.top + CropImageView.this.mImgRect.height() / 2.0f;
            CropImageView.this.mScaleCenter.set(imageCenterX, imageCenterY);
            CropImageView.this.mRotateCenter.set(imageCenterX, imageCenterY);
            CropImageView.this.mTranslateX = 0;
            CropImageView.this.mTranslateY = 0;
            if (CropImageView.this.mScale > 1.0f) {
                from = CropImageView.this.mScale;
                to = 1.0f;
            } else {
                from = CropImageView.this.mScale;
                to = CropImageView.this.mMaxScale;
                CropImageView.this.mScaleCenter.set(e.getX(), e.getY());
            }
            CropImageView.this.mTmpMatrix.reset();
            CropImageView.this.mTmpMatrix.postTranslate(-((CropImageView)CropImageView.this).mBaseRect.left, -((CropImageView)CropImageView.this).mBaseRect.top);
            CropImageView.this.mTmpMatrix.postTranslate(((CropImageView)CropImageView.this).mRotateCenter.x, ((CropImageView)CropImageView.this).mRotateCenter.y);
            CropImageView.this.mTmpMatrix.postTranslate(-CropImageView.this.mBaseRect.width() / 2.0f, -CropImageView.this.mBaseRect.height() / 2.0f);
            CropImageView.this.mTmpMatrix.postRotate(CropImageView.this.mDegrees, ((CropImageView)CropImageView.this).mRotateCenter.x, ((CropImageView)CropImageView.this).mRotateCenter.y);
            CropImageView.this.mTmpMatrix.postScale(to, to, ((CropImageView)CropImageView.this).mScaleCenter.x, ((CropImageView)CropImageView.this).mScaleCenter.y);
            CropImageView.this.mTmpMatrix.postTranslate((float)CropImageView.this.mTranslateX, (float)CropImageView.this.mTranslateY);
            CropImageView.this.mTmpMatrix.mapRect(CropImageView.this.mTmpRect, CropImageView.this.mBaseRect);
            CropImageView.this.doTranslateReset(CropImageView.this.mTmpRect);
            CropImageView.this.isZoomUp = !CropImageView.this.isZoomUp;
            CropImageView.this.mTranslate.withScale(from, to);
            CropImageView.this.mTranslate.start();
            return false;
        }
    };
    private ValueAnimator cropAnim;

    public CropImageView(Context context) {
        super(context);
        this.init();
    }

    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        super.setScaleType(ImageView.ScaleType.MATRIX);
        if (this.mScaleType == null) {
            this.mScaleType = ImageView.ScaleType.CENTER_CROP;
        }
        this.mRotateDetector = new RotateGestureDetector(this.mRotateListener);
        this.mDetector = new GestureDetector(this.getContext(), this.mGestureListener);
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), this.mScaleListener);
        float density = this.getResources().getDisplayMetrics().density;
        this.MAX_FLING_OVER_SCROLL = (int)(density * 30.0f);
        this.MAX_OVER_RESISTANCE = (int)(density * 140.0f);
        this.mMinRotate = 35;
        this.mAnimDuring = 340;
        this.mMaxScale = 2.5f;
        this.initCropLineRect();
        this.initCropRect();
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
        this.mClickListener = l;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == ImageView.ScaleType.MATRIX) {
            return;
        }
        if (scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.initBase();
        }
    }

    public ImageView.ScaleType getNewScaleType() {
        return this.mScaleType;
    }

    public void setOnLongClickListener(View.OnLongClickListener l) {
        this.mLongClick = l;
    }

    public void setMaxScale(float maxScale) {
        this.mMaxScale = maxScale;
    }

    public void enable() {
        this.isEnable = true;
    }

    public void setImageResource(int resId) {
        Drawable drawable2 = null;
        try {
            drawable2 = this.getResources().getDrawable(resId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setImageDrawable(drawable2);
    }

    public Bitmap getOriginalBitmap() {
        return this.originalBitmap;
    }

    public void setImageBitmap(Bitmap bm) {
        if (bm == null || bm.getWidth() == 0 || bm.getHeight() == 0) {
            return;
        }
        this.originalBitmap = bm;
        if (loadMaxSize == 0) {
            loadMaxSize = Math.max(bm.getWidth(), bm.getHeight());
        }
        float ratio = (float)bm.getWidth() * 1.0f / (float)bm.getHeight() * 1.0f;
        if (bm.getWidth() > loadMaxSize) {
            bm = Bitmap.createScaledBitmap((Bitmap)bm, (int)loadMaxSize, (int)((int)((float)loadMaxSize / ratio)), (boolean)false);
        }
        if (bm.getHeight() > loadMaxSize) {
            bm = Bitmap.createScaledBitmap((Bitmap)bm, (int)((int)((float)loadMaxSize * ratio)), (int)loadMaxSize, (boolean)false);
        }
        super.setImageBitmap(bm);
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (drawable2 == null) {
            this.hasDrawable = false;
            return;
        }
        if (!this.hasSize(drawable2)) {
            return;
        }
        this.hasDrawable = true;
        if (this.originalBitmap == null) {
            AnimationDrawable drawable1;
            Drawable drawable22;
            if (drawable2 instanceof BitmapDrawable) {
                this.originalBitmap = ((BitmapDrawable)drawable2).getBitmap();
            } else if (drawable2 instanceof AnimationDrawable && (drawable22 = (drawable1 = (AnimationDrawable)drawable2).getFrame(0)) instanceof BitmapDrawable) {
                this.originalBitmap = ((BitmapDrawable)drawable22).getBitmap();
            }
        }
        if (this.onImageLoadListener != null) {
            this.onImageLoadListener.onImageLoaded(drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            this.onImageLoadListener = null;
        }
        if (this.restoreInfo != null) {
            this.mScaleType = this.restoreInfo.getScaleType();
            this.mCropRect = this.restoreInfo.mWidgetRect;
            this.aspectX = (int)this.restoreInfo.mCropX;
            this.aspectY = (int)this.restoreInfo.mCropY;
            this.initBase();
            this.post(new Runnable(){

                @Override
                public void run() {
                    CropImageView.this.restoreCrop();
                }
            });
        } else {
            this.initBase();
        }
    }

    public void setRestoreInfo(Info restoreInfo) {
        this.restoreInfo = restoreInfo;
    }

    private void restoreCrop() {
        Info info = this.restoreInfo;
        this.mTranslateX = 0;
        this.mTranslateY = 0;
        if (info == null || info.mImgRect == null) {
            return;
        }
        float tcx = info.mImgRect.left + info.mImgRect.width() / 2.0f;
        float tcy = info.mImgRect.top + info.mImgRect.height() / 2.0f;
        this.mScaleCenter.set(this.mImgRect.left + this.mImgRect.width() / 2.0f, this.mImgRect.top + this.mImgRect.height() / 2.0f);
        this.mRotateCenter.set(this.mScaleCenter);
        this.mAnimMatrix.postRotate(-this.mDegrees, this.mScaleCenter.x, this.mScaleCenter.y);
        this.mAnimMatrix.mapRect(this.mImgRect, this.mBaseRect);
        float scaleX = info.mImgRect.width() / this.mBaseRect.width();
        float scaleY = info.mImgRect.height() / this.mBaseRect.height();
        float scale = scaleX > scaleY ? scaleX : scaleY;
        this.mAnimMatrix.postRotate(this.mDegrees, this.mScaleCenter.x, this.mScaleCenter.y);
        this.mAnimMatrix.mapRect(this.mImgRect, this.mBaseRect);
        this.mDegrees %= 360.0f;
        this.mTranslate.withTranslate(0, 0, (int)(tcx - this.mScaleCenter.x), (int)(tcy - this.mScaleCenter.y));
        this.mTranslate.withScale(this.mScale, scale);
        this.mTranslate.withRotate((int)this.mDegrees, (int)info.mDegrees, this.mAnimDuring * 2 / 3);
        this.mTranslate.start();
        this.restoreInfo = null;
    }

    public void setOnImageLoadListener(onImageLoadListener onImageLoadListener2) {
        this.onImageLoadListener = onImageLoadListener2;
    }

    private boolean hasSize(Drawable d) {
        return d.getIntrinsicHeight() > 0 && d.getIntrinsicWidth() > 0 || d.getMinimumWidth() > 0 && d.getMinimumHeight() > 0 || d.getBounds().width() > 0 && d.getBounds().height() > 0;
    }

    private static int getDrawableWidth(Drawable d) {
        int width = d.getIntrinsicWidth();
        if (width <= 0) {
            width = d.getMinimumWidth();
        }
        if (width <= 0) {
            width = d.getBounds().width();
        }
        return width;
    }

    private static int getDrawableHeight(Drawable d) {
        int height = d.getIntrinsicHeight();
        if (height <= 0) {
            height = d.getMinimumHeight();
        }
        if (height <= 0) {
            height = d.getBounds().height();
        }
        return height;
    }

    public void initBase() {
        if (!this.hasDrawable) {
            return;
        }
        if (!this.isKnowSize) {
            return;
        }
        this.mBaseMatrix.reset();
        this.mAnimMatrix.reset();
        this.isZoomUp = false;
        Drawable img = this.getDrawable();
        int w = this.getWidth();
        int h = this.getHeight();
        int drawableWidth = CropImageView.getDrawableWidth(img);
        int drawableHeight = CropImageView.getDrawableHeight(img);
        this.mBaseRect.set(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
        int tx = (w - drawableWidth) / 2;
        int ty = (h - drawableHeight) / 2;
        float sx = 1.0f;
        float sy = 1.0f;
        if (drawableWidth > w) {
            sx = (float)w / (float)drawableWidth;
        }
        if (drawableHeight > h) {
            sy = (float)h / (float)drawableHeight;
        }
        this.baseScale = Math.min(sx, sy);
        this.mBaseMatrix.reset();
        this.mBaseMatrix.postTranslate((float)tx, (float)ty);
        this.mBaseMatrix.postScale(this.baseScale, this.baseScale, this.mScreenCenter.x, this.mScreenCenter.y);
        this.mBaseMatrix.mapRect(this.mBaseRect);
        this.mScaleCenter.set(this.mScreenCenter);
        this.mRotateCenter.set(this.mScaleCenter);
        this.executeTranslate();
        switch (this.mScaleType) {
            case CENTER: {
                this.initCenter();
                break;
            }
            case CENTER_CROP: {
                this.initCenterCrop();
                break;
            }
            case CENTER_INSIDE: {
                this.initCenterInside();
                break;
            }
            case FIT_CENTER: {
                this.initFitCenter();
                break;
            }
            case FIT_START: {
                this.initFitStart();
                break;
            }
            case FIT_END: {
                this.initFitEnd();
                break;
            }
            case FIT_XY: {
                this.initFitXY();
            }
        }
    }

    private void initCenter() {
        this.mAnimMatrix.postScale(1.0f, 1.0f, this.mScreenCenter.x, this.mScreenCenter.y);
        this.executeTranslate();
        this.resetBase();
    }

    private void initCenterCrop() {
        float widthScale = this.mCropRect.width() / this.mImgRect.width();
        float heightScale = this.mCropRect.height() / this.mImgRect.height();
        this.mScale = Math.max(widthScale, heightScale);
        this.mAnimMatrix.postScale(this.mScale, this.mScale, this.mScreenCenter.x, this.mScreenCenter.y);
        this.executeTranslate();
        this.resetBase();
    }

    private void initCenterInside() {
        if (this.mCropRect.width() > this.mImgRect.width()) {
            this.initCenter();
        } else {
            this.initFitCenter();
        }
        float widthScale = this.mCropRect.width() / this.mImgRect.width();
        if (widthScale > this.mMaxScale) {
            this.mMaxScale = widthScale;
        }
    }

    private void initFitCenter() {
        float widthScale = this.mCropRect.width() / this.mImgRect.width();
        float heightScale = this.mCropRect.height() / this.mImgRect.height();
        this.mScale = Math.min(widthScale, heightScale);
        this.mAnimMatrix.postScale(this.mScale, this.mScale, this.mScreenCenter.x, this.mScreenCenter.y);
        this.executeTranslate();
        this.resetBase();
        if (widthScale > this.mMaxScale) {
            this.mMaxScale = widthScale;
        }
    }

    private void initFitStart() {
        this.initFitCenter();
        float ty = -this.mImgRect.top;
        this.mAnimMatrix.postTranslate(0.0f, ty);
        this.executeTranslate();
        this.resetBase();
        this.mTranslateY = (int)((float)this.mTranslateY + ty);
    }

    private void initFitEnd() {
        this.initFitCenter();
        float ty = this.mCropRect.bottom - this.mImgRect.bottom;
        this.mTranslateY = (int)((float)this.mTranslateY + ty);
        this.mAnimMatrix.postTranslate(0.0f, ty);
        this.executeTranslate();
        this.resetBase();
    }

    private void initFitXY() {
        float widthScale = this.mCropRect.width() / this.mImgRect.width();
        float heightScale = this.mCropRect.height() / this.mImgRect.height();
        this.mAnimMatrix.postScale(widthScale, heightScale, this.mScreenCenter.x, this.mScreenCenter.y);
        this.executeTranslate();
        this.resetBase();
    }

    private void resetBase() {
        Drawable img = this.getDrawable();
        this.mBaseRect.set(0.0f, 0.0f, (float)CropImageView.getDrawableWidth(img), (float)CropImageView.getDrawableHeight(img));
        this.mBaseMatrix.set(this.mSynthesisMatrix);
        this.mBaseMatrix.mapRect(this.mBaseRect);
        this.mScale = 1.0f;
        this.mTranslateX = 0;
        this.mTranslateY = 0;
        this.mAnimMatrix.reset();
    }

    private void executeTranslate() {
        this.mSynthesisMatrix.set(this.mBaseMatrix);
        this.mSynthesisMatrix.postConcat(this.mAnimMatrix);
        this.setImageMatrix(this.mSynthesisMatrix);
        this.mAnimMatrix.mapRect(this.mImgRect, this.mBaseRect);
        this.imgLargeWidth = this.mImgRect.width() >= this.mCropRect.width();
        this.imgLargeHeight = this.mImgRect.height() >= this.mCropRect.height();
    }

    public void setCropRatio(int aspectX, int aspectY) {
        this.aspectX = aspectX;
        this.aspectY = aspectY;
        if (this.cropAnim != null && this.cropAnim.isRunning()) {
            this.cropAnim.cancel();
        }
        if (aspectX <= 0 || aspectY <= 0) {
            this.mCropRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mScaleType = ImageView.ScaleType.CENTER_INSIDE;
            this.initBase();
            this.invalidate();
            return;
        }
        this.mScaleType = ImageView.ScaleType.CENTER_CROP;
        this.resetCropSize(this.getWidth(), this.getHeight());
    }

    public boolean isEditing() {
        return this.isShowLine;
    }

    public void setCropMargin(int cropMargin) {
        this.cropMargin = cropMargin;
    }

    public int getCropWidth() {
        return (int)this.mCropRect.width();
    }

    public int getCropHeight() {
        return (int)this.mCropRect.height();
    }

    private void resetCropSize(int w, int h) {
        float left = 0.0f;
        float top = 0.0f;
        float right = w;
        float bottom = h;
        if (this.aspectY != -1 && this.aspectX != -1) {
            float cropRatio = (float)this.aspectX * 1.0f / (float)this.aspectY;
            float viewRatio = (float)w * 1.0f / (float)h;
            if (h > w) {
                float top1 = ((float)h - (float)(w - this.cropMargin * 2) * 1.0f / cropRatio) * 1.0f / 2.0f;
                if (cropRatio >= 1.0f) {
                    left = this.cropMargin;
                    right = (float)w - left;
                    top = top1;
                    bottom = (float)h - top;
                } else if (cropRatio < 1.0f) {
                    if (cropRatio > viewRatio) {
                        left = this.cropMargin;
                        right = (float)w - left;
                        top = top1;
                        bottom = (float)h - top;
                    } else {
                        top = this.cropMargin;
                        bottom = (float)h - top;
                        left = ((float)w - (float)(h - this.cropMargin * 2) * cropRatio) / 2.0f;
                        right = (float)w - left;
                    }
                }
            }
            this.anim(left, top, right, bottom);
        } else {
            this.mCropRect.set(left, top, right, bottom);
            this.initBase();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.isKnowSize = true;
        this.mScreenCenter.set((float)w / 2.0f, (float)h / 2.0f);
        this.resetCropSize(w, h);
        this.setImageDrawable(this.getDrawable());
    }

    public void setRotateEnable(boolean rotateEnable) {
        this.isRotateEnable = rotateEnable;
    }

    private void initCropRect() {
        this.cropRectPaint = new Paint();
        this.cropRectPaint.setStrokeWidth((float)this.dp(2.0f));
        this.cropRectPaint.setColor(-1);
        this.cropRectPaint.setAntiAlias(true);
        this.cropRectPaint.setStyle(Paint.Style.STROKE);
        this.cropRectPaint.setDither(true);
        this.initMaskPaint();
    }

    private void initCropLineRect() {
        this.linePaint = new Paint();
        this.linePaint.setColor(-1);
        this.linePaint.setAntiAlias(true);
        this.linePaint.setStrokeWidth((float)this.dp(0.5f));
        this.linePaint.setStyle(Paint.Style.FILL);
        this.cropStrokePaint = new Paint();
        this.cropStrokePaint.setColor(-1);
        this.cropStrokePaint.setAntiAlias(true);
        this.cropStrokePaint.setStrokeCap(Paint.Cap.ROUND);
        this.cropStrokePaint.setStrokeWidth((float)this.dp(4.0f));
        this.cropStrokePaint.setStyle(Paint.Style.STROKE);
    }

    private void initMaskPaint() {
        this.maskPaint = new Paint();
        this.maskPaint.setColor(Color.parseColor((String)"#a0000000"));
        this.maskPaint.setAntiAlias(true);
        this.maskPaint.setStyle(Paint.Style.FILL);
    }

    private void drawStrokeLine(Canvas canvas) {
        int lineWidth = this.dp(30.0f);
        float x = this.mCropRect.left;
        float y = this.mCropRect.top + (float)this.dp(1.0f);
        float w = this.mCropRect.width();
        float h = this.mCropRect.height() - (float)this.dp(2.0f);
        canvas.drawLine(x, y, (float)lineWidth + x, y, this.cropStrokePaint);
        canvas.drawLine(x, y, x, y + (float)lineWidth, this.cropStrokePaint);
        canvas.drawLine(x, y + h, x, y + h - (float)lineWidth, this.cropStrokePaint);
        canvas.drawLine(x, y + h, x + (float)lineWidth, y + h, this.cropStrokePaint);
        canvas.drawLine(x + w, y, x + w - (float)lineWidth, y, this.cropStrokePaint);
        canvas.drawLine(x + w, y, x + w, y + (float)lineWidth, this.cropStrokePaint);
        canvas.drawLine(x + w, y + h, x + w - (float)lineWidth, y + h, this.cropStrokePaint);
        canvas.drawLine(x + w, y + h, x + w, y + h - (float)lineWidth, this.cropStrokePaint);
    }

    public void setCircle(boolean circle) {
        this.isCircle = circle;
        this.invalidate();
    }

    public void setShowImageRectLine(boolean showImageRectLine) {
        this.isShowImageRectLine = showImageRectLine;
        this.invalidate();
    }

    public void setCanShowTouchLine(boolean canShowTouchLine) {
        this.canShowTouchLine = canShowTouchLine;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        try {
            super.onDraw(canvas);
        }
        catch (Exception ignored) {
            loadMaxSize = (int)((double)loadMaxSize * 0.8);
            this.setImageBitmap(this.originalBitmap);
            return;
        }
        if (this.isShowLine && this.canShowTouchLine && !this.isCircle) {
            int h;
            int w;
            int top;
            int left;
            if (this.isShowImageRectLine) {
                left = this.mImgRect.left > this.mCropRect.left ? (int)this.mImgRect.left : (int)this.mCropRect.left;
                top = (float)((int)this.mImgRect.top) > this.mCropRect.top ? (int)this.mImgRect.top : (int)this.mCropRect.top;
                int right = this.mImgRect.right < this.mCropRect.right ? (int)this.mImgRect.right : (int)this.mCropRect.right;
                int bottom = this.mImgRect.bottom < this.mCropRect.bottom ? (int)this.mImgRect.bottom : (int)this.mCropRect.bottom;
                w = right - left;
                h = bottom - top;
            } else {
                w = (int)this.mCropRect.width();
                h = (int)this.mCropRect.height();
                left = (int)this.mCropRect.left;
                top = (int)this.mCropRect.top;
            }
            canvas.drawLine((float)left + (float)w / 3.0f, (float)top, (float)left + (float)w / 3.0f, (float)(h + top), this.linePaint);
            canvas.drawLine((float)left + (float)(w * 2) / 3.0f, (float)top, (float)left + (float)(w * 2) / 3.0f, (float)(h + top), this.linePaint);
            canvas.drawLine((float)left, (float)top + (float)h / 3.0f, (float)(left + w), (float)top + (float)h / 3.0f, this.linePaint);
            canvas.drawLine((float)left, (float)top + (float)(h * 2) / 3.0f, (float)(left + w), (float)top + (float)(h * 2) / 3.0f, this.linePaint);
        }
        if (!this.isShowCropRect || this.aspectY <= 0 || this.aspectX <= 0) {
            return;
        }
        this.getDrawingRect(this.viewDrawingRect);
        this.path.reset();
        if (this.isCircle) {
            this.path.addCircle(this.mCropRect.left + this.mCropRect.width() / 2.0f, this.mCropRect.top + this.mCropRect.height() / 2.0f, this.mCropRect.width() / 2.0f, Path.Direction.CW);
        } else {
            this.drawStrokeLine(canvas);
            this.path.addRect(this.mCropRect.left, this.mCropRect.top, this.mCropRect.right, this.mCropRect.bottom, Path.Direction.CW);
        }
        canvas.clipPath(this.path, Region.Op.DIFFERENCE);
        canvas.drawRect(this.viewDrawingRect, this.maskPaint);
        canvas.drawPath(this.path, this.cropRectPaint);
    }

    public void draw(Canvas canvas) {
        if (this.mClip != null) {
            canvas.clipRect(this.mClip);
            this.mClip = null;
        }
        super.draw(canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.isEnable) {
            int Action = event.getActionMasked();
            if (event.getPointerCount() >= 2) {
                this.hasMultiTouch = true;
            }
            this.mDetector.onTouchEvent(event);
            if (this.isRotateEnable) {
                this.mRotateDetector.onTouchEvent(event);
            }
            this.mScaleDetector.onTouchEvent(event);
            if (Action == 0) {
                this.isShowLine = true;
                this.invalidate();
            } else if (Action == 1 || Action == 3) {
                this.onUp();
                this.isShowLine = false;
                this.invalidate();
            }
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    private void onUp() {
        if (this.mTranslate.isRunning) {
            return;
        }
        if (this.canRotate || this.mDegrees % 90.0f != 0.0f) {
            float toDegrees = (int)(this.mDegrees / 90.0f) * 90;
            float remainder = this.mDegrees % 90.0f;
            if (remainder > 45.0f) {
                toDegrees += 90.0f;
            } else if (remainder < -45.0f) {
                toDegrees -= 90.0f;
            }
            this.mTranslate.withRotate((int)this.mDegrees, (int)toDegrees);
            this.mDegrees = toDegrees;
        }
        if (!this.isBounceEnable) {
            return;
        }
        float cx = this.mImgRect.left * 1.0f + this.mImgRect.width() / 2.0f;
        float cy = this.mImgRect.top * 1.0f + this.mImgRect.height() / 2.0f;
        this.mRotateCenter.set(cx, cy);
        if (this.mScale < 1.0f) {
            this.mTranslate.withScale(this.mScale, 1.0f);
            this.mScale = 1.0f;
        } else if (this.mScale > this.mMaxScale) {
            this.mTranslate.withScale(this.mScale, this.mMaxScale);
            this.mScale = this.mMaxScale;
        }
        this.mScaleCenter.set(cx, cy);
        this.mTranslateX = 0;
        this.mTranslateY = 0;
        this.mTmpMatrix.reset();
        this.mTmpMatrix.postTranslate(-this.mBaseRect.left, -this.mBaseRect.top);
        this.mTmpMatrix.postTranslate(cx - this.mBaseRect.width() / 2.0f, cy - this.mBaseRect.height() / 2.0f);
        this.mTmpMatrix.postScale(this.mScale, this.mScale, this.mScaleCenter.x, this.mScaleCenter.y);
        this.mTmpMatrix.postRotate(this.mDegrees, cx, cy);
        this.mTmpMatrix.mapRect(this.mTmpRect, this.mBaseRect);
        this.doTranslateReset(this.mTmpRect);
        this.mTranslate.start();
    }

    public void setBounceEnable(boolean isBounceEnable) {
        this.isBounceEnable = isBounceEnable;
    }

    private void doTranslateReset(RectF imgRect) {
        int tx = 0;
        int ty = 0;
        int width = (int)this.mCropRect.width();
        int height = (int)this.mCropRect.height();
        if (imgRect.width() <= (float)width) {
            if (!this.isImageCenterWidth(imgRect)) {
                tx = this.aspectX > 0 && this.aspectY > 0 ? (int)(imgRect.left - this.mCropRect.left) : -((int)((this.mCropRect.width() - imgRect.width()) / 2.0f - imgRect.left));
            }
        } else if (imgRect.left > this.mCropRect.left) {
            tx = (int)(imgRect.left - this.mCropRect.left);
        } else if (imgRect.right < this.mCropRect.right) {
            tx = (int)(imgRect.right - this.mCropRect.right);
        }
        if (imgRect.height() <= (float)height) {
            if (!this.isImageCenterHeight(imgRect)) {
                ty = this.aspectX > 0 && this.aspectY > 0 ? (int)(imgRect.top - this.mCropRect.top) : -((int)((this.mCropRect.height() - imgRect.height()) / 2.0f - imgRect.top));
            }
        } else if (imgRect.top > this.mCropRect.top) {
            ty = (int)(imgRect.top - this.mCropRect.top);
        } else if (imgRect.bottom < this.mCropRect.bottom) {
            ty = (int)(imgRect.bottom - this.mCropRect.bottom);
        }
        if (tx != 0 || ty != 0) {
            if (!this.mTranslate.mFlingScroller.isFinished()) {
                this.mTranslate.mFlingScroller.abortAnimation();
            }
            this.mTranslate.withTranslate(this.mTranslateX, this.mTranslateY, -tx, -ty);
        }
    }

    private boolean isImageCenterHeight(RectF rect) {
        return Math.abs((float)Math.round(rect.top) - (this.mCropRect.height() - rect.height()) / 2.0f) < 1.0f;
    }

    private boolean isImageCenterWidth(RectF rect) {
        return Math.abs((float)Math.round(rect.left) - (this.mCropRect.width() - rect.width()) / 2.0f) < 1.0f;
    }

    private float resistanceScrollByX(float overScroll, float detalX) {
        return detalX * (Math.abs(Math.abs(overScroll) - (float)this.MAX_OVER_RESISTANCE) / (float)this.MAX_OVER_RESISTANCE);
    }

    private float resistanceScrollByY(float overScroll, float detalY) {
        return detalY * (Math.abs(Math.abs(overScroll) - (float)this.MAX_OVER_RESISTANCE) / (float)this.MAX_OVER_RESISTANCE);
    }

    private void mapRect(RectF r1, RectF r2, RectF out) {
        float b;
        float r;
        float l = r1.left > r2.left ? r1.left : r2.left;
        float f = r = r1.right < r2.right ? r1.right : r2.right;
        if (l > r) {
            out.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        float t = r1.top > r2.top ? r1.top : r2.top;
        float f2 = b = r1.bottom < r2.bottom ? r1.bottom : r2.bottom;
        if (t > b) {
            out.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        out.set(l, t, r, b);
    }

    private void checkRect() {
        if (!this.hasOverTranslate) {
            this.mapRect(this.mCropRect, this.mImgRect, this.mCommonRect);
        }
    }

    public boolean canScrollHorizontallySelf(float direction) {
        if (this.mImgRect.width() <= this.mCropRect.width()) {
            return false;
        }
        if (direction < 0.0f && (float)Math.round(this.mImgRect.left) - direction >= this.mCropRect.left) {
            return false;
        }
        return !(direction > 0.0f) || !((float)Math.round(this.mImgRect.right) - direction <= this.mCropRect.right);
    }

    public boolean canScrollVerticallySelf(float direction) {
        if (this.mImgRect.height() <= this.mCropRect.height()) {
            return false;
        }
        if (direction < 0.0f && (float)Math.round(this.mImgRect.top) - direction >= this.mCropRect.top) {
            return false;
        }
        return !(direction > 0.0f) || !((float)Math.round(this.mImgRect.bottom) - direction <= this.mCropRect.bottom);
    }

    public boolean canScrollHorizontally(int direction) {
        if (!this.isEnable) {
            return super.canScrollHorizontally(direction);
        }
        if (this.hasMultiTouch) {
            return true;
        }
        return this.canScrollHorizontallySelf(direction);
    }

    public boolean canScrollVertically(int direction) {
        if (!this.isEnable) {
            return super.canScrollVertically(direction);
        }
        if (this.hasMultiTouch) {
            return true;
        }
        return this.canScrollVerticallySelf(direction);
    }

    public Info getInfo() {
        return new Info(this.mImgRect, this.mCropRect, this.mDegrees, this.mScaleType.name(), this.aspectX, this.aspectY, this.getTranslateX(), this.getTranslateY(), this.getScale());
    }

    public void rotate(float degrees) {
        this.mDegrees += degrees;
        int centerX = (int)(this.mCropRect.left + this.mCropRect.width() / 2.0f);
        int centerY = (int)(this.mCropRect.top + this.mCropRect.height() / 2.0f);
        this.mAnimMatrix.postRotate(degrees, (float)centerX, (float)centerY);
        this.executeTranslate();
    }

    public Bitmap generateCropBitmapFromView(int backgroundColor) {
        this.setShowImageRectLine(false);
        this.isShowCropRect = false;
        this.invalidate();
        Bitmap bitmap = PBitmapUtils.getViewBitmap((View)this);
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)this.mCropRect.left), (int)((int)this.mCropRect.top), (int)((int)this.mCropRect.width()), (int)((int)this.mCropRect.height()));
            if (this.isCircle) {
                bitmap = this.createCircleBitmap(bitmap, backgroundColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    public Bitmap generateCropBitmap() {
        Bitmap bitmap1;
        float endY;
        float endX;
        float endH;
        float endW;
        float cropHeight;
        float cropWidth;
        float cropRatio;
        int bh;
        if (this.originalBitmap == null) {
            return null;
        }
        float x = Math.abs(this.getTranslateX());
        float y = Math.abs(this.getTranslateY());
        float scale = this.mScale;
        int bw = this.originalBitmap.getWidth();
        float bRatio = (float)bw * 1.0f / ((float)(bh = this.originalBitmap.getHeight()) * 1.0f);
        if (bRatio < (cropRatio = (cropWidth = this.mCropRect.width()) * 1.0f / ((cropHeight = this.mCropRect.height()) * 1.0f))) {
            endW = (float)bw / scale;
            endH = endW / cropRatio;
            endX = (float)bw * x / (cropWidth * scale * 1.0f);
            endY = (float)bw * y / (cropWidth * scale * 1.0f);
        } else {
            endH = (float)bh / scale;
            endW = cropRatio * endH;
            endX = (float)bh * x / (cropHeight * scale * 1.0f);
            endY = (float)bh * y / (cropHeight * scale * 1.0f);
        }
        if (endX + endW > (float)bw && (endX = (float)bw - endW) < 0.0f) {
            endX = 0.0f;
        }
        if (endY + endH > (float)bh && (endY = (float)bh - endH) < 0.0f) {
            endY = 0.0f;
        }
        try {
            bitmap1 = Bitmap.createBitmap((Bitmap)this.originalBitmap, (int)((int)endX), (int)((int)endY), (int)((int)endW), (int)((int)endH));
            if (this.isCircle) {
                bitmap1 = this.createCircleBitmap(bitmap1, 0);
            }
        }
        catch (Exception ignored) {
            bitmap1 = this.generateCropBitmapFromView(-16777216);
        }
        return bitmap1;
    }

    private Bitmap createCircleBitmap(Bitmap resource, int backgroundColor) {
        int width = resource.getWidth();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap circleBitmap = Bitmap.createBitmap((int)resource.getWidth(), (int)resource.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(circleBitmap);
        if (backgroundColor != 0) {
            paint.setColor(backgroundColor);
        }
        canvas.drawCircle((float)(width / 2), (float)(width / 2), (float)(width / 2), paint);
        if (backgroundColor == 0) {
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        } else {
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        }
        canvas.drawBitmap(resource, 0.0f, 0.0f, paint);
        return circleBitmap;
    }

    public float getTranslateX() {
        return this.mImgRect.left - this.mCropRect.left;
    }

    public float getTranslateY() {
        return this.mImgRect.top - this.mCropRect.top;
    }

    public float getScale() {
        if (this.mScale <= 1.0f) {
            return 1.0f;
        }
        return this.mScale;
    }

    public int dp(float dp) {
        float density = this.getContext().getResources().getDisplayMetrics().density;
        return (int)((double)(dp * density) + 0.5);
    }

    private void anim(float left, float top, float right, float bottom) {
        final float oldLeft = this.mCropRect.left;
        final float oldTop = this.mCropRect.top;
        final float oldRight = this.mCropRect.right;
        final float oldBottom = this.mCropRect.bottom;
        final float finalLeft = left;
        final float finalTop = top;
        final float finalRight = right;
        final float finalBottom = bottom;
        if (oldRight == 0.0f || oldBottom == 0.0f || oldLeft == left && oldBottom == bottom && oldRight == right && oldTop == top) {
            this.mCropRect.set(finalLeft, finalTop, finalRight, finalBottom);
            this.initBase();
            this.invalidate();
            return;
        }
        if (this.cropAnim == null) {
            this.cropAnim = ObjectAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(400L);
            this.cropAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        }
        this.cropAnim.removeAllUpdateListeners();
        this.cropAnim.removeAllListeners();
        this.cropAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                ((CropImageView)CropImageView.this).mCropRect.left = (finalLeft - oldLeft) * value + oldLeft;
                ((CropImageView)CropImageView.this).mCropRect.top = (finalTop - oldTop) * value + oldTop;
                ((CropImageView)CropImageView.this).mCropRect.right = (finalRight - oldRight) * value + oldRight;
                ((CropImageView)CropImageView.this).mCropRect.bottom = (finalBottom - oldBottom) * value + oldBottom;
                CropImageView.this.isShowLine = value < 1.0f;
                CropImageView.this.initBase();
                CropImageView.this.invalidate();
            }
        });
        this.cropAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CropImageView.this.initBase();
                CropImageView.this.invalidate();
            }
        });
        this.cropAnim.start();
    }

    public void changeSize(boolean isAnim, final int endWidth, final int endHeight) {
        if (isAnim) {
            final int startWidth = this.getWidth();
            final int startHeight = this.getHeight();
            ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(200L);
            anim2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float ratio = ((Float)animation.getAnimatedValue()).floatValue();
                    ViewGroup.LayoutParams params = CropImageView.this.getLayoutParams();
                    params.width = (int)((float)(endWidth - startWidth) * ratio + (float)startWidth);
                    params.height = (int)((float)(endHeight - startHeight) * ratio + (float)startHeight);
                    CropImageView.this.setLayoutParams(params);
                    CropImageView.this.setImageDrawable(CropImageView.this.getDrawable());
                }
            });
            anim2.start();
        } else {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            params.width = endWidth;
            params.height = endHeight;
            this.setLayoutParams(params);
        }
    }

    public static interface ClipCalculate {
        public float calculateTop();
    }

    private class Transform
    implements Runnable {
        boolean isRunning;
        OverScroller mTranslateScroller;
        OverScroller mFlingScroller;
        Scroller mScaleScroller;
        Scroller mClipScroller;
        Scroller mRotateScroller;
        ClipCalculate C;
        int mLastFlingX;
        int mLastFlingY;
        int mLastTranslateX;
        int mLastTranslateY;
        RectF mClipRect = new RectF();
        InterpolatorProxy mInterpolatorProxy = new InterpolatorProxy();

        Transform() {
            Context ctx = CropImageView.this.getContext();
            this.mTranslateScroller = new OverScroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mScaleScroller = new Scroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mFlingScroller = new OverScroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mClipScroller = new Scroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mRotateScroller = new Scroller(ctx, (Interpolator)this.mInterpolatorProxy);
        }

        public void setInterpolator(Interpolator interpolator) {
            this.mInterpolatorProxy.setTargetInterpolator(interpolator);
        }

        void withTranslate(int startX, int startY, int deltaX, int deltaY) {
            this.mLastTranslateX = 0;
            this.mLastTranslateY = 0;
            this.mTranslateScroller.startScroll(startX, startY, deltaX, deltaY, CropImageView.this.mAnimDuring);
        }

        void withScale(float form, float to) {
            this.mScaleScroller.startScroll((int)(form * 10000.0f), 0, (int)((to - form) * 10000.0f), 0, CropImageView.this.mAnimDuring);
        }

        void withRotate(int fromDegrees, int toDegrees) {
            this.mRotateScroller.startScroll(fromDegrees, 0, toDegrees - fromDegrees, 0, CropImageView.this.mAnimDuring);
        }

        void withRotate(int fromDegrees, int toDegrees, int during) {
            this.mRotateScroller.startScroll(fromDegrees, 0, toDegrees - fromDegrees, 0, during);
        }

        void withFling(float velocityX, float velocityY) {
            int overY;
            this.mLastFlingX = velocityX < 0.0f ? Integer.MAX_VALUE : 0;
            int distanceX = (int)(velocityX > 0.0f ? Math.abs(((CropImageView)CropImageView.this).mImgRect.left) : ((CropImageView)CropImageView.this).mImgRect.right - ((CropImageView)CropImageView.this).mCropRect.right);
            distanceX = velocityX < 0.0f ? Integer.MAX_VALUE - distanceX : distanceX;
            int minX = velocityX < 0.0f ? distanceX : 0;
            int maxX = velocityX < 0.0f ? Integer.MAX_VALUE : distanceX;
            int overX = velocityX < 0.0f ? Integer.MAX_VALUE - minX : distanceX;
            this.mLastFlingY = velocityY < 0.0f ? Integer.MAX_VALUE : 0;
            int distanceY = (int)(velocityY > 0.0f ? Math.abs(((CropImageView)CropImageView.this).mImgRect.top - ((CropImageView)CropImageView.this).mCropRect.top) : ((CropImageView)CropImageView.this).mImgRect.bottom - ((CropImageView)CropImageView.this).mCropRect.bottom);
            distanceY = velocityY < 0.0f ? Integer.MAX_VALUE - distanceY : distanceY;
            int minY = velocityY < 0.0f ? distanceY : 0;
            int maxY = velocityY < 0.0f ? Integer.MAX_VALUE : distanceY;
            int n = overY = velocityY < 0.0f ? Integer.MAX_VALUE - minY : distanceY;
            if (velocityX == 0.0f) {
                maxX = 0;
                minX = 0;
            }
            if (velocityY == 0.0f) {
                maxY = 0;
                minY = 0;
            }
            this.mFlingScroller.fling(this.mLastFlingX, this.mLastFlingY, (int)velocityX, (int)velocityY, minX, maxX, minY, maxY, Math.abs(overX) < CropImageView.this.MAX_FLING_OVER_SCROLL * 2 ? 0 : CropImageView.this.MAX_FLING_OVER_SCROLL, Math.abs(overY) < CropImageView.this.MAX_FLING_OVER_SCROLL * 2 ? 0 : CropImageView.this.MAX_FLING_OVER_SCROLL);
        }

        void start() {
            this.isRunning = true;
            this.postExecute();
        }

        void stop() {
            CropImageView.this.removeCallbacks(this);
            this.mTranslateScroller.abortAnimation();
            this.mScaleScroller.abortAnimation();
            this.mFlingScroller.abortAnimation();
            this.mRotateScroller.abortAnimation();
            this.isRunning = false;
        }

        @Override
        public void run() {
            if (!this.isRunning) {
                return;
            }
            boolean endAnim = true;
            if (this.mScaleScroller.computeScrollOffset()) {
                CropImageView.this.mScale = (float)this.mScaleScroller.getCurrX() / 10000.0f;
                endAnim = false;
            }
            if (this.mTranslateScroller.computeScrollOffset()) {
                int tx = this.mTranslateScroller.getCurrX() - this.mLastTranslateX;
                int ty = this.mTranslateScroller.getCurrY() - this.mLastTranslateY;
                CropImageView.this.mTranslateX = CropImageView.this.mTranslateX + tx;
                CropImageView.this.mTranslateY = CropImageView.this.mTranslateY + ty;
                this.mLastTranslateX = this.mTranslateScroller.getCurrX();
                this.mLastTranslateY = this.mTranslateScroller.getCurrY();
                endAnim = false;
            }
            if (this.mFlingScroller.computeScrollOffset()) {
                int x = this.mFlingScroller.getCurrX() - this.mLastFlingX;
                int y = this.mFlingScroller.getCurrY() - this.mLastFlingY;
                this.mLastFlingX = this.mFlingScroller.getCurrX();
                this.mLastFlingY = this.mFlingScroller.getCurrY();
                CropImageView.this.mTranslateX = CropImageView.this.mTranslateX + x;
                CropImageView.this.mTranslateY = CropImageView.this.mTranslateY + y;
                endAnim = false;
            }
            if (this.mRotateScroller.computeScrollOffset()) {
                CropImageView.this.mDegrees = this.mRotateScroller.getCurrX();
                endAnim = false;
            }
            if (this.mClipScroller.computeScrollOffset() || CropImageView.this.mClip != null) {
                float sx = (float)this.mClipScroller.getCurrX() / 10000.0f;
                float sy = (float)this.mClipScroller.getCurrY() / 10000.0f;
                CropImageView.this.mTmpMatrix.setScale(sx, sy, (((CropImageView)CropImageView.this).mImgRect.left + ((CropImageView)CropImageView.this).mImgRect.right) / 2.0f, this.C.calculateTop());
                CropImageView.this.mTmpMatrix.mapRect(this.mClipRect, CropImageView.this.mImgRect);
                if (sx == 1.0f) {
                    this.mClipRect.left = ((CropImageView)CropImageView.this).mCropRect.left;
                    this.mClipRect.right = ((CropImageView)CropImageView.this).mCropRect.right;
                }
                if (sy == 1.0f) {
                    this.mClipRect.top = ((CropImageView)CropImageView.this).mCropRect.top;
                    this.mClipRect.bottom = ((CropImageView)CropImageView.this).mCropRect.bottom;
                }
                CropImageView.this.mClip = this.mClipRect;
            }
            if (!endAnim) {
                this.applyAnim();
                this.postExecute();
            } else {
                this.isRunning = false;
                if (CropImageView.this.aspectX > 0 && CropImageView.this.aspectY > 0) {
                    return;
                }
                boolean needFix = false;
                if (CropImageView.this.imgLargeWidth) {
                    if (((CropImageView)CropImageView.this).mImgRect.left > 0.0f) {
                        CropImageView.this.mTranslateX = (int)((float)CropImageView.this.mTranslateX - ((CropImageView)CropImageView.this).mCropRect.left);
                    } else if (((CropImageView)CropImageView.this).mImgRect.right < CropImageView.this.mCropRect.width()) {
                        CropImageView.this.mTranslateX = CropImageView.this.mTranslateX - (int)(CropImageView.this.mCropRect.width() - ((CropImageView)CropImageView.this).mImgRect.right);
                    }
                    needFix = true;
                }
                if (CropImageView.this.imgLargeHeight) {
                    if (((CropImageView)CropImageView.this).mImgRect.top > 0.0f) {
                        CropImageView.this.mTranslateY = (int)((float)CropImageView.this.mTranslateY - ((CropImageView)CropImageView.this).mCropRect.top);
                    } else if (((CropImageView)CropImageView.this).mImgRect.bottom < CropImageView.this.mCropRect.height()) {
                        CropImageView.this.mTranslateY = CropImageView.this.mTranslateY - (int)(CropImageView.this.mCropRect.height() - ((CropImageView)CropImageView.this).mImgRect.bottom);
                    }
                    needFix = true;
                }
                if (needFix) {
                    this.applyAnim();
                }
                CropImageView.this.invalidate();
            }
            if (CropImageView.this.mCompleteCallBack != null) {
                CropImageView.this.mCompleteCallBack.run();
                CropImageView.this.mCompleteCallBack = null;
            }
        }

        private void applyAnim() {
            CropImageView.this.mAnimMatrix.reset();
            CropImageView.this.mAnimMatrix.postTranslate(-((CropImageView)CropImageView.this).mBaseRect.left, -((CropImageView)CropImageView.this).mBaseRect.top);
            CropImageView.this.mAnimMatrix.postTranslate(((CropImageView)CropImageView.this).mRotateCenter.x, ((CropImageView)CropImageView.this).mRotateCenter.y);
            CropImageView.this.mAnimMatrix.postTranslate(-CropImageView.this.mBaseRect.width() / 2.0f, -CropImageView.this.mBaseRect.height() / 2.0f);
            CropImageView.this.mAnimMatrix.postRotate(CropImageView.this.mDegrees, ((CropImageView)CropImageView.this).mRotateCenter.x, ((CropImageView)CropImageView.this).mRotateCenter.y);
            CropImageView.this.mAnimMatrix.postScale(CropImageView.this.mScale, CropImageView.this.mScale, ((CropImageView)CropImageView.this).mScaleCenter.x, ((CropImageView)CropImageView.this).mScaleCenter.y);
            CropImageView.this.mAnimMatrix.postTranslate((float)CropImageView.this.mTranslateX, (float)CropImageView.this.mTranslateY);
            CropImageView.this.executeTranslate();
        }

        private void postExecute() {
            if (this.isRunning) {
                CropImageView.this.post(this);
            }
        }
    }

    private class InterpolatorProxy
    implements Interpolator {
        private Interpolator mTarget = new DecelerateInterpolator();

        private InterpolatorProxy() {
        }

        void setTargetInterpolator(Interpolator interpolator) {
            this.mTarget = interpolator;
        }

        public float getInterpolation(float input) {
            if (this.mTarget != null) {
                return this.mTarget.getInterpolation(input);
            }
            return input;
        }
    }

    public static interface onImageLoadListener {
        public void onImageLoaded(float var1, float var2);
    }
}

