/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

public class TouchRecyclerView
extends RecyclerView {
    float firstY = 0.0f;
    float lastY = 0.0f;
    private View touchView;
    private onDragScrollListener dragScrollListener;

    public TouchRecyclerView(@NonNull Context context) {
        super(context);
    }

    public TouchRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public TouchRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.lastY = ev.getY();
                break;
            }
            case 2: {
                float y = ev.getY();
                if (y < this.lastY) {
                    if (!this.isTouchPointInView(this.touchView, ev.getX(), ev.getY()) || this.dragScrollListener == null) break;
                    int distance = (int)(y - this.lastY);
                    int defaultDis = (int)(this.lastY - (float)this.getPaddingTop());
                    this.dragScrollListener.onScrollOverTop(Math.abs(distance + defaultDis));
                    break;
                }
                if (this.dragScrollListener == null) break;
                this.dragScrollListener.onScrollDown((int)(y - this.lastY));
                break;
            }
            case 1: 
            case 3: {
                this.lastY = 0.0f;
                if (this.dragScrollListener == null) break;
                this.dragScrollListener.onScrollUp();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setTouchView(View view) {
        this.touchView = view;
    }

    private boolean isTouchPointInView(View view, float x, float y) {
        if (view == null) {
            return false;
        }
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return y >= (float)top && y <= (float)bottom && x >= (float)left && x <= (float)right;
    }

    public void setDragScrollListener(onDragScrollListener dragScrollListener) {
        this.dragScrollListener = dragScrollListener;
    }

    public static interface onDragScrollListener {
        public void onScrollOverTop(int var1);

        public void onScrollDown(int var1);

        public void onScrollUp();
    }
}

