/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import android.widget.ImageView;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;

@SuppressLint(value={"AppCompatCustomView"})
public class ShowTypeImageView
extends ImageView {
    public static final int TYPE_GIF = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_NONE = 3;
    public static final int TYPE_VIDEO = 5;
    public static final int TYPE_IMAGECOUNT = 4;
    protected int imageType = 3;
    private String imageCountTip = "";
    private boolean isSelect = false;
    private Paint mCirclePaint;
    private Paint mMaskPaint;
    private Paint mBitmapPaint;
    private Paint mTextPaint;
    private RectF rectF;
    private Paint mSelectPaint;
    private Bitmap videoBitmap;

    public ShowTypeImageView(Context context) {
        super(context);
        this.init();
    }

    public ShowTypeImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ShowTypeImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setType(int type) {
        this.imageType = type;
        this.invalidate();
    }

    public void setSelect(boolean isSelect, int selectColor) {
        this.isSelect = isSelect;
        this.mSelectPaint.setColor(selectColor);
        this.invalidate();
    }

    private void init() {
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(Color.parseColor((String)"#ffffff"));
        this.mCirclePaint.setAlpha(200);
        this.mMaskPaint = new Paint();
        this.mMaskPaint.setAntiAlias(true);
        this.mMaskPaint.setColor(Color.parseColor((String)"#40000000"));
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setAntiAlias(true);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(Color.parseColor((String)"#90000000"));
        this.mTextPaint.setTextSize((float)this.sp(12.0f));
        this.mTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.rectF = new RectF();
        this.mSelectPaint = new Paint();
        this.mSelectPaint.setAntiAlias(true);
        this.mSelectPaint.setStrokeWidth((float)this.dp(4.0f));
        this.mSelectPaint.setStyle(Paint.Style.STROKE);
        try {
            this.videoBitmap = ((BitmapDrawable)this.getResources().getDrawable(R.mipmap.picker_item_video)).getBitmap();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isSelect) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mSelectPaint);
        }
        if (this.imageType == 3) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this.imageType) {
            case 5: {
                if (this.videoBitmap == null) break;
                canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mMaskPaint);
                canvas.drawBitmap(this.videoBitmap, (float)(width - this.videoBitmap.getWidth() >> 1), (float)(height - this.videoBitmap.getHeight() >> 1), this.mBitmapPaint);
                break;
            }
            case 1: {
                canvas.drawCircle((float)(width >> 1), (float)(height >> 1), (float)width * 0.18f, this.mCirclePaint);
                canvas.drawText("GIF", (float)((width >> 1) - this.dp(10.0f)), (float)((height >> 1) + this.dp(5.0f)), this.mTextPaint);
                break;
            }
            case 2: {
                this.rectF.left = width - this.dp(30.0f);
                this.rectF.top = height - this.dp(20.0f);
                this.rectF.right = width + this.dp(3.0f);
                this.rectF.bottom = height;
                canvas.drawRoundRect(this.rectF, (float)this.dp(3.0f), (float)this.dp(3.0f), this.mCirclePaint);
                canvas.drawText("\u957f\u56fe", (float)(width - this.dp(27.0f)), (float)(height - this.dp(6.0f)), this.mTextPaint);
                break;
            }
            case 4: {
                this.rectF.left = width - this.dp(30.0f);
                this.rectF.top = height - this.dp(20.0f);
                this.rectF.right = width + this.dp(3.0f);
                this.rectF.bottom = height;
                canvas.drawRoundRect(this.rectF, (float)this.dp(3.0f), (float)this.dp(3.0f), this.mCirclePaint);
                canvas.drawText(this.imageCountTip, (float)(width - this.dp(27.0f)), (float)(height - this.dp(6.0f)), this.mTextPaint);
            }
        }
    }

    public int sp(float spValue) {
        float fontScale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public void setImageCountTip(String imageCountTip) {
        this.imageCountTip = imageCountTip;
        this.imageType = 4;
        this.invalidate();
    }

    public void setTypeFromImage(ImageItem imageItem) {
        if (this.imageType == 4) {
            return;
        }
        if (imageItem.isVideo()) {
            this.setType(5);
        } else if (imageItem.isGif()) {
            this.setType(1);
        } else if (imageItem.isLongImage()) {
            this.setType(2);
        } else {
            this.setType(3);
        }
    }

    public int getScreenHeight() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        assert (wm != null);
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    public int dp(float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

