/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.wx;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.views.base.PickerControllerView;
import java.util.ArrayList;

public class WXTitleBar
extends PickerControllerView {
    private TextView mTvTitle;
    private ImageView mSetArrowImg;
    private ImageView ivBack;
    private TextView mCompleteBtn;
    private String completeText;
    private Drawable selectDrawable;
    private Drawable unSelectDrawable;
    private int selectColor;
    private int unSelectColor;
    private boolean canToggleFolderList;

    public WXTitleBar(Context context) {
        super(context);
    }

    @Override
    public int getViewHeight() {
        return this.dp(50.0f);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_default_titlebar;
    }

    @Override
    protected void initView(View view) {
        this.mTvTitle = (TextView)view.findViewById(R.id.tv_title);
        this.mSetArrowImg = (ImageView)view.findViewById(R.id.mSetArrowImg);
        this.ivBack = (ImageView)view.findViewById(R.id.iv_back);
        this.mCompleteBtn = (TextView)view.findViewById(R.id.tv_rightBtn);
        this.setShowArrow(false);
        this.setBackgroundColor(this.getResources().getColor(R.color.white_F5));
        this.setImageSetArrowIconID(R.mipmap.picker_arrow_down);
        this.completeText = this.getContext().getString(R.string.picker_str_title_right);
        this.selectDrawable = PCornerUtils.cornerDrawable(this.getThemeColor(), this.dp(2.0f));
        int halfColor = Color.argb((int)100, (int)Color.red((int)this.getThemeColor()), (int)Color.green((int)this.getThemeColor()), (int)Color.blue((int)this.getThemeColor()));
        this.unSelectDrawable = PCornerUtils.cornerDrawable(halfColor, this.dp(2.0f));
        this.unSelectColor = -1;
        this.selectColor = -1;
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WXTitleBar.this.onBackPressed();
            }
        });
    }

    @Override
    public View getCanClickToCompleteView() {
        return this.mCompleteBtn;
    }

    @Override
    public View getCanClickToIntentPreviewView() {
        return null;
    }

    @Override
    public View getCanClickToToggleFolderListView() {
        return this.canToggleFolderList ? this.mTvTitle : null;
    }

    @Override
    public void setTitle(String title) {
        this.mTvTitle.setText((CharSequence)title);
    }

    @Override
    public void onTransitImageSet(boolean isOpen) {
        this.mSetArrowImg.setRotation(isOpen ? 180.0f : 0.0f);
    }

    @Override
    public void onImageSetSelected(ImageSet imageSet) {
        if (this.canToggleFolderList) {
            this.mTvTitle.setText((CharSequence)imageSet.name);
        }
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void refreshCompleteViewState(ArrayList<ImageItem> selectedList, BaseSelectConfig selectConfig) {
        if (selectConfig.getMaxCount() <= 1 && selectConfig.isSinglePickAutoComplete()) {
            this.mCompleteBtn.setVisibility(8);
        } else {
            this.mCompleteBtn.setVisibility(0);
            if (selectedList == null || selectedList.size() == 0) {
                this.mCompleteBtn.setEnabled(false);
                this.mCompleteBtn.setText((CharSequence)this.completeText);
                this.mCompleteBtn.setTextColor(this.unSelectColor);
                this.mCompleteBtn.setBackground(this.unSelectDrawable);
            } else {
                this.mCompleteBtn.setEnabled(true);
                this.mCompleteBtn.setTextColor(this.selectColor);
                this.mCompleteBtn.setText((CharSequence)String.format("%s(%d/%d)", this.completeText, selectedList.size(), selectConfig.getMaxCount()));
                this.mCompleteBtn.setBackground(this.selectDrawable);
            }
        }
    }

    public void centerTitle() {
        ((LinearLayout)this.mTvTitle.getParent()).setGravity(17);
    }

    public void setBackIconID(int backIconID) {
        this.ivBack.setImageDrawable(this.getResources().getDrawable(backIconID));
    }

    public void setCanToggleFolderList(boolean canToggleFolderList) {
        this.canToggleFolderList = canToggleFolderList;
    }

    public void setCompleteBackground(Drawable selectDrawable, Drawable unSelectDrawable) {
        this.selectDrawable = selectDrawable;
        this.unSelectDrawable = unSelectDrawable;
        this.mCompleteBtn.setBackground(unSelectDrawable);
    }

    public void setCompleteText(String completeText) {
        this.completeText = completeText;
        this.mCompleteBtn.setText((CharSequence)completeText);
    }

    public void setCompleteTextColor(int selectColor, int unSelectColor) {
        this.selectColor = selectColor;
        this.unSelectColor = unSelectColor;
        this.mCompleteBtn.setTextColor(unSelectColor);
    }

    public void setImageSetArrowIconID(int imageSetArrowIconID) {
        this.mSetArrowImg.setImageDrawable(this.getResources().getDrawable(imageSetArrowIconID));
    }

    public void setShowArrow(boolean isShow) {
        this.mSetArrowImg.setVisibility(isShow ? 0 : 8);
    }

    public void setTitleTextColor(int color2) {
        this.mTvTitle.setTextColor(color2);
        this.mSetArrowImg.setColorFilter(color2);
    }
}

