/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.wx;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.adapter.MultiPreviewAdapter;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.PickerItemDisableCode;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.helper.recyclerviewitemhelper.SimpleItemTouchHelperCallback;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.utils.PStatusBarUtil;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.base.PickerControllerView;
import com.ypx.imagepicker.views.base.PreviewControllerView;
import com.ypx.imagepicker.views.wx.WXTitleBar;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class WXPreviewControllerView
extends PreviewControllerView {
    private RecyclerView mPreviewRecyclerView;
    private RelativeLayout mBottomBar;
    private CheckBox mSelectCheckBox;
    private CheckBox mOriginalCheckBox;
    private MultiPreviewAdapter previewAdapter;
    private IPickerPresenter presenter;
    private BaseSelectConfig selectConfig;
    private PickerUiConfig uiConfig;
    private ArrayList<ImageItem> selectedList;
    private FrameLayout mTitleContainer;
    private boolean isShowOriginal = false;
    private PickerControllerView titleBar;
    private ImageItem currentImageItem;

    public WXPreviewControllerView(Context context) {
        super(context);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_wx_preview_bottombar;
    }

    @Override
    protected void initView(View view) {
        this.mPreviewRecyclerView = (RecyclerView)view.findViewById(R.id.mPreviewRecyclerView);
        this.mBottomBar = (RelativeLayout)view.findViewById(R.id.bottom_bar);
        this.mSelectCheckBox = (CheckBox)view.findViewById(R.id.mSelectCheckBox);
        this.mOriginalCheckBox = (CheckBox)view.findViewById(R.id.mOriginalCheckBox);
        this.mTitleContainer = (FrameLayout)view.findViewById(R.id.mTitleContainer);
        this.mBottomBar.setClickable(true);
        this.setOriginalCheckBoxDrawable(R.mipmap.picker_wechat_unselect, R.mipmap.picker_wechat_select);
        this.setSelectCheckBoxDrawable(R.mipmap.picker_wechat_unselect, R.mipmap.picker_wechat_select);
        this.mOriginalCheckBox.setText((CharSequence)this.getContext().getString(R.string.picker_str_bottom_original));
        this.mSelectCheckBox.setText((CharSequence)this.getContext().getString(R.string.picker_str_bottom_choose));
    }

    @Override
    public void setStatusBar() {
        this.setTitleBarColor(this.getResources().getColor(R.color.white_F5));
        this.setBottomBarColor(Color.parseColor((String)"#f0303030"));
    }

    @Override
    public void initData(BaseSelectConfig selectConfig, IPickerPresenter presenter, PickerUiConfig uiConfig, ArrayList<ImageItem> selectedList) {
        this.selectConfig = selectConfig;
        this.presenter = presenter;
        this.selectedList = selectedList;
        this.uiConfig = uiConfig;
        this.isShowOriginal = selectConfig instanceof MultiSelectConfig && ((MultiSelectConfig)selectConfig).isShowOriginalCheckBox();
        this.initUI();
        this.initPreviewList();
    }

    private void initUI() {
        this.titleBar = this.uiConfig.getPickerUiProvider().getTitleBar(this.getContext());
        if (this.titleBar == null) {
            this.titleBar = new WXTitleBar(this.getContext());
        }
        this.mTitleContainer.addView((View)this.titleBar, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.mSelectCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (!isChecked) {
                    WXPreviewControllerView.this.mSelectCheckBox.setChecked(false);
                    WXPreviewControllerView.this.selectedList.remove(WXPreviewControllerView.this.currentImageItem);
                } else {
                    int disableCode = PickerItemDisableCode.getItemDisableCode(WXPreviewControllerView.this.currentImageItem, WXPreviewControllerView.this.selectConfig, WXPreviewControllerView.this.selectedList, WXPreviewControllerView.this.selectedList.contains(WXPreviewControllerView.this.currentImageItem));
                    if (disableCode != 0) {
                        String message = PickerItemDisableCode.getMessageFormCode(WXPreviewControllerView.this.getContext(), disableCode, WXPreviewControllerView.this.presenter, WXPreviewControllerView.this.selectConfig);
                        if (message.length() > 0) {
                            WXPreviewControllerView.this.presenter.tip((Context)new WeakReference<Context>(WXPreviewControllerView.this.getContext()).get(), message);
                        }
                        WXPreviewControllerView.this.mSelectCheckBox.setChecked(false);
                        return;
                    }
                    if (!WXPreviewControllerView.this.selectedList.contains(WXPreviewControllerView.this.currentImageItem)) {
                        WXPreviewControllerView.this.selectedList.add(WXPreviewControllerView.this.currentImageItem);
                    }
                    WXPreviewControllerView.this.mSelectCheckBox.setChecked(true);
                }
                WXPreviewControllerView.this.titleBar.refreshCompleteViewState(WXPreviewControllerView.this.selectedList, WXPreviewControllerView.this.selectConfig);
                WXPreviewControllerView.this.notifyPreviewList(WXPreviewControllerView.this.currentImageItem);
            }
        });
        this.mOriginalCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    WXPreviewControllerView.this.mSelectCheckBox.setChecked(true);
                }
                ImagePicker.isOriginalImage = isChecked;
            }
        });
    }

    private void initPreviewList() {
        this.mPreviewRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.previewAdapter = new MultiPreviewAdapter(this.selectedList, this.presenter);
        this.mPreviewRecyclerView.setAdapter((RecyclerView.Adapter)this.previewAdapter);
        SimpleItemTouchHelperCallback callback = new SimpleItemTouchHelperCallback(this.previewAdapter);
        ItemTouchHelper mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)callback);
        mItemTouchHelper.attachToRecyclerView(this.mPreviewRecyclerView);
    }

    private void notifyPreviewList(ImageItem imageItem) {
        this.previewAdapter.setPreviewImageItem(imageItem);
        if (this.selectedList.contains(imageItem)) {
            this.mPreviewRecyclerView.smoothScrollToPosition(this.selectedList.indexOf(imageItem));
        }
    }

    @Override
    public View getCompleteView() {
        return this.titleBar.getCanClickToCompleteView();
    }

    @Override
    public void singleTap() {
        if (this.mTitleContainer.getVisibility() == 0) {
            this.mTitleContainer.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.picker_top_out));
            this.mBottomBar.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.picker_fade_out));
            this.mPreviewRecyclerView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.picker_fade_out));
            this.mTitleContainer.setVisibility(8);
            this.mBottomBar.setVisibility(8);
            this.mPreviewRecyclerView.setVisibility(8);
        } else {
            this.mTitleContainer.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.picker_top_in));
            this.mBottomBar.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.picker_fade_in));
            this.mPreviewRecyclerView.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.picker_fade_in));
            this.mTitleContainer.setVisibility(0);
            this.mBottomBar.setVisibility(0);
            this.mPreviewRecyclerView.setVisibility(0);
        }
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void onPageSelected(int position, ImageItem imageItem, int totalPreviewCount) {
        this.currentImageItem = imageItem;
        this.titleBar.setTitle(String.format("%d/%d", position + 1, totalPreviewCount));
        this.mSelectCheckBox.setChecked(this.selectedList.contains(imageItem));
        this.notifyPreviewList(imageItem);
        this.titleBar.refreshCompleteViewState(this.selectedList, this.selectConfig);
        if (!imageItem.isVideo() && this.isShowOriginal) {
            this.mOriginalCheckBox.setVisibility(0);
            this.mOriginalCheckBox.setChecked(ImagePicker.isOriginalImage);
        } else {
            this.mOriginalCheckBox.setVisibility(8);
        }
    }

    public void setOriginalCheckBoxDrawable(int unCheckDrawableID, int checkedDrawableID) {
        PCornerUtils.setCheckBoxDrawable(this.mOriginalCheckBox, checkedDrawableID, unCheckDrawableID);
    }

    public void setSelectCheckBoxDrawable(int unCheckDrawableID, int checkedDrawableID) {
        PCornerUtils.setCheckBoxDrawable(this.mSelectCheckBox, checkedDrawableID, unCheckDrawableID);
    }

    public void setTitleBarColor(int titleBarColor) {
        this.mTitleContainer.setBackgroundColor(titleBarColor);
        this.mTitleContainer.setPadding(0, PStatusBarUtil.getStatusBarHeight(this.getContext()), 0, 0);
        PStatusBarUtil.setStatusBar((Activity)this.getContext(), 0, true, PStatusBarUtil.isDarkColor(titleBarColor));
    }

    public void setBottomBarColor(int bottomBarColor) {
        this.mBottomBar.setBackgroundColor(bottomBarColor);
        this.mPreviewRecyclerView.setBackgroundColor(bottomBarColor);
    }
}

