/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.wx;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.views.base.PickerItemView;
import com.ypx.imagepicker.widget.ShowTypeImageView;

public class WXItemView
extends PickerItemView {
    private ShowTypeImageView mImageView;
    private View mVMasker;
    private CheckBox mCheckBox;
    private FrameLayout mCheckBoxPanel;
    private TextView mVideoTime;
    private LinearLayout mVideoLayout;
    private BaseSelectConfig selectConfig;

    public WXItemView(Context context) {
        super(context);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_image_grid_item;
    }

    @Override
    protected void initView(View view) {
        this.mImageView = (ShowTypeImageView)view.findViewById(R.id.mImageView);
        this.mVMasker = view.findViewById(R.id.v_masker);
        this.mCheckBox = (CheckBox)view.findViewById(R.id.mCheckBox);
        this.mCheckBoxPanel = (FrameLayout)view.findViewById(R.id.mCheckBoxPanel);
        this.mVideoTime = (TextView)view.findViewById(R.id.mVideoTime);
        this.mVideoLayout = (LinearLayout)view.findViewById(R.id.mVideoLayout);
        this.mCheckBox.setClickable(false);
        Drawable unSelectDrawable = this.getResources().getDrawable(R.mipmap.picker_wechat_unselect);
        unSelectDrawable.setColorFilter(-1, PorterDuff.Mode.SRC_ATOP);
        this.setCheckBoxDrawable(unSelectDrawable, this.getResources().getDrawable(R.mipmap.picker_wechat_select));
    }

    @Override
    @SuppressLint(value={"InflateParams"})
    public View getCameraView(BaseSelectConfig selectConfig, IPickerPresenter presenter) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.picker_item_camera, null);
        TextView mTvvCamera = (TextView)view.findViewById(R.id.tv_camera);
        mTvvCamera.setText((CharSequence)(selectConfig.isOnlyShowVideo() ? this.getContext().getString(R.string.picker_str_item_take_video) : this.getContext().getString(R.string.picker_str_item_take_photo)));
        return view;
    }

    @Override
    public View getCheckBoxView() {
        return this.mCheckBoxPanel;
    }

    @Override
    public void initItem(ImageItem imageItem, IPickerPresenter presenter, BaseSelectConfig selectConfig) {
        this.selectConfig = selectConfig;
        presenter.displayImage((View)this.mImageView, imageItem, this.mImageView.getWidth(), true);
    }

    @Override
    public void disableItem(ImageItem imageItem, int disableCode) {
        if (disableCode == 2) {
            return;
        }
        this.mCheckBox.setVisibility(8);
        this.mVMasker.setVisibility(0);
        this.mVMasker.setBackgroundColor(Color.parseColor((String)"#80FFFFFF"));
    }

    @Override
    public void enableItem(ImageItem imageItem, boolean isChecked, int indexOfSelectedList) {
        boolean isVideoSinglePickAndAutoComplete;
        if (imageItem.isVideo()) {
            this.mVideoLayout.setVisibility(0);
            this.mVideoTime.setText((CharSequence)imageItem.getDurationFormat());
            this.mImageView.setType(3);
        } else {
            this.mVideoLayout.setVisibility(8);
            this.mImageView.setTypeFromImage(imageItem);
        }
        this.mCheckBox.setVisibility(0);
        this.mCheckBoxPanel.setVisibility(0);
        boolean bl = isVideoSinglePickAndAutoComplete = imageItem.isVideo() && this.selectConfig.isVideoSinglePickAndAutoComplete();
        if (isVideoSinglePickAndAutoComplete || this.selectConfig.isSinglePickAutoComplete() && this.selectConfig.getMaxCount() <= 1) {
            this.mCheckBox.setVisibility(8);
            this.mCheckBoxPanel.setVisibility(8);
        }
        this.mCheckBox.setChecked(isChecked);
        this.mVMasker.setVisibility(isChecked ? 0 : 8);
        this.mVMasker.setBackgroundColor(isChecked ? Color.parseColor((String)"#80000000") : 0);
    }

    public void setCheckBoxDrawable(int unCheckDrawableID, int checkedDrawableID) {
        PCornerUtils.setCheckBoxDrawable(this.mCheckBox, checkedDrawableID, unCheckDrawableID);
    }

    public void setCheckBoxDrawable(Drawable unCheckDrawable, Drawable checkedDrawable) {
        PCornerUtils.setCheckBoxDrawable(this.mCheckBox, checkedDrawable, unCheckDrawable);
    }
}

