/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.wx;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.views.base.PickerFolderItemView;

public class WXFolderItemView
extends PickerFolderItemView {
    private ImageView mCover;
    private TextView mName;
    private TextView mSize;
    private ImageView mIndicator;
    private View mDivider;

    public WXFolderItemView(Context context) {
        super(context);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_folder_item;
    }

    @Override
    protected void initView(View view) {
        this.mCover = (ImageView)view.findViewById(R.id.cover);
        this.mName = (TextView)view.findViewById(R.id.name);
        this.mSize = (TextView)view.findViewById(R.id.size);
        this.mIndicator = (ImageView)view.findViewById(R.id.indicator);
        this.mDivider = view.findViewById(R.id.mDivider);
        this.setBackground(this.getResources().getDrawable(R.drawable.picker_selector_list_item_bg));
        this.mIndicator.setColorFilter(this.getThemeColor());
    }

    @Override
    public int getItemHeight() {
        return -1;
    }

    @Override
    public void displayCoverImage(ImageSet imageSet, IPickerPresenter presenter) {
        this.mIndicator.setColorFilter(this.getThemeColor());
        if (imageSet.cover != null) {
            presenter.displayImage((View)this.mCover, imageSet.cover, this.mCover.getMeasuredWidth(), true);
        } else {
            ImageItem imageItem = new ImageItem();
            imageItem.path = imageSet.coverPath;
            imageItem.setUriPath(imageSet.coverPath);
            presenter.displayImage((View)this.mCover, imageItem, this.mCover.getMeasuredWidth(), true);
        }
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void loadItem(ImageSet imageSet) {
        this.mName.setText((CharSequence)imageSet.name);
        this.mSize.setText((CharSequence)String.format("%d%s", imageSet.count, this.getContext().getString(R.string.picker_str_folder_image_unit)));
        if (imageSet.isSelected) {
            this.mIndicator.setVisibility(0);
        } else {
            this.mIndicator.setVisibility(8);
        }
    }

    public void setIndicatorDrawable(Drawable drawable2) {
        this.mIndicator.setImageDrawable(drawable2);
    }

    public void setIndicatorColor(int color2) {
        this.mIndicator.setColorFilter(color2);
    }

    public void setDividerColor(int color2) {
        this.mDivider.setBackgroundColor(color2);
    }

    public void setNameTextColor(int color2) {
        this.mName.setTextColor(color2);
    }

    public void setCountTextColor(int color2) {
        this.mSize.setTextColor(color2);
    }
}

