/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.wx;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.bean.selectconfig.MultiSelectConfig;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.views.base.PickerControllerView;
import java.util.ArrayList;

public class WXBottomBar
extends PickerControllerView {
    private Button mDirButton;
    private TextView mPreview;
    private CheckBox mCheckBox;
    private String previewText;

    public WXBottomBar(Context context) {
        super(context);
    }

    @Override
    public int getViewHeight() {
        return this.dp(50.0f);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_default_bottombar;
    }

    @Override
    protected void initView(View view) {
        this.mDirButton = (Button)view.findViewById(R.id.mDirButton);
        this.mPreview = (TextView)view.findViewById(R.id.mPreview);
        this.mCheckBox = (CheckBox)view.findViewById(R.id.mCheckBox);
        this.setCheckBoxDrawable(R.mipmap.picker_wechat_unselect, R.mipmap.picker_wechat_select);
        this.setBottomBarColor(Color.parseColor((String)"#303030"));
        this.mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ImagePicker.isOriginalImage = isChecked;
            }
        });
        this.previewText = this.getContext().getString(R.string.picker_str_bottom_preview);
        this.mPreview.setText((CharSequence)this.previewText);
        this.mCheckBox.setText((CharSequence)this.getContext().getString(R.string.picker_str_bottom_original));
    }

    @Override
    public View getCanClickToCompleteView() {
        return null;
    }

    @Override
    public View getCanClickToIntentPreviewView() {
        return this.mPreview;
    }

    @Override
    public View getCanClickToToggleFolderListView() {
        return this.mDirButton;
    }

    @Override
    public void setTitle(String title) {
        this.mDirButton.setText((CharSequence)title);
    }

    @Override
    public void onTransitImageSet(boolean isOpen) {
    }

    @Override
    public void onImageSetSelected(ImageSet imageSet) {
        this.mDirButton.setText((CharSequence)imageSet.name);
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void refreshCompleteViewState(ArrayList<ImageItem> selectedList, BaseSelectConfig selectConfig) {
        this.mPreview.setVisibility(0);
        if (selectConfig instanceof MultiSelectConfig) {
            MultiSelectConfig selectConfig1 = (MultiSelectConfig)selectConfig;
            if (selectConfig1.isShowOriginalCheckBox()) {
                this.mCheckBox.setVisibility(0);
                this.mCheckBox.setChecked(ImagePicker.isOriginalImage);
            } else {
                this.mCheckBox.setVisibility(8);
            }
            if (!selectConfig1.isPreview()) {
                this.mPreview.setVisibility(8);
            }
        }
        if (selectedList.size() > 0) {
            this.mPreview.setText((CharSequence)String.format("%s(%d)", this.previewText, selectedList.size()));
            this.mPreview.setTextColor(this.getResources().getColor(R.color.white_F5));
        } else {
            this.mPreview.setText((CharSequence)String.format("%s", this.previewText));
            this.mPreview.setTextColor(Color.parseColor((String)"#50FFFFFF"));
        }
    }

    public void setCheckBoxDrawable(int unCheckDrawableID, int checkedDrawableID) {
        PCornerUtils.setCheckBoxDrawable(this.mCheckBox, checkedDrawableID, unCheckDrawableID);
    }

    public void setCheckBoxDrawable(Drawable unCheckDrawable, Drawable checkedDrawable) {
        PCornerUtils.setCheckBoxDrawable(this.mCheckBox, checkedDrawable, unCheckDrawable);
    }

    public void setBottomBarColor(int bottomBarColor) {
        this.setBackgroundColor(bottomBarColor);
    }
}

