/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.redbook;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.ImageSet;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.views.base.PickerControllerView;
import java.util.ArrayList;

public class RedBookTitleBar
extends PickerControllerView {
    private TextView mTvTitle;
    private ImageView mArrowImg;
    private TextView mTvNext;
    private TextView mTvSelectNum;

    public RedBookTitleBar(Context context) {
        super(context);
    }

    public RedBookTitleBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RedBookTitleBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public int getViewHeight() {
        return this.dp(55.0f);
    }

    public void setImageSetArrowIconID(int imageSetArrowIconID) {
        this.mArrowImg.setImageDrawable(this.getResources().getDrawable(imageSetArrowIconID));
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_redbook_titlebar;
    }

    @Override
    protected void initView(View view) {
        ImageView mBackImg = (ImageView)view.findViewById(R.id.mBackImg);
        this.mTvTitle = (TextView)view.findViewById(R.id.mTvSetName);
        this.mArrowImg = (ImageView)view.findViewById(R.id.mArrowImg);
        this.mTvNext = (TextView)view.findViewById(R.id.mTvNext);
        this.mTvSelectNum = (TextView)view.findViewById(R.id.mTvSelectNum);
        this.mTvSelectNum.setVisibility(8);
        this.setImageSetArrowIconID(R.mipmap.picker_arrow_down);
        mBackImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RedBookTitleBar.this.onBackPressed();
            }
        });
        this.setBackgroundColor(-16777216);
        mBackImg.setColorFilter(-1);
        this.mArrowImg.setColorFilter(-1);
        this.mTvTitle.setTextColor(-1);
        this.mTvNext.setTextColor(-1);
        this.mTvNext.setBackground(PCornerUtils.cornerDrawable(Color.parseColor((String)"#50B0B0B0"), this.dp(30.0f)));
        this.mTvNext.setText((CharSequence)this.getContext().getString(R.string.picker_str_title_right));
    }

    @Override
    public boolean isAddInParent() {
        return true;
    }

    @Override
    public View getCanClickToCompleteView() {
        return this.mTvNext;
    }

    @Override
    public View getCanClickToIntentPreviewView() {
        return null;
    }

    @Override
    public View getCanClickToToggleFolderListView() {
        return this.mTvTitle;
    }

    @Override
    public void setTitle(String title) {
        this.mTvTitle.setText((CharSequence)title);
    }

    @Override
    public void onTransitImageSet(boolean isOpen) {
        if (isOpen) {
            this.mArrowImg.setRotation(180.0f);
        } else {
            this.mArrowImg.setRotation(0.0f);
        }
    }

    @Override
    public void onImageSetSelected(ImageSet imageSet) {
        this.mTvTitle.setText((CharSequence)imageSet.name);
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void refreshCompleteViewState(ArrayList<ImageItem> selectedList, BaseSelectConfig selectConfig) {
        if (selectedList != null && selectedList.size() == 0) {
            this.mTvNext.setEnabled(false);
            this.mTvNext.setBackground(PCornerUtils.cornerDrawable(Color.parseColor((String)"#50B0B0B0"), this.dp(30.0f)));
            this.mTvSelectNum.setVisibility(8);
        } else {
            this.mTvNext.setEnabled(true);
            this.mTvNext.setBackground(PCornerUtils.cornerDrawable(this.getThemeColor(), this.dp(30.0f)));
        }
    }
}

