/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.redbook;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PCornerUtils;
import com.ypx.imagepicker.views.base.PickerItemView;

public class RedBookItemView
extends PickerItemView {
    private ImageView imageView;
    private View mVMask;
    private View mVSelect;
    private TextView mTvIndex;
    private TextView mTvDuration;
    private BaseSelectConfig selectConfig;

    public RedBookItemView(Context context) {
        super(context);
    }

    public RedBookItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RedBookItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.picker_item;
    }

    @Override
    protected void initView(View view) {
        this.mTvIndex = (TextView)view.findViewById(R.id.mTvIndex);
        this.mVMask = view.findViewById(R.id.v_mask);
        this.mVSelect = view.findViewById(R.id.v_select);
        this.imageView = (ImageView)view.findViewById(R.id.iv_image);
        this.mTvDuration = (TextView)view.findViewById(R.id.mTvDuration);
    }

    @Override
    public View getCameraView(BaseSelectConfig selectConfig, IPickerPresenter presenter) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.picker_item_camera, null);
        TextView mTvvCamera = (TextView)view.findViewById(R.id.tv_camera);
        mTvvCamera.setText((CharSequence)(selectConfig.isOnlyShowVideo() ? this.getContext().getString(R.string.picker_str_item_take_video) : this.getContext().getString(R.string.picker_str_item_take_photo)));
        return view;
    }

    @Override
    public View getCheckBoxView() {
        return this.mVSelect;
    }

    @Override
    public void initItem(ImageItem imageItem, IPickerPresenter presenter, BaseSelectConfig selectConfig) {
        this.selectConfig = selectConfig;
        presenter.displayImage((View)this.imageView, imageItem, this.imageView.getWidth(), true);
    }

    @Override
    public void disableItem(ImageItem imageItem, int disableCode) {
        if (disableCode == 2) {
            return;
        }
        this.mVMask.setVisibility(0);
        this.mVMask.setBackgroundColor(Color.parseColor((String)"#80FFFFFF"));
        this.mTvIndex.setVisibility(8);
        this.mVSelect.setVisibility(8);
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void enableItem(ImageItem imageItem, boolean isChecked, int indexOfSelectedList) {
        this.mTvIndex.setVisibility(0);
        this.mVSelect.setVisibility(0);
        if (imageItem.isVideo()) {
            this.mTvDuration.setVisibility(0);
            this.mTvDuration.setText((CharSequence)imageItem.getDurationFormat());
            if (this.selectConfig.isVideoSinglePick() && this.selectConfig.isSinglePickAutoComplete()) {
                this.mTvIndex.setVisibility(8);
                this.mVSelect.setVisibility(8);
            }
        } else {
            this.mTvDuration.setVisibility(8);
        }
        if (indexOfSelectedList >= 0) {
            this.mTvIndex.setText((CharSequence)String.format("%d", indexOfSelectedList + 1));
            this.mTvIndex.setBackground(PCornerUtils.cornerDrawableAndStroke(this.getThemeColor(), this.dp(12.0f), this.dp(1.0f), -1));
        } else {
            this.mTvIndex.setBackground(this.getResources().getDrawable(R.mipmap.picker_icon_unselect));
            this.mTvIndex.setText((CharSequence)"");
        }
        if (imageItem.isPress()) {
            this.mVMask.setVisibility(0);
            int halfColor = Color.argb((int)100, (int)Color.red((int)this.getThemeColor()), (int)Color.green((int)this.getThemeColor()), (int)Color.blue((int)this.getThemeColor()));
            Drawable maskDrawable = PCornerUtils.cornerDrawableAndStroke(halfColor, 0.0f, this.dp(2.0f), this.getThemeColor());
            this.mVMask.setBackground(maskDrawable);
        } else {
            this.mVMask.setVisibility(8);
        }
    }
}

