/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.base;

import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.ypx.imagepicker.R;
import com.ypx.imagepicker.bean.ImageItem;
import com.ypx.imagepicker.bean.selectconfig.BaseSelectConfig;
import com.ypx.imagepicker.helper.DetailImageLoadHelper;
import com.ypx.imagepicker.presenter.IPickerPresenter;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import com.ypx.imagepicker.views.PickerUiConfig;
import com.ypx.imagepicker.views.base.PBaseLayout;
import com.ypx.imagepicker.widget.cropimage.CropImageView;
import java.util.ArrayList;

public abstract class PreviewControllerView
extends PBaseLayout {
    public abstract void setStatusBar();

    public abstract void initData(BaseSelectConfig var1, IPickerPresenter var2, PickerUiConfig var3, ArrayList<ImageItem> var4);

    public abstract View getCompleteView();

    public abstract void singleTap();

    public abstract void onPageSelected(int var1, ImageItem var2, int var3);

    public PreviewControllerView(Context context) {
        super(context);
    }

    public PreviewControllerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PreviewControllerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public View getItemView(Fragment fragment, final ImageItem imageItem, IPickerPresenter presenter) {
        if (imageItem == null) {
            return new View(fragment.getContext());
        }
        RelativeLayout layout2 = new RelativeLayout(this.getContext());
        CropImageView imageView = new CropImageView(this.getContext());
        imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageView.setBounceEnable(true);
        imageView.enable();
        imageView.setShowImageRectLine(false);
        imageView.setCanShowTouchLine(false);
        imageView.setMaxScale(7.0f);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        imageView.setLayoutParams(params);
        layout2.setLayoutParams(params);
        layout2.addView((View)imageView);
        ImageView mVideoImg = new ImageView(this.getContext());
        mVideoImg.setImageDrawable(this.getResources().getDrawable(R.mipmap.picker_icon_video));
        RelativeLayout.LayoutParams params1 = new RelativeLayout.LayoutParams(PViewSizeUtils.dp(this.getContext(), 80.0f), PViewSizeUtils.dp(this.getContext(), 80.0f));
        mVideoImg.setLayoutParams((ViewGroup.LayoutParams)params1);
        params1.addRule(13);
        layout2.addView((View)mVideoImg, (ViewGroup.LayoutParams)params1);
        if (imageItem.isVideo()) {
            mVideoImg.setVisibility(0);
        } else {
            mVideoImg.setVisibility(8);
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (imageItem.isVideo()) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.addFlags(0x10000000);
                    intent.addFlags(1);
                    intent.setDataAndType(imageItem.getUri(), "video/*");
                    PreviewControllerView.this.getContext().startActivity(intent);
                    return;
                }
                PreviewControllerView.this.singleTap();
            }
        });
        DetailImageLoadHelper.displayDetailImage(false, imageView, presenter, imageItem);
        return layout2;
    }
}

