/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.views.base;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.ypx.imagepicker.ImagePicker;

public abstract class PBaseLayout
extends LinearLayout {
    protected View view;

    protected abstract int getLayoutId();

    protected abstract void initView(View var1);

    public PBaseLayout(Context context) {
        super(context);
        this.init();
    }

    public PBaseLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PBaseLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.view = LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.initView(this.view);
    }

    protected int dp(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    protected int getScreenWidth() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        assert (wm != null);
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public void onBackPressed() {
        if (this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).onBackPressed();
        }
    }

    protected int getThemeColor() {
        return ImagePicker.getThemeColor();
    }
}

