/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.utils;

import android.content.Context;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;

public final class PViewSizeUtils {
    private static long lastTime = 0L;

    public static void setViewSize(View view, int width, int height) {
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(width, height);
            } else {
                if (width != -1) {
                    params.width = width;
                }
                if (height != -1) {
                    params.height = height;
                }
            }
            ((View)viewWeakReference.get()).setLayoutParams(params);
        }
    }

    public static void setViewSize(View view, int width, float widthHeightRatio) {
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(width, (int)((float)width / widthHeightRatio));
            } else {
                if (width != -1) {
                    params.width = width;
                }
                if (widthHeightRatio != 0.0f) {
                    params.height = (int)((float)width / widthHeightRatio);
                }
            }
            ((View)viewWeakReference.get()).setLayoutParams(params);
        }
    }

    public static void setViewSize(View view, int width, int height, int marginLeft, int marginTop, int marginRight, int marginBottom) {
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && ((View)viewWeakReference.get()).getLayoutParams() != null && ((View)viewWeakReference.get()).getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            params.width = width;
            params.height = height;
            if (marginLeft != -1) {
                params.leftMargin = marginLeft;
            }
            if (marginRight != -1) {
                params.rightMargin = marginRight;
            }
            if (marginTop != -1) {
                params.topMargin = marginTop;
            }
            if (marginBottom != -1) {
                params.bottomMargin = marginBottom;
            }
            ((View)viewWeakReference.get()).setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public static void setViewMargin(View view, int margin) {
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && ((View)viewWeakReference.get()).getLayoutParams() != null && ((View)viewWeakReference.get()).getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            if (margin != -1) {
                params.leftMargin = margin;
                params.rightMargin = margin;
                params.topMargin = margin;
                params.bottomMargin = margin;
            }
            ((View)viewWeakReference.get()).setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public static int getViewHeight(View v) {
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (params != null) {
            return params.height;
        }
        return v.getHeight();
    }

    public static int getViewWidth(View v) {
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (params != null) {
            return params.width;
        }
        return v.getWidth();
    }

    public static void setMarginStart(View view, int marginStart) {
        ViewGroup.MarginLayoutParams params;
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && (params = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            params.leftMargin = marginStart;
            ((View)viewWeakReference.get()).setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public static void setMarginStartAndEnd(View view, int marginStart, int marginEnd) {
        ViewGroup.MarginLayoutParams params;
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && (params = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            params.leftMargin = marginStart;
            params.rightMargin = marginEnd;
            ((View)viewWeakReference.get()).setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public static void setMarginTopAndBottom(View view, int marginTop, int marginBottom) {
        ViewGroup.MarginLayoutParams params;
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && (params = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            params.topMargin = marginTop;
            params.bottomMargin = marginBottom;
            ((View)viewWeakReference.get()).setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public static void setMarginTop(View view, int marginTop) {
        ViewGroup.MarginLayoutParams params;
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && (params = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            params.topMargin = marginTop;
            ((View)viewWeakReference.get()).setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public static int getMarginTop(View view) {
        ViewGroup.MarginLayoutParams params;
        WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        if (viewWeakReference.get() != null && (params = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            return params.topMargin;
        }
        return 0;
    }

    public static int dp(Context context, float dp) {
        if (context == null) {
            return 0;
        }
        float density = context.getResources().getDisplayMetrics().density;
        return (int)((double)(dp * density) + 0.5);
    }

    public static int sp(Context context, int spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)((float)spValue * fontScale + 0.5f);
    }

    public static int getScreenWidth(Context context) {
        if (context == null) {
            return 0;
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        assert (wm != null);
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        assert (wm != null);
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    public static int blendColors(int color1, int color2, float ratio) {
        float inverseRation = 1.0f - ratio;
        float r = (float)Color.red((int)color1) * ratio + (float)Color.red((int)color2) * inverseRation;
        float g = (float)Color.green((int)color1) * ratio + (float)Color.green((int)color2) * inverseRation;
        float b = (float)Color.blue((int)color1) * ratio + (float)Color.blue((int)color2) * inverseRation;
        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
    }

    public static boolean onDoubleClick() {
        boolean flag = false;
        long time = System.currentTimeMillis() - lastTime;
        if (time > 300L) {
            flag = true;
        }
        lastTime = System.currentTimeMillis();
        return !flag;
    }
}

