/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.DisplayCutout;
import com.ypx.imagepicker.utils.PViewSizeUtils;
import java.lang.reflect.Method;

public class PStatusBarUtil {
    private static int statusBarHeight;

    public static boolean hasNotchInScreen(Activity activity) {
        block9: {
            if (Build.VERSION.SDK_INT >= 28) {
                try {
                    DisplayCutout displayCutout = activity.getWindow().getDecorView().getRootWindowInsets().getDisplayCutout();
                    if (displayCutout != null) {
                        return true;
                    }
                    break block9;
                }
                catch (Exception e) {
                    return false;
                }
            }
            String manufacturer = Build.MANUFACTURER;
            if (manufacturer == null || manufacturer.length() == 0) {
                return false;
            }
            if (manufacturer.equalsIgnoreCase("HUAWEI")) {
                return PStatusBarUtil.hasNotchHw(activity);
            }
            if (manufacturer.equalsIgnoreCase("xiaomi")) {
                return PStatusBarUtil.hasNotchXiaoMi(activity);
            }
            if (manufacturer.equalsIgnoreCase("oppo")) {
                return PStatusBarUtil.hasNotchOPPO(activity);
            }
            if (manufacturer.equalsIgnoreCase("vivo")) {
                return PStatusBarUtil.hasNotchVIVO(activity);
            }
            return false;
        }
        return false;
    }

    public static boolean hasNotchVIVO(Activity activity) {
        try {
            Class<?> c = Class.forName("android.util.FtFeature");
            Method get = c.getMethod("isFeatureSupport", Integer.TYPE);
            return (Boolean)get.invoke(c, 32);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasNotchOPPO(Activity activity) {
        try {
            return activity.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasNotchXiaoMi(Activity activity) {
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("getInt", String.class, Integer.TYPE);
            return (Integer)get.invoke(c, "ro.miui.notch", 1) == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasNotchHw(Activity activity) {
        try {
            ClassLoader cl = activity.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            return (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setStatusBar(Activity activity, int bgColor, boolean isFullScreen, boolean isDarkStatusBarIcon) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        int option = 0;
        activity.getWindow().addFlags(Integer.MIN_VALUE);
        activity.getWindow().clearFlags(0x4000000);
        if (Build.VERSION.SDK_INT >= 23) {
            activity.getWindow().setStatusBarColor(bgColor);
            option = isDarkStatusBarIcon ? (isFullScreen ? 9472 : 8448) : (isFullScreen ? 1280 : 256);
        } else if (isFullScreen) {
            activity.getWindow().setStatusBarColor(0);
            option = 1280;
        } else {
            activity.getWindow().setStatusBarColor(bgColor);
            option = 256;
        }
        activity.getWindow().getDecorView().setSystemUiVisibility(option);
    }

    public static boolean isDarkColor(int colorInt) {
        int gray = (int)((double)Color.red((int)colorInt) * 0.299 + (double)Color.green((int)colorInt) * 0.587 + (double)Color.blue((int)colorInt) * 0.114);
        return gray >= 192;
    }

    public static int getStatusBarHeight(Context activity) {
        if (statusBarHeight != 0) {
            return statusBarHeight;
        }
        try {
            int result = 0;
            int resourceId = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                result = activity.getResources().getDimensionPixelSize(resourceId);
            }
            statusBarHeight = result;
            return result;
        }
        catch (Exception e) {
            return PViewSizeUtils.dp(activity, 20.0f);
        }
    }

    public static void fullScreenWithCheckNotch(Activity activity, int statusBarColor) {
        if (PStatusBarUtil.hasNotchInScreen(activity)) {
            PStatusBarUtil.setStatusBar(activity, statusBarColor, false, true);
        } else {
            activity.getWindow().setFlags(1024, 1024);
        }
    }

    public static void fullScreen(Activity activity) {
        activity.getWindow().setFlags(1024, 1024);
    }
}

