/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.utils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.ypx.imagepicker.R;

public class PPermissionUtils {
    private Context context;

    public static boolean hasCameraPermissions(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA") != 0) {
            activity.requestPermissions(new String[]{"android.permission.CAMERA"}, 1431);
            return false;
        }
        return true;
    }

    public static boolean hasStoragePermissions(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            activity.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1432);
            return false;
        }
        return true;
    }

    public static PPermissionUtils create(Context context) {
        return new PPermissionUtils(context);
    }

    public PPermissionUtils(Context context) {
        this.context = context;
    }

    public void showSetPermissionDialog(final String msg) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setMessage((CharSequence)msg);
        builder.setCancelable(false);
        builder.setNegativeButton((CharSequence)this.context.getString(R.string.picker_str_permission_refuse_setting), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
                if (msg.equals(PPermissionUtils.this.context.getString(R.string.picker_str_storage_permission))) {
                    ((Activity)PPermissionUtils.this.context).finish();
                }
            }
        });
        builder.setPositiveButton((CharSequence)this.context.getString(R.string.picker_str_permission_go_setting), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
                PPermissionUtils.this.gotoPermissionSet();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public void gotoPermissionSet() {
        String brand = Build.BRAND;
        if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"redmi") || TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"xiaomi")) {
            this.gotoMiuiPermission();
        } else if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"meizu")) {
            this.gotoMeizuPermission();
        } else if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"huawei") || TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"honor")) {
            this.gotoHuaweiPermission();
        } else {
            this.context.startActivity(this.getAppDetailSettingIntent());
        }
    }

    private void gotoMiuiPermission() {
        try {
            Intent localIntent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            localIntent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
            localIntent.putExtra("extra_pkgname", this.context.getPackageName());
            this.context.startActivity(localIntent);
        }
        catch (Exception e) {
            try {
                Intent localIntent = new Intent("miui.intent.action.APP_PERM_EDITOR");
                localIntent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
                localIntent.putExtra("extra_pkgname", this.context.getPackageName());
                this.context.startActivity(localIntent);
            }
            catch (Exception e1) {
                this.context.startActivity(this.getAppDetailSettingIntent());
            }
        }
    }

    private void gotoMeizuPermission() {
        try {
            Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("packageName", "com.ypx.imagepicker");
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.startActivity(this.getAppDetailSettingIntent());
        }
    }

    private void gotoHuaweiPermission() {
        try {
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.startActivity(this.getAppDetailSettingIntent());
        }
    }

    private Intent getAppDetailSettingIntent() {
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        localIntent.setData(Uri.fromParts((String)"package", (String)this.context.getPackageName(), null));
        return localIntent;
    }
}

