/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import com.ypx.imagepicker.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public class PDateUtil {
    public static String getStrTime(Context context, long cc_time) {
        Date date;
        if (cc_time == 0L) {
            return "";
        }
        if (String.valueOf(cc_time).length() <= 10) {
            cc_time *= 1000L;
        }
        if (PDateUtil.isToday(date = new Date(cc_time))) {
            return context.getString(R.string.picker_str_today);
        }
        if (PDateUtil.isThisWeek(date)) {
            return context.getString(R.string.picker_str_this_week);
        }
        if (PDateUtil.isThisMonth(date)) {
            return context.getString(R.string.picker_str_this_months);
        }
        return new SimpleDateFormat(context.getString(R.string.picker_str_time_format)).format(date);
    }

    private static boolean isThisWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        int currentWeek = calendar.get(3);
        calendar.setTime(date);
        int paramWeek = calendar.get(3);
        return paramWeek == currentWeek;
    }

    private static boolean isToday(Date date) {
        return PDateUtil.isThisTime(date, "yyyy-MM-dd");
    }

    private static boolean isThisMonth(Date date) {
        return PDateUtil.isThisTime(date, "yyyy-MM");
    }

    private static boolean isThisTime(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String param = sdf.format(date);
        String now = sdf.format(new Date());
        return param.equals(now);
    }

    public static String getVideoDuration(long timestamp) {
        if (timestamp < 1000L) {
            return "00:01";
        }
        Date date = new Date(timestamp);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String formatTime(Context context, Long ms) {
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = ms / (long)dd.intValue();
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        long milliSecond = ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue() - second * (long)ss.intValue();
        StringBuilder sb = new StringBuilder();
        if (day > 0L) {
            sb.append(day).append(context.getString(R.string.picker_str_day));
        }
        if (hour > 0L) {
            sb.append(hour).append(context.getString(R.string.picker_str_hour));
        }
        if (minute > 0L) {
            sb.append(minute).append(context.getString(R.string.picker_str_minute));
        }
        if (second > 0L) {
            sb.append(second).append(context.getString(R.string.picker_str_second));
        }
        if (milliSecond > 0L) {
            sb.append(milliSecond).append(context.getString(R.string.picker_str_milli));
        }
        return sb.toString();
    }
}

