/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.utils;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.widget.CheckBox;

public class PCornerUtils {
    public static Drawable cornerDrawable(int bgColor, float cornerradius) {
        GradientDrawable bg = new GradientDrawable();
        bg.setCornerRadius(cornerradius);
        bg.setColor(bgColor);
        return bg;
    }

    public static Drawable cornerDrawableAndStroke(int bgColor, float cornerradius, int strokeWidth, int strokeColor) {
        GradientDrawable bg = new GradientDrawable();
        bg.setCornerRadius(cornerradius);
        bg.setColor(bgColor);
        bg.setStroke(strokeWidth, strokeColor);
        return bg;
    }

    public static Drawable cornerDrawable(float cornerradius) {
        GradientDrawable bg = new GradientDrawable();
        bg.setCornerRadius(cornerradius);
        return bg;
    }

    public static Drawable cornerDrawable(int bgColor, float[] cornerradius) {
        GradientDrawable bg = new GradientDrawable();
        bg.setCornerRadii(cornerradius);
        bg.setColor(bgColor);
        return bg;
    }

    public static Drawable cornerDrawable(int bgColor, float[] cornerradius, int borderwidth, int bordercolor) {
        GradientDrawable bg = new GradientDrawable();
        bg.setCornerRadii(cornerradius);
        bg.setStroke(borderwidth, bordercolor);
        bg.setColor(bgColor);
        return bg;
    }

    public static StateListDrawable btnSelector(Drawable normal, Drawable pressed) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(new int[]{-16842919}, normal);
        bg.addState(new int[]{16842919}, pressed);
        return bg;
    }

    public static StateListDrawable btnSelector(float radius, int normalColor, int pressColor, int postion) {
        StateListDrawable bg = new StateListDrawable();
        Drawable normal = null;
        Drawable pressed = null;
        if (postion == 0) {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, radius, radius});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, radius, radius});
        } else if (postion == 1) {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, 0.0f, 0.0f});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, 0.0f, 0.0f});
        } else if (postion == -1) {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
        } else if (postion == -2) {
            normal = PCornerUtils.cornerDrawable(normalColor, radius);
            pressed = PCornerUtils.cornerDrawable(pressColor, radius);
        }
        bg.addState(new int[]{-16842919}, normal);
        bg.addState(new int[]{16842919}, pressed);
        return bg;
    }

    public static StateListDrawable listItemSelector(float radius, int normalColor, int pressColor, boolean isLastPostion) {
        StateListDrawable bg = new StateListDrawable();
        ColorDrawable normal = null;
        ColorDrawable pressed = null;
        if (!isLastPostion) {
            normal = new ColorDrawable(normalColor);
            pressed = new ColorDrawable(pressColor);
        } else {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
        }
        bg.addState(new int[]{-16842919}, (Drawable)normal);
        bg.addState(new int[]{16842919}, (Drawable)pressed);
        return bg;
    }

    public static StateListDrawable listItemSelector(float radius, int normalColor, int pressColor, int itemTotalSize, int itemPosition) {
        StateListDrawable bg = new StateListDrawable();
        ColorDrawable normal = null;
        ColorDrawable pressed = null;
        if (itemPosition == 0 && itemPosition == itemTotalSize - 1) {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{radius, radius, radius, radius, radius, radius, radius, radius});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{radius, radius, radius, radius, radius, radius, radius, radius});
        } else if (itemPosition == 0) {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{radius, radius, radius, radius, 0.0f, 0.0f, 0.0f, 0.0f});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{radius, radius, radius, radius, 0.0f, 0.0f, 0.0f, 0.0f});
        } else if (itemPosition == itemTotalSize - 1) {
            normal = PCornerUtils.cornerDrawable(normalColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
            pressed = PCornerUtils.cornerDrawable(pressColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius});
        } else {
            normal = new ColorDrawable(normalColor);
            pressed = new ColorDrawable(pressColor);
        }
        bg.addState(new int[]{-16842919}, (Drawable)normal);
        bg.addState(new int[]{16842919}, (Drawable)pressed);
        return bg;
    }

    public static void setCheckBoxDrawable(CheckBox checkBox, int selectedDrawableID, int unSelectedDrawableID) {
        StateListDrawable checkBoxDrawable = new StateListDrawable();
        checkBoxDrawable.addState(new int[]{0x10100A1}, checkBox.getResources().getDrawable(selectedDrawableID));
        checkBoxDrawable.addState(new int[]{0x10100A0}, checkBox.getResources().getDrawable(selectedDrawableID));
        checkBoxDrawable.addState(new int[0], checkBox.getResources().getDrawable(unSelectedDrawableID));
        checkBox.setCompoundDrawablesWithIntrinsicBounds((Drawable)checkBoxDrawable, null, null, null);
    }

    public static void setCheckBoxDrawable(CheckBox checkBox, Drawable selectedDrawable, Drawable unSelectedDrawable) {
        StateListDrawable checkBoxDrawable = new StateListDrawable();
        checkBoxDrawable.addState(new int[]{0x10100A1}, selectedDrawable);
        checkBoxDrawable.addState(new int[]{0x10100A0}, selectedDrawable);
        checkBoxDrawable.addState(new int[0], unSelectedDrawable);
        checkBox.setCompoundDrawablesWithIntrinsicBounds((Drawable)checkBoxDrawable, null, null, null);
    }
}

