/*
 * Decompiled with CFR 0.152.
 */
package com.ypx.imagepicker.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.view.View;
import com.ypx.imagepicker.ImagePicker;
import com.ypx.imagepicker.bean.MimeType;
import com.ypx.imagepicker.bean.UriPathInfo;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;

public class PBitmapUtils {
    public static int[] getImageWidthHeight(Context c, Uri uri) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = c.getContentResolver().openFileDescriptor(uri, "r");
            if (parcelFileDescriptor != null) {
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                Bitmap image = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
                parcelFileDescriptor.close();
                return new int[]{image.getWidth(), image.getHeight()};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new int[]{0, 0};
    }

    public static Bitmap getBitmapFromUri(Context c, Uri uri) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = c.getContentResolver().openFileDescriptor(uri, "r");
            if (parcelFileDescriptor != null) {
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                Bitmap image = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
                parcelFileDescriptor.close();
                return image;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int[] getImageWidthHeight(String path) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            return new int[]{options.outWidth, options.outHeight};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{0, 0};
        }
    }

    public static File getPickerFileDirectory(Context context) {
        File file = new File(context.getExternalFilesDir(null), ImagePicker.DEFAULT_FILE_NAME);
        if (!file.exists() && file.mkdirs()) {
            return file;
        }
        return file;
    }

    public static File getDCIMDirectory() {
        File dcim = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        if (!dcim.exists()) {
            dcim = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        }
        return dcim;
    }

    public static String saveBitmapToFile(Context context, Bitmap bitmap, String fileName, Bitmap.CompressFormat compressFormat) {
        File file = PBitmapUtils.getPickerFileDirectory(context);
        file = new File(file, fileName + "." + compressFormat.toString().toLowerCase());
        try {
            FileOutputStream b = new FileOutputStream(file);
            bitmap.compress(compressFormat, 90, (OutputStream)b);
            b.flush();
            b.close();
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (file.exists()) {
                file.delete();
            }
            return "Exception:" + e.getMessage();
        }
    }

    public static Uri saveBitmapToDCIM(Context context, Bitmap bitmap, String fileName, Bitmap.CompressFormat compressFormat) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileName);
        contentValues.put("mime_type", "image/" + compressFormat.toString());
        contentValues.put("width", Integer.valueOf(bitmap.getWidth()));
        contentValues.put("height", Integer.valueOf(bitmap.getHeight()));
        String suffix = "." + compressFormat.toString().toLowerCase();
        String path = PBitmapUtils.getDCIMDirectory().getAbsolutePath() + File.separator + fileName + suffix;
        try {
            contentValues.put("_data", path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Uri uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        if (uri != null) {
            try {
                OutputStream outputStream = context.getContentResolver().openOutputStream(uri);
                if (outputStream != null) {
                    bitmap.compress(compressFormat, 90, outputStream);
                    outputStream.flush();
                    outputStream.close();
                    return uri;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return uri;
            }
        }
        return uri;
    }

    public static UriPathInfo copyFileToDCIM(Context context, String sourceFilePath, String fileName, MimeType mimeType) {
        boolean isImage;
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileName);
        contentValues.put("mime_type", mimeType.toString());
        if (Build.VERSION.SDK_INT >= 29) {
            contentValues.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        }
        if (isImage = MimeType.isImage(mimeType.toString())) {
            int[] size = PBitmapUtils.getImageWidthHeight(sourceFilePath);
            contentValues.put("width", Integer.valueOf(size[0]));
            contentValues.put("height", Integer.valueOf(size[1]));
        } else {
            long duration = PBitmapUtils.getLocalVideoDuration(sourceFilePath);
            contentValues.put("duration", Long.valueOf(duration));
        }
        String suffix = "." + mimeType.getSuffix();
        String path = PBitmapUtils.getDCIMDirectory().getAbsolutePath() + File.separator + fileName + suffix;
        try {
            contentValues.put("_data", path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Uri uri = context.getContentResolver().insert(isImage ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues);
        PBitmapUtils.copyFile(context, sourceFilePath, uri);
        return new UriPathInfo(uri, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(Context context, String sourceFilePath, Uri insertUri) {
        if (insertUri == null) {
            return false;
        }
        ContentResolver resolver = context.getContentResolver();
        InputStream is = null;
        OutputStream os = null;
        try {
            os = resolver.openOutputStream(insertUri);
            if (os == null) {
                boolean bl = false;
                return bl;
            }
            File sourceFile = new File(sourceFilePath);
            if (sourceFile.exists()) {
                is = new FileInputStream(sourceFile);
                boolean bl = PBitmapUtils.copyFileWithStream(os, is);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFileWithStream(OutputStream os, InputStream is) {
        if (os == null || is == null) {
            return false;
        }
        int read = 0;
        try {
            byte[] buffer = new byte[1444];
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
                os.flush();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap getViewBitmap(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000));
        view.setDrawingCacheQuality(0x100000);
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache(true);
        return view.getDrawingCache(true);
    }

    public static Bitmap getVideoThumb(String path) {
        MediaMetadataRetriever media = new MediaMetadataRetriever();
        media.setDataSource(path);
        return media.getFrameAtTime();
    }

    public static long getLocalVideoDuration(String videoPath) {
        int duration;
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(videoPath);
            duration = Integer.parseInt(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
        return duration;
    }

    public static void refreshGalleryAddPic(Context context, Uri uri) {
        if (context == null) {
            return;
        }
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(uri);
        context.sendBroadcast(mediaScanIntent);
    }

    public static String getMimeTypeFromUri(Activity context, Uri uri) {
        ContentResolver resolver = context.getContentResolver();
        return resolver.getType(uri);
    }

    public static String getMimeTypeFromPath(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        return fileNameMap.getContentTypeFor(new File(path).getName());
    }

    public static Uri getImageContentUri(Context context, String path) {
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{path}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            cursor.close();
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id2));
        }
        return null;
    }

    public static Uri getVideoContentUri(Context context, String path) {
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{path}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            cursor.close();
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id2));
        }
        return null;
    }

    public static Uri getContentUri(String mimeType, long id2) {
        if (id2 <= 0L) {
            return null;
        }
        Uri contentUri = MimeType.isImage(mimeType) ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (MimeType.isVideo(mimeType) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Files.getContentUri((String)"external"));
        return ContentUris.withAppendedId((Uri)contentUri, (long)id2);
    }
}

